/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.events;

import dev.architectury.event.Event;
import dev.architectury.event.EventActor;
import dev.architectury.event.EventFactory;
import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.util.Date;
import java.util.List;
import net.minecraft.class_3222;

public class ObjectCompletedEvent<T extends QuestObject> {
    public static final Event<EventActor<ObjectCompletedEvent<?>>> GENERIC = EventFactory.createEventActorLoop((Object[])new ObjectCompletedEvent[0]);
    public static final Event<EventActor<FileEvent>> FILE = EventFactory.createEventActorLoop((Object[])new FileEvent[0]);
    public static final Event<EventActor<ChapterEvent>> CHAPTER = EventFactory.createEventActorLoop((Object[])new ChapterEvent[0]);
    public static final Event<EventActor<QuestEvent>> QUEST = EventFactory.createEventActorLoop((Object[])new QuestEvent[0]);
    public static final Event<EventActor<TaskEvent>> TASK = EventFactory.createEventActorLoop((Object[])new TaskEvent[0]);
    private final QuestProgressEventData<T> data;

    private ObjectCompletedEvent(QuestProgressEventData<T> d) {
        this.data = d;
    }

    public boolean isCancelable() {
        return true;
    }

    public Date getTime() {
        return this.data.time;
    }

    public TeamData getData() {
        return this.data.teamData;
    }

    public T getObject() {
        return this.data.object;
    }

    public List<class_3222> getOnlineMembers() {
        return this.data.onlineMembers;
    }

    public List<class_3222> getNotifiedPlayers() {
        return this.data.notifiedPlayers;
    }

    @Deprecated
    public TeamData getTeam() {
        return this.getData();
    }

    static {
        FILE.register(event -> ((EventActor)GENERIC.invoker()).act(event));
        CHAPTER.register(event -> ((EventActor)GENERIC.invoker()).act(event));
        QUEST.register(event -> ((EventActor)GENERIC.invoker()).act(event));
        TASK.register(event -> ((EventActor)GENERIC.invoker()).act(event));
    }

    public static class FileEvent
    extends ObjectCompletedEvent<QuestFile> {
        public FileEvent(QuestProgressEventData<QuestFile> d) {
            super(d);
        }

        public QuestFile getFile() {
            return (QuestFile)this.getObject();
        }
    }

    public static class ChapterEvent
    extends ObjectCompletedEvent<Chapter> {
        public ChapterEvent(QuestProgressEventData<Chapter> d) {
            super(d);
        }

        public Chapter getChapter() {
            return (Chapter)this.getObject();
        }
    }

    public static class QuestEvent
    extends ObjectCompletedEvent<Quest> {
        public QuestEvent(QuestProgressEventData<Quest> d) {
            super(d);
        }

        public Quest getQuest() {
            return (Quest)this.getObject();
        }
    }

    public static class TaskEvent
    extends ObjectCompletedEvent<Task> {
        public TaskEvent(QuestProgressEventData<Task> d) {
            super(d);
        }

        public Task getTask() {
            return (Task)this.getObject();
        }
    }
}

