/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import org.jetbrains.annotations.Nullable;

public class SelectQuestObjectScreen<T extends QuestObjectBase>
extends ButtonListBaseScreen {
    private final ConfigQuestObject<T> config;
    private final ConfigCallback callback;

    public SelectQuestObjectScreen(ConfigQuestObject<T> c, ConfigCallback cb) {
        this.setTitle((class_2561)new class_2588("ftbquests.gui.select_quest_object"));
        this.setHasSearchBox(true);
        this.focus();
        this.setBorder(1, 1, 1);
        this.config = c;
        this.callback = cb;
    }

    public boolean keyPressed(Key key) {
        if (key.esc()) {
            this.onBack();
            return true;
        }
        return super.keyPressed(key);
    }

    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return false;
        }
        return false;
    }

    public void addButtons(Panel panel) {
        ArrayList<QuestObjectBase> list = new ArrayList<QuestObjectBase>();
        for (QuestObjectBase objectBase : ClientQuestFile.INSTANCE.getAllObjects()) {
            if (!this.config.predicate.test(objectBase)) continue;
            list.add(objectBase);
        }
        list.sort((o1, o2) -> {
            int i = Integer.compare(o1.getObjectType().ordinal(), o2.getObjectType().ordinal());
            return i == 0 ? o1.getTitle().getString().compareToIgnoreCase(o2.getTitle().getString()) : i;
        });
        if (this.config.predicate.test(null)) {
            panel.add((Widget)new QuestObjectButton(this, panel, null));
        }
        for (QuestObjectBase objectBase : list) {
            panel.add((Widget)new QuestObjectButton(this, panel, objectBase));
        }
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public static class QuestObjectButton
    extends SimpleTextButton {
        public final T object;
        final /* synthetic */ SelectQuestObjectScreen this$0;

        public QuestObjectButton(@Nullable Panel panel, T o) {
            this.this$0 = this$0;
            super(panel, (class_2561)(o == null ? new class_2588("ftbquests.null") : ((QuestObjectBase)o).getMutableTitle().method_27692(((QuestObjectBase)o).getObjectType().getColor())), (Icon)(o == null ? Icon.EMPTY : ((QuestObjectBase)o).getIcon()));
            this.object = o;
            this.setSize(200, 14);
        }

        private void addObject(TooltipList list, QuestObjectBase o) {
            list.add((class_2561)QuestObjectType.NAME_MAP.getDisplayName((Object)o.getObjectType()).method_27661().method_27692(class_124.field_1080).method_27693(": ").method_10852((class_2561)o.getMutableTitle().method_27692(o.getObjectType().getColor())));
        }

        public void addMouseOverText(TooltipList list) {
            if (this.object == null) {
                return;
            }
            list.add(((QuestObjectBase)this.object).getTitle());
            list.add((class_2561)new class_2585("ID: ").method_27692(class_124.field_1080).method_10852((class_2561)new class_2585(((QuestObjectBase)this.object).toString()).method_27692(class_124.field_1063)));
            list.add((class_2561)new class_2585("Type: ").method_27692(class_124.field_1080).method_10852((class_2561)QuestObjectType.NAME_MAP.getDisplayName((Object)((QuestObjectBase)this.object).getObjectType()).method_27661().method_27692(((QuestObjectBase)this.object).getObjectType().getColor())));
            if (this.object instanceof Quest) {
                Quest quest = (Quest)this.object;
                this.addObject(list, quest.chapter);
                if (quest.rewards.size() == 1) {
                    this.addObject(list, quest.rewards.get(0));
                } else if (!quest.rewards.isEmpty()) {
                    list.add((class_2561)new class_2588("ftbquests.rewards").method_27692(class_124.field_1080));
                    for (Reward reward : quest.rewards) {
                        list.add((class_2561)new class_2585("  ").method_10852((class_2561)reward.getMutableTitle().method_27692(QuestObjectType.REWARD.getColor())));
                    }
                }
            } else if (this.object instanceof Task) {
                Quest quest = ((Task)this.object).quest;
                this.addObject(list, quest.chapter);
                this.addObject(list, quest);
                if (quest.rewards.size() == 1) {
                    this.addObject(list, quest.rewards.get(0));
                } else if (!quest.rewards.isEmpty()) {
                    list.add((class_2561)new class_2588("ftbquests.rewards").method_27692(class_124.field_1080));
                    for (Reward reward : quest.rewards) {
                        list.add((class_2561)new class_2585("  ").method_10852((class_2561)reward.getMutableTitle().method_27692(QuestObjectType.REWARD.getColor())));
                    }
                }
            } else if (this.object instanceof Reward) {
                Quest quest = ((Reward)this.object).quest;
                this.addObject(list, quest.chapter);
                this.addObject(list, quest);
            } else if (this.object instanceof RewardTable) {
                ((RewardTable)this.object).addMouseOverText(list, true, true);
            }
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            this.this$0.config.setCurrentValue(this.object);
            this.this$0.callback.save(true);
        }
    }
}

