/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.latvian.mods.itemfilters.api.IStringValueFilter;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import dev.latvian.mods.itemfilters.api.ItemFiltersItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class TaskButton
extends Button {
    public final QuestScreen questScreen;
    public Task task;

    public TaskButton(Panel panel, Task t) {
        super(panel, t.getTitle(), Icons.ACCEPT);
        this.questScreen = (QuestScreen)panel.getGui();
        this.task = t;
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (button.isRight() || this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            this.task.onButtonClicked(this, !this.task.invalid && this.questScreen.file.self.canStartTasks(this.task.quest) && !this.questScreen.file.self.isCompleted(this.task));
        } else if (button.isRight() && this.questScreen.file.canEdit()) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            if (this.task instanceof ItemTask) {
                final ItemTask i = (ItemTask)this.task;
                final List<class_2960> tags = i.item.method_7909().method_40131().method_40228().map(class_6862::comp_327).toList();
                if (!tags.isEmpty() && !ItemFiltersAPI.isFilter((class_1799)i.item)) {
                    contextMenu.add(new ContextMenuItem((class_2561)new class_2588("ftbquests.task.ftbquests.item.convert_tag"), (Icon)ThemeProperties.RELOAD_ICON.get(), () -> {
                        final class_1799 tagFilter = new class_1799((class_1935)ItemFiltersItems.TAG.get());
                        if (tags.size() == 1) {
                            String tag = ((class_2960)tags.iterator().next()).toString();
                            ((IStringValueFilter)tagFilter.method_7909()).setValue(tagFilter, tag);
                            i.item = tagFilter;
                            if (i.title.isEmpty()) {
                                i.title = "Any #" + tag;
                            }
                            new EditObjectMessage(i).sendToServer();
                        } else {
                            new ButtonListBaseScreen(){

                                public void addButtons(Panel panel) {
                                    for (final class_2960 s : tags) {
                                        panel.add((Widget)new SimpleTextButton(panel, (class_2561)new class_2585(s.toString()), (Icon)Icon.EMPTY){

                                            public void onClicked(MouseButton button) {
                                                TaskButton.this.questScreen.openGui();
                                                ((IStringValueFilter)tagFilter.method_7909()).setValue(tagFilter, s.toString());
                                                i.item = tagFilter;
                                                if (i.title.isEmpty()) {
                                                    i.title = "Any #" + s;
                                                }
                                                new EditObjectMessage(i).sendToServer();
                                            }
                                        });
                                    }
                                }
                            }.openGui();
                        }
                    }));
                    contextMenu.add(ContextMenuItem.SEPARATOR);
                }
            }
            this.questScreen.addObjectMenuItems(contextMenu, (Runnable)this.getGui(), this.task);
            this.getGui().openContextMenu(contextMenu);
        }
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return this.task.getIngredient();
    }

    public void addMouseOverText(TooltipList list) {
        this.questScreen.addInfoTooltip(list, this.task);
        if (this.task.addTitleInMouseOverText()) {
            list.add(this.getTitle());
        }
        this.task.addMouseOverHeader(list, this.questScreen.file.self, class_310.method_1551().field_1690.field_1827);
        if (this.questScreen.file.self.canStartTasks(this.task.quest)) {
            long maxp = this.task.getMaxProgress();
            long progress = this.questScreen.file.self.getProgress(this.task);
            if (maxp > 1L) {
                if (this.task.hideProgressNumbers()) {
                    list.add((class_2561)new class_2585("[" + this.task.getRelativeProgressFromChildren(this.questScreen.file.self) + "%]").method_27692(class_124.field_1077));
                } else {
                    String max = TaskButton.isShiftKeyDown() ? Long.toUnsignedString(maxp) : this.task.formatMaxProgress();
                    String prog = TaskButton.isShiftKeyDown() ? Long.toUnsignedString(progress) : this.task.formatProgress(this.questScreen.file.self, progress);
                    String s = (progress > maxp ? max : prog) + " / " + max;
                    if (maxp < 100L) {
                        list.add((class_2561)new class_2585(s).method_27692(class_124.field_1077));
                    } else {
                        list.add((class_2561)new class_2585(s).method_27692(class_124.field_1077).method_10852((class_2561)new class_2585(" [" + this.task.getRelativeProgressFromChildren(this.questScreen.file.self) + "%]").method_27692(class_124.field_1063)));
                    }
                }
            }
        }
        this.task.addMouseOverText(list, this.questScreen.file.self);
    }

    public void drawBackground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(matrixStack, theme, x, y, w, h);
        }
    }

    public void drawIcon(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        this.task.drawGUI(this.questScreen.file.self, matrixStack, x, y, w, h);
    }

    public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        int bs = h >= 32 ? 32 : 16;
        GuiHelper.setupDrawing();
        this.drawBackground(matrixStack, theme, x, y, w, h);
        this.drawIcon(matrixStack, theme, x + (w - bs) / 2, y + (h - bs) / 2, bs, bs);
        if (this.questScreen.file.self == null) {
            return;
        }
        if (this.questScreen.contextMenu != null) {
            // empty if block
        }
        if (this.questScreen.file.self.isCompleted(this.task)) {
            matrixStack.method_22903();
            matrixStack.method_22904(0.0, 0.0, 200.0);
            RenderSystem.enableBlend();
            ((Icon)ThemeProperties.CHECK_ICON.get()).draw(matrixStack, x + w - 9, y + 1, 8, 8);
            matrixStack.method_22909();
        } else {
            class_5250 s = this.task.getButtonText();
            if (s != class_2585.field_24366) {
                matrixStack.method_22903();
                matrixStack.method_22904((double)((float)x + 19.0f - (float)theme.getStringWidth((class_5348)s) / 2.0f), (double)((float)y + 15.0f), 200.0);
                matrixStack.method_22905(0.5f, 0.5f, 1.0f);
                RenderSystem.enableBlend();
                theme.drawString(matrixStack, (Object)s, 0.0f, 0.0f, Color4I.WHITE, 2);
                matrixStack.method_22909();
            }
        }
    }
}

