/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.TeamData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import org.jetbrains.annotations.Nullable;

public class ChapterGroup
extends QuestObject {
    public final QuestFile file;
    public final List<Chapter> chapters;
    public boolean guiCollapsed;

    public ChapterGroup(QuestFile f) {
        this.file = f;
        this.chapters = new ArrayList<Chapter>();
        this.guiCollapsed = false;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.CHAPTER_GROUP;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.file;
    }

    public int getIndex() {
        return this.file.chapterGroups.indexOf(this);
    }

    public boolean isDefaultGroup() {
        return this == this.file.defaultChapterGroup;
    }

    @Override
    public void onCreated() {
        this.file.chapterGroups.add(this);
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (Chapter chapter : this.chapters) {
            chapter.clearCachedData();
        }
    }

    @Override
    public void deleteSelf() {
        this.file.chapterGroups.remove(this);
        for (Chapter chapter : this.chapters) {
            chapter.group = this.file.defaultChapterGroup;
            this.file.defaultChapterGroup.chapters.add(chapter);
        }
        super.deleteSelf();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        config.addString("title", this.title, v -> {
            this.title = v;
        }, "").setNameKey("ftbquests.title").setOrder(-127);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void editedFromGUI() {
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null) {
            gui.chapterPanel.refreshWidgets();
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_2561 getAltTitle() {
        return new class_2585("Unnamed Group");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (Chapter chapter : this.chapters) {
            list.add(chapter.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public boolean isVisible(TeamData data) {
        for (Chapter chapter : this.chapters) {
            if (!chapter.isVisible(data)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getRelativeProgressFromChildren(TeamData data) {
        if (this.chapters.isEmpty()) {
            return 100;
        }
        int progress = 0;
        for (Chapter chapter : this.chapters) {
            progress += data.getRelativeProgress(chapter);
        }
        return ChapterGroup.getRelativeProgressFromChildren(progress, this.chapters.size());
    }

    @Override
    public void onCompleted(QuestProgressEventData<?> data) {
        data.teamData.setCompleted(this.id, data.time);
        if (this.file.isCompletedRaw(data.teamData)) {
            this.file.onCompleted(data.withObject(this.file));
        }
    }

    public List<Chapter> getVisibleChapters(TeamData data) {
        if (this.file.canEdit()) {
            return this.chapters;
        }
        ArrayList<Chapter> list = new ArrayList<Chapter>();
        for (Chapter chapter : this.chapters) {
            if (chapter.quests.isEmpty() || !chapter.isVisible(data)) continue;
            list.add(chapter);
        }
        return list;
    }

    @Nullable
    public Chapter getFirstVisibleChapter(TeamData data) {
        if (this.chapters.isEmpty()) {
            return null;
        }
        if (this.file.canEdit()) {
            return this.chapters.get(0);
        }
        for (Chapter chapter : this.chapters) {
            if (chapter.quests.isEmpty() || !chapter.isVisible(data)) continue;
            return chapter;
        }
        return null;
    }

    @Override
    public Collection<? extends QuestObject> getChildren() {
        return this.chapters;
    }

    @Override
    public boolean hasUnclaimedRewardsRaw(TeamData teamData, UUID player) {
        for (Chapter chapter : this.chapters) {
            if (!teamData.hasUnclaimedRewards(player, chapter)) continue;
            return true;
        }
        return false;
    }
}

