/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import com.mojang.util.UUIDTypeAdapter;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.net.CreateOtherTeamDataMessage;
import dev.ftb.mods.ftbquests.net.DeleteObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.SyncQuestsMessage;
import dev.ftb.mods.ftbquests.net.SyncTeamDataMessage;
import dev.ftb.mods.ftbquests.net.TeamDataChangedMessage;
import dev.ftb.mods.ftbquests.net.TeamDataUpdate;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.util.FTBQuestsInventoryListener;
import dev.ftb.mods.ftbquests.util.FileUtils;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.TeamBase;
import dev.ftb.mods.ftbteams.event.PlayerChangedTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.event.TeamCreatedEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.class_1712;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class ServerQuestFile
extends QuestFile {
    public static final class_5218 FTBQUESTS_DATA = new class_5218("ftbquests");
    public static ServerQuestFile INSTANCE;
    public final MinecraftServer server;
    private boolean shouldSave;
    private boolean isLoading;
    private Path folder;
    private class_3222 currentPlayer = null;

    public ServerQuestFile(MinecraftServer s) {
        this.server = s;
        this.shouldSave = false;
        this.isLoading = false;
        int taskTypeId = 0;
        for (TaskType type : TaskTypes.TYPES.values()) {
            type.intId = ++taskTypeId;
            this.taskTypeIds.put(type.intId, (Object)type);
        }
        int rewardTypeId = 0;
        for (RewardType type : RewardTypes.TYPES.values()) {
            type.intId = ++rewardTypeId;
            this.rewardTypeIds.put(type.intId, (Object)type);
        }
    }

    @Override
    public void load() {
        Path path;
        this.folder = Platform.getConfigFolder().resolve("ftbquests/quests");
        if (Files.exists(this.folder, new LinkOption[0])) {
            FTBQuests.LOGGER.info("Loading quests from " + this.folder);
            this.isLoading = true;
            this.readDataFull(this.folder);
            this.isLoading = false;
        }
        if (Files.exists(path = this.server.method_27050(FTBQUESTS_DATA), new LinkOption[0])) {
            try {
                Files.list(path).filter(p -> p.getFileName().toString().contains("-") && p.getFileName().toString().endsWith(".snbt")).forEach(path1 -> {
                    SNBTCompoundTag nbt = SNBT.read((Path)path1);
                    if (nbt != null) {
                        try {
                            UUID uuid = UUIDTypeAdapter.fromString((String)nbt.method_10558("uuid"));
                            TeamData data = new TeamData(uuid);
                            data.file = this;
                            this.addData(data, true);
                            data.deserializeNBT(nbt);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public Env getSide() {
        return Env.SERVER;
    }

    @Override
    public boolean isLoading() {
        return this.isLoading;
    }

    @Override
    public Path getFolder() {
        return this.folder;
    }

    @Override
    public void deleteObject(long id) {
        QuestObjectBase object = this.getBase(id);
        if (object != null) {
            String file = object.getPath();
            object.deleteChildren();
            object.deleteSelf();
            this.refreshIDMap();
            this.save();
            if (file != null) {
                FileUtils.delete(this.getFolder().resolve(file).toFile());
            }
        }
        new DeleteObjectResponseMessage(id).sendToAll(this.server);
    }

    @Override
    public void save() {
        this.shouldSave = true;
    }

    public void saveNow() {
        if (this.shouldSave) {
            this.writeDataFull(this.getFolder());
            this.shouldSave = false;
        }
        Path path = this.server.method_27050(FTBQUESTS_DATA);
        for (TeamData data : this.getAllData()) {
            if (!data.shouldSave) continue;
            SNBT.write((Path)path.resolve(data.uuid + ".snbt"), (class_2487)data.serializeNBT());
            data.shouldSave = false;
        }
    }

    public void unload() {
        this.saveNow();
        this.deleteChildren();
        this.deleteSelf();
    }

    public class_3222 getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void withPlayerContext(class_3222 player, Runnable toDo) {
        this.currentPlayer = player;
        try {
            toDo.run();
        }
        finally {
            this.currentPlayer = null;
        }
    }

    public void playerLoggedIn(PlayerLoggedInAfterTeamEvent event) {
        class_3222 player = event.getPlayer();
        TeamData data = this.getData((TeamBase)event.getTeam());
        new SyncQuestsMessage(this).sendTo(player);
        Iterator iterator = this.teamDataMap.values().iterator();
        while (iterator.hasNext()) {
            TeamData teamData;
            new SyncTeamDataMessage(teamData, (teamData = (TeamData)iterator.next()) == data).sendTo(player);
        }
        player.field_7498.method_7596((class_1712)new FTBQuestsInventoryListener(player));
        if (!data.isLocked()) {
            this.withPlayerContext(player, () -> {
                for (ChapterGroup group : this.chapterGroups) {
                    for (Chapter chapter : group.chapters) {
                        for (Quest quest : chapter.quests) {
                            if (!data.isCompleted(quest) && quest.isCompletedRaw(data)) {
                                quest.onCompleted(new QuestProgressEventData<Quest>(new Date(), data, quest, data.getOnlineMembers(), Collections.singletonList(player)));
                            }
                            data.checkAutoCompletion(quest);
                            if (!data.canStartTasks(quest)) continue;
                            for (Task task : quest.tasks) {
                                if (!task.checkOnLogin()) continue;
                                task.submitTask(data, player);
                            }
                        }
                    }
                }
            });
        }
    }

    public void teamCreated(TeamCreatedEvent event) {
        String displayName;
        UUID id = event.getTeam().getId();
        TeamData data = (TeamData)this.teamDataMap.get(id);
        if (data == null) {
            data = new TeamData(id);
            data.file = this;
            data.save();
        }
        if (!data.name.equals(displayName = event.getTeam().getDisplayName())) {
            data.name = displayName;
            data.save();
        }
        this.addData(data, false);
        if (event.getTeam() instanceof PartyTeam) {
            PlayerTeam pt = event.getTeam().manager.getInternalPlayerTeam(event.getCreator().method_5667());
            TeamData oldTeamData = this.getData((TeamBase)pt);
            data.copyData(oldTeamData);
        }
        TeamDataUpdate self = new TeamDataUpdate(data);
        new CreateOtherTeamDataMessage(self).sendToAll(this.server);
    }

    public void playerChangedTeam(PlayerChangedTeamEvent event) {
        if (event.getPreviousTeam().isPresent()) {
            TeamData oldTeamData = this.getData((TeamBase)event.getPreviousTeam().get());
            TeamData newTeamData = this.getData((TeamBase)event.getTeam());
            if (event.getPreviousTeam().get() instanceof PlayerTeam && event.getTeam() instanceof PartyTeam && !((PartyTeam)event.getTeam()).isOwner(event.getPlayerId())) {
                newTeamData.mergeData(oldTeamData);
            }
            new TeamDataChangedMessage(new TeamDataUpdate(oldTeamData), new TeamDataUpdate(newTeamData)).sendToAll(this.server);
            new SyncTeamDataMessage(newTeamData, true).sendTo(event.getTeam().getOnlineMembers());
        }
    }
}

