/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.gui.CustomToast;
import dev.ftb.mods.ftbquests.gui.quests.ValidItemsScreen;
import dev.ftb.mods.ftbquests.integration.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.item.MissingItem;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import dev.latvian.mods.itemfilters.api.IItemFilter;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_368;
import net.minecraft.class_5250;

public class ItemTask
extends Task
implements Predicate<class_1799> {
    public class_1799 item = class_1799.field_8037;
    public long count = 1L;
    public Tristate consumeItems = Tristate.DEFAULT;
    public Tristate onlyFromCrafting = Tristate.DEFAULT;
    public Tristate matchNBT = Tristate.DEFAULT;
    public boolean weakNBTmatch = false;

    public ItemTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.ITEM;
    }

    @Override
    public long getMaxProgress() {
        return this.count;
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        NBTUtils.write(nbt, "item", this.item);
        if (this.count > 1L) {
            nbt.method_10544("count", this.count);
        }
        this.consumeItems.write(nbt, "consume_items");
        this.onlyFromCrafting.write(nbt, "only_from_crafting");
        this.matchNBT.write(nbt, "match_nbt");
        if (this.weakNBTmatch) {
            nbt.method_10556("weak_nbt_match", true);
        }
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.item = NBTUtils.read(nbt, "item");
        this.count = Math.max(nbt.method_10537("count"), 1L);
        this.consumeItems = Tristate.read((class_2487)nbt, (String)"consume_items");
        this.onlyFromCrafting = Tristate.read((class_2487)nbt, (String)"only_from_crafting");
        this.matchNBT = Tristate.read((class_2487)nbt, (String)"match_nbt");
        this.weakNBTmatch = nbt.method_10577("weak_nbt_match");
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (this.count > 1L ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)2, (this.consumeItems != Tristate.DEFAULT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)4, (this.consumeItems == Tristate.TRUE ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8, (this.onlyFromCrafting != Tristate.DEFAULT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)16, (this.onlyFromCrafting == Tristate.TRUE ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)32, (this.matchNBT != Tristate.DEFAULT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)64, (this.matchNBT == Tristate.TRUE ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)128, (boolean)this.weakNBTmatch);
        buffer.method_10804(flags);
        FTBQuestsNetHandler.writeItemType(buffer, this.item);
        if (this.count > 1L) {
            buffer.method_10791(this.count);
        }
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        int flags = buffer.method_10816();
        this.item = FTBQuestsNetHandler.readItemType(buffer);
        long l = this.count = Bits.getFlag((int)flags, (int)1) ? buffer.method_10792() : 1L;
        Tristate tristate = Bits.getFlag((int)flags, (int)2) ? (Bits.getFlag((int)flags, (int)4) ? Tristate.TRUE : Tristate.FALSE) : (this.consumeItems = Tristate.DEFAULT);
        Tristate tristate2 = Bits.getFlag((int)flags, (int)8) ? (Bits.getFlag((int)flags, (int)16) ? Tristate.TRUE : Tristate.FALSE) : (this.onlyFromCrafting = Tristate.DEFAULT);
        this.matchNBT = Bits.getFlag((int)flags, (int)32) ? (Bits.getFlag((int)flags, (int)64) ? Tristate.TRUE : Tristate.FALSE) : Tristate.DEFAULT;
        this.weakNBTmatch = Bits.getFlag((int)flags, (int)128);
    }

    public List<class_1799> getValidDisplayItems() {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        ItemFiltersAPI.getDisplayItemStacks((class_1799)this.item, list);
        return list;
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        if (this.count > 1L) {
            return new class_2585(this.count + "x ").method_10852(this.item.method_7964());
        }
        return new class_2585("").method_10852(this.item.method_7964());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (class_1799 stack : this.getValidDisplayItems()) {
            class_1799 copy = stack.method_7972();
            copy.method_7939(1);
            Icon icon = ItemIcon.getItemIcon((class_1799)copy);
            if (icon.isEmpty()) continue;
            icons.add(icon);
        }
        if (icons.isEmpty()) {
            return ItemIcon.getItemIcon((class_1792)((class_1792)FTBQuestsItems.MISSING_ITEM.get()));
        }
        return IconAnimation.fromList(icons, (boolean)false);
    }

    @Override
    public boolean test(class_1799 stack) {
        if (this.item.method_7960()) {
            return true;
        }
        IItemFilter f = ItemFiltersAPI.getFilter((class_1799)this.item);
        return f != null ? f.filter(this.item, stack) : this.areItemStacksEqual(this.item, stack);
    }

    private boolean areItemStacksEqual(class_1799 stackA, class_1799 stackB) {
        if (stackA == stackB) {
            return true;
        }
        if (stackA.method_7909() != stackB.method_7909()) {
            return false;
        }
        if (!stackA.method_7985() && !stackB.method_7985()) {
            return true;
        }
        return !this.shouldMatchNBT() || (this.weakNBTmatch ? this.weakNBTmatch(stackA, stackB) : class_1799.method_7975((class_1799)stackA, (class_1799)stackB));
    }

    private boolean weakNBTmatch(class_1799 stackA, class_1799 stackB) {
        class_2487 tagA = stackA.method_7969();
        class_2487 tagB = stackB.method_7969();
        if (tagA == null && tagB == null) {
            return true;
        }
        if (tagA == null || tagB == null) {
            return false;
        }
        return tagA.method_10541().stream().allMatch(key -> tagA.method_10580(key).equals(tagB.method_10580(key)));
    }

    private boolean shouldMatchNBT() {
        return switch (this.matchNBT) {
            default -> throw new IncompatibleClassChangeError();
            case Tristate.TRUE -> true;
            case Tristate.FALSE -> false;
            case Tristate.DEFAULT -> this.item.method_7909().method_40131().method_40220(ItemFiltersAPI.CHECK_NBT_ITEM_TAG);
        };
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addItemStack("item", this.item, v -> {
            this.item = v;
        }, class_1799.field_8037, true, false).setNameKey("ftbquests.task.ftbquests.item");
        config.addLong("count", this.count, v -> {
            this.count = v;
        }, 1L, 1L, Long.MAX_VALUE);
        config.addEnum("consume_items", (Object)this.consumeItems, v -> {
            this.consumeItems = v;
        }, Tristate.NAME_MAP);
        config.addEnum("only_from_crafting", (Object)this.onlyFromCrafting, v -> {
            this.onlyFromCrafting = v;
        }, Tristate.NAME_MAP);
        config.addEnum("match_nbt", (Object)this.matchNBT, v -> {
            this.matchNBT = v;
        }, Tristate.NAME_MAP);
        config.addBool("weak_nbt_match", this.weakNBTmatch, v -> {
            this.weakNBTmatch = v;
        }, false);
    }

    @Override
    public boolean consumesResources() {
        return this.consumeItems.get(this.quest.chapter.file.defaultTeamConsumeItems);
    }

    @Override
    public boolean canInsertItem() {
        return this.consumesResources();
    }

    @Override
    public boolean submitItemsOnInventoryChange() {
        return !this.consumesResources();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        button.playClickSound();
        List<class_1799> validItems = this.getValidDisplayItems();
        if (!this.consumesResources() && validItems.size() == 1 && (Platform.isModLoaded((String)"jei") || Platform.isModLoaded((String)"roughlyenoughitems"))) {
            this.showJEIRecipe(validItems.get(0));
        } else if (validItems.isEmpty()) {
            class_310.method_1551().method_1566().method_1999((class_368)new CustomToast((class_2561)new class_2585("No valid items!"), ItemIcon.getItemIcon((class_1792)((class_1792)FTBQuestsItems.MISSING_ITEM.get())), (class_2561)new class_2585("Report this bug to modpack author!")));
        } else {
            new ValidItemsScreen(this, validItems, canClick).openGui();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void showJEIRecipe(class_1799 stack) {
        FTBQuestsJEIHelper.showRecipes(stack);
    }

    @Override
    public void addMouseOverHeader(TooltipList list, TeamData teamData, boolean advanced) {
        if (!this.title.isEmpty()) {
            return;
        }
        List lines = this.item.method_7950(FTBQuests.PROXY.getClientPlayer(), (class_1836)(advanced ? class_1836.class_1837.field_8935 : class_1836.class_1837.field_8934));
        int s = 0;
        if (!lines.isEmpty() && ((class_2561)lines.get(0)).getString().equals(this.item.method_7964().getString())) {
            s = 1;
        }
        for (int i = s; i < lines.size(); ++i) {
            list.add((class_2561)lines.get(i));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addMouseOverText(TooltipList list, TeamData teamData) {
        if (this.consumesResources()) {
            list.blankLine();
            list.add((class_2561)new class_2588("ftbquests.task.click_to_submit").method_27695(new class_124[]{class_124.field_1054, class_124.field_1073}));
        } else if (this.getValidDisplayItems().size() > 1) {
            list.blankLine();
            list.add((class_2561)new class_2588("ftbquests.task.ftbquests.item.view_items").method_27695(new class_124[]{class_124.field_1054, class_124.field_1073}));
        } else if (Platform.isModLoaded((String)"jei") || Platform.isModLoaded((String)"roughlyenoughitems")) {
            list.blankLine();
            list.add((class_2561)new class_2588("ftbquests.task.ftbquests.item.click_recipe").method_27695(new class_124[]{class_124.field_1054, class_124.field_1073}));
        }
    }

    public class_1799 insert(TeamData teamData, class_1799 stack, boolean simulate) {
        long add;
        if (!teamData.isCompleted(this) && this.test(stack) && (add = Math.min((long)stack.method_7947(), this.count - teamData.getProgress(this))) > 0L) {
            if (!simulate && teamData.file.isServerSide()) {
                teamData.addProgress(this, add);
            }
            class_1799 copy = stack.method_7972();
            copy.method_7939((int)((long)stack.method_7947() - add));
            return copy;
        }
        return stack;
    }

    @Override
    public void submitTask(TeamData teamData, class_3222 player, class_1799 craftedItem) {
        if (teamData.isCompleted(this) || this.item.method_7909() instanceof MissingItem || craftedItem.method_7909() instanceof MissingItem) {
            return;
        }
        if (!this.consumesResources()) {
            if (this.onlyFromCrafting.get(false)) {
                if (!craftedItem.method_7960() && this.test(craftedItem)) {
                    teamData.addProgress(this, craftedItem.method_7947());
                }
                return;
            }
            long c = 0L;
            for (class_1799 stack : player.method_31548().field_7547) {
                if (stack.method_7960() || !this.test(stack)) continue;
                c += (long)stack.method_7947();
            }
            if ((c = Math.min(this.count, c)) > teamData.getProgress(this)) {
                teamData.setProgress(this, c);
                return;
            }
            return;
        }
        if (!craftedItem.method_7960()) {
            return;
        }
        boolean changed = false;
        for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
            class_1799 stack1;
            class_1799 stack = (class_1799)player.method_31548().field_7547.get(i);
            if (stack == (stack1 = this.insert(teamData, stack, false))) continue;
            changed = true;
            player.method_31548().field_7547.set(i, (Object)(stack1.method_7960() ? class_1799.field_8037 : stack1));
        }
        if (changed) {
            player.method_31548().method_5431();
            player.field_7512.method_7623();
        }
    }
}

