/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import com.mojang.datafixers.util.Either;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.BooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_151;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class StructureTask
extends BooleanTask {
    private static final class_2960 DEFAULT_STRUCTURE = new class_2960("minecraft:mineshaft");
    private Either<class_5321<class_5312<?, ?>>, class_6862<class_5312<?, ?>>> structure = Either.left((Object)class_5321.method_29179((class_5321)class_2378.field_25915, (class_2960)DEFAULT_STRUCTURE));

    public StructureTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.STRUCTURE;
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10582("structure", this.getStructure());
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.setStructure(nbt.method_10558("structure"));
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10814(this.getStructure());
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.setStructure(buffer.method_10800(1024));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("structure", this.getStructure(), this::setStructure, "minecraft:mineshaft");
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return new class_2588("ftbquests.task.ftbquests.structure").method_27693(": ").method_10852((class_2561)new class_2585(this.getStructure()).method_27692(class_124.field_1077));
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    @Override
    public boolean canSubmit(TeamData teamData, class_3222 player) {
        class_3218 level = (class_3218)player.field_6002;
        return (Boolean)this.structure.map(key -> level.method_27056().method_41034(player.method_24515(), key).method_16657(), tag -> {
            class_2378 reg = (class_2378)level.method_30349().method_33310(class_2378.field_25915).orElseThrow();
            for (class_6880 holder : reg.method_40286(tag)) {
                if (!level.method_27056().method_38854(player.method_24515(), (class_5312)holder.comp_349()).method_16657()) continue;
                return true;
            }
            return false;
        });
    }

    private void setStructure(String resLoc) {
        this.structure = resLoc.startsWith("#") ? Either.right((Object)class_6862.method_40092((class_5321)class_2378.field_25915, (class_2960)this.safeResourceLocation(resLoc.substring(1)))) : Either.left((Object)class_5321.method_29179((class_5321)class_2378.field_25915, (class_2960)this.safeResourceLocation(resLoc)));
    }

    private String getStructure() {
        return (String)this.structure.map(structure -> structure.method_29177().toString(), tag -> "#" + tag.comp_327().toString());
    }

    private class_2960 safeResourceLocation(String str) {
        try {
            return new class_2960(str);
        }
        catch (class_151 e) {
            if (this.getQuestFile().isServerSide()) {
                FTBQuests.LOGGER.warn("Ignoring bad structure resource location '{}' for structure task {}", (Object)str, (Object)this.id);
            } else {
                FTBQuests.PROXY.getClientPlayer().method_7353((class_2561)new class_2585("Ignoring bad structure resource location: " + str).method_27692(class_124.field_1061), false);
            }
            return DEFAULT_STRUCTURE;
        }
    }
}

