/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.latvian.mods.itemfilters.api.IStringValueFilter;
import dev.latvian.mods.itemfilters.api.StringValueFilterVariant;
import dev.latvian.mods.itemfilters.item.StringValueFilterItem;
import dev.latvian.mods.itemfilters.net.MessageUpdateFilterItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_308;
import net.minecraft.class_327;
import net.minecraft.class_341;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class StringValueFilterScreen
extends class_437 {
    public final IStringValueFilter filter;
    public final class_1799 stack;
    public final class_1268 hand;
    private final Map<String, StringValueFilterVariant> variants;
    private final ArrayList<StringValueFilterVariant> visibleVariants;
    private class_342 nameField;
    private int selectedVariant = 0;

    public StringValueFilterScreen(IStringValueFilter f, class_1799 is, class_1268 h) {
        super(is.method_7954());
        this.filter = f;
        this.stack = is;
        this.hand = h;
        this.variants = new HashMap<String, StringValueFilterVariant>();
        for (StringValueFilterVariant variant : this.filter.getValueVariants(this.stack)) {
            this.variants.put(variant.id, variant);
        }
        this.visibleVariants = new ArrayList<StringValueFilterVariant>(this.variants.values());
        this.visibleVariants.sort(null);
    }

    public void method_25426() {
        super.method_25426();
        this.field_22787.field_1774.method_1462(true);
        int i = this.field_22789 / 2;
        int j = this.field_22790 / 2;
        int w = this.field_22789 * 3 / 4;
        this.nameField = new class_342(this.field_22793, i - w / 2, j - 6, w, 12, class_2585.field_24366);
        this.nameField.method_1868(-1);
        this.nameField.method_1860(-1);
        this.nameField.method_1863(this::updateVariants);
        this.nameField.method_1880(4096);
        this.nameField.method_1852(this.filter.getValue(this.stack));
        this.nameField.method_1876(true);
        this.method_37063((class_364)this.nameField);
    }

    public void method_25419() {
        super.method_25419();
        this.field_22787.field_1774.method_1462(true);
    }

    private void updateVariants(String txt) {
        if (!this.variants.isEmpty()) {
            this.visibleVariants.clear();
            txt = this.nameField.method_1882().toLowerCase();
            if (txt.isEmpty()) {
                this.visibleVariants.addAll(this.variants.values());
            } else {
                for (StringValueFilterVariant variant : this.variants.values()) {
                    if (!variant.id.toLowerCase().contains(txt) && !variant.title.getString().toLowerCase().contains(txt)) continue;
                    this.visibleVariants.add(variant);
                }
            }
            this.visibleVariants.sort(null);
            this.selectedVariant = 0;
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            String text = !this.variants.isEmpty() && !this.visibleVariants.isEmpty() && this.selectedVariant >= 0 && this.selectedVariant < this.visibleVariants.size() ? this.visibleVariants.get((int)this.selectedVariant).id : this.nameField.method_1882();
            if (this.variants.isEmpty() || text.isEmpty() || this.variants.containsKey(text)) {
                class_1799 newStack = this.stack.method_7972();
                this.filter.setValue(newStack, text);
                if (newStack.method_7985() || text.isEmpty()) {
                    this.field_22787.method_1507(null);
                    StringValueFilterVariant variant = this.variants.get(text);
                    this.field_22787.method_1566().method_1999((class_368)new class_370(class_370.class_371.field_2218, (class_2561)new class_2585("Value changed!"), text.isEmpty() ? null : (variant == null ? new class_2585(text) : variant.title.method_27661())));
                    this.field_22787.field_1724.method_6122(this.hand, newStack);
                    new MessageUpdateFilterItem(this.hand, newStack).send();
                } else {
                    this.field_22787.method_1566().method_1999((class_368)new class_370(class_370.class_371.field_2218, (class_2561)new class_2585("Invalid string!"), null));
                }
            } else {
                this.field_22787.method_1566().method_1999((class_368)new class_370(class_370.class_371.field_2218, (class_2561)new class_2585("Invalid string!"), null));
            }
            return true;
        }
        if (keyCode == 258) {
            this.adjustSelected(!class_437.method_25442());
            return true;
        }
        if (keyCode == 264) {
            this.adjustSelected(true);
            return true;
        }
        if (keyCode == 265) {
            this.adjustSelected(false);
            return true;
        }
        if (this.nameField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void adjustSelected(boolean forward) {
        this.selectedVariant += forward ? 1 : -1;
        if (this.selectedVariant < 0) {
            this.selectedVariant = this.visibleVariants.size() - 1;
        } else if (this.selectedVariant >= this.visibleVariants.size()) {
            this.selectedVariant = 0;
        }
    }

    public boolean method_25400(char typedChar, int keyCode) {
        if (this.nameField.method_25400(typedChar, keyCode)) {
            return true;
        }
        return super.method_25400(typedChar, keyCode);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (super.method_25402(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 1) {
            this.nameField.method_1852("");
        } else {
            this.nameField.method_25402(mouseX, mouseY, mouseButton);
            this.nameField.method_1876(true);
        }
        return true;
    }

    public boolean method_25401(double d, double e, double delta) {
        this.adjustSelected(delta < 0.0);
        return true;
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(matrixStack);
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.disableBlend();
        if (!this.variants.isEmpty()) {
            int first;
            Objects.requireNonNull(this.field_22793);
            int drawY = 4 + 9;
            Objects.requireNonNull(this.field_22793);
            int nLines = (this.field_22790 - drawY) / 9;
            StringValueFilterScreen.method_27535((class_4587)matrixStack, (class_327)this.field_22793, (class_2561)new class_2588("itemfilters.variants", new Object[]{this.visibleVariants.size()}).method_27692(class_124.field_1075), (int)4, (int)4, (int)-1);
            List lines = class_341.method_1850((class_5348)new class_2588("itemfilters.help_text.variants").method_27692(class_124.field_1062), (int)(this.field_22789 / 2), (class_327)this.field_22793);
            for (int i = 0; i < lines.size(); ++i) {
                class_5481 line = (class_5481)lines.get(i);
                int n = this.field_22789 - this.field_22793.method_30880(line) - 4;
                Objects.requireNonNull(this.field_22793);
                StringValueFilterScreen.method_35720((class_4587)matrixStack, (class_327)this.field_22793, (class_5481)line, (int)n, (int)(4 + i * 9), (int)-1);
            }
            for (int i = first = this.visibleVariants.size() < nLines ? 0 : Math.max(0, this.selectedVariant - nLines / 2); i < this.visibleVariants.size(); ++i) {
                Objects.requireNonNull(this.field_22793);
                if (drawY >= this.field_22790 - 9) break;
                StringValueFilterVariant variant = this.visibleVariants.get(i);
                StringValueFilterScreen.method_25303((class_4587)matrixStack, (class_327)this.field_22793, (String)variant.title.getString(), (int)(variant.icon.method_7960() ? 4 : 14), (int)drawY, (int)(i == this.selectedVariant ? -256 : -1));
                if (!variant.icon.method_7960()) {
                    class_4587 modelViewStack = RenderSystem.getModelViewStack();
                    modelViewStack.method_22903();
                    modelViewStack.method_22904(4.0, (double)drawY, 0.0);
                    modelViewStack.method_22905(0.5f, 0.5f, 1.0f);
                    RenderSystem.applyModelViewMatrix();
                    this.field_22788.field_4730 = 100.0f;
                    RenderSystem.enableDepthTest();
                    class_308.method_24211();
                    this.field_22788.method_4023(variant.icon, 0, 0);
                    this.field_22788.method_4022(this.field_22793, variant.icon, 0, 0, "");
                    this.field_22788.field_4730 = 0.0f;
                    modelViewStack.method_22909();
                    RenderSystem.applyModelViewMatrix();
                }
                Objects.requireNonNull(this.field_22793);
                drawY += 9;
            }
            this.nameField.field_22760 = this.field_22789 / 2;
            this.nameField.method_25358(this.field_22789 / 3);
            class_2588 class_25882 = new class_2588("itemfilters.help_text.filter");
            int n = this.nameField.field_22760;
            int n2 = this.nameField.field_22761;
            Objects.requireNonNull(this.field_22793);
            StringValueFilterScreen.method_27535((class_4587)matrixStack, (class_327)this.field_22793, (class_2561)class_25882, (int)n, (int)(n2 - 9 - 2), (int)-1);
        } else {
            int w = this.field_22789 * 3 / 4;
            this.nameField.field_22760 = (this.field_22789 - w) / 2;
            this.nameField.method_25358(w);
            Object lines = this.stack.method_7909();
            if (lines instanceof StringValueFilterItem) {
                StringValueFilterItem filterItem = (StringValueFilterItem)lines;
                lines = class_341.method_1850((class_5348)new class_2588(filterItem.getHelpKey()), (int)this.nameField.method_25368(), (class_327)this.field_22793);
                int n = this.nameField.field_22761 - 3;
                Objects.requireNonNull(this.field_22793);
                int textY = n - 9 * lines.size();
                int color = -1;
                Iterator iterator = lines.iterator();
                while (iterator.hasNext()) {
                    class_5481 line = (class_5481)iterator.next();
                    StringValueFilterScreen.method_35720((class_4587)matrixStack, (class_327)this.field_22793, (class_5481)line, (int)this.nameField.field_22760, (int)textY, (int)color);
                    color = -6710887;
                    Objects.requireNonNull(this.field_22793);
                    textY += 9;
                }
            }
        }
    }
}

