/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams;

import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.data.TeamRank;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class FTBTeamsAPI {
    public static Consumer<MouseButton> partyCreationOverride = null;

    public static boolean isManagerLoaded() {
        return TeamManager.INSTANCE != null;
    }

    public static TeamManager getManager() {
        return Objects.requireNonNull(TeamManager.INSTANCE);
    }

    public static boolean isClientManagerLoaded() {
        return ClientTeamManager.INSTANCE != null;
    }

    public static ClientTeamManager getClientManager() {
        return Objects.requireNonNull(ClientTeamManager.INSTANCE);
    }

    @Nullable
    public static Team getPlayerTeam(UUID profile) {
        return FTBTeamsAPI.isManagerLoaded() ? FTBTeamsAPI.getManager().getPlayerTeam(profile) : null;
    }

    public static Team getPlayerTeam(class_3222 player) {
        return FTBTeamsAPI.getManager().getPlayerTeam(player);
    }

    public static UUID getPlayerTeamID(UUID profile) {
        return FTBTeamsAPI.isManagerLoaded() ? FTBTeamsAPI.getManager().getPlayerTeamID(profile) : profile;
    }

    public static boolean arePlayersInSameTeam(class_3222 player1, class_3222 player2) {
        return player1 == player2 || FTBTeamsAPI.arePlayersInSameTeam(player1.method_5667(), player2.method_5667());
    }

    public static boolean arePlayersInSameTeam(UUID player1, UUID player2) {
        return FTBTeamsAPI.getPlayerTeamID(player1).equals(FTBTeamsAPI.getPlayerTeamID(player2));
    }

    public static TeamRank getHighestRank(UUID teamId, UUID player) {
        Team team;
        if (FTBTeamsAPI.isManagerLoaded() && (team = FTBTeamsAPI.getManager().getTeamByID(teamId)) != null) {
            return team.getHighestRank(player);
        }
        return TeamRank.NONE;
    }
}

