/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import dev.ftb.mods.ftbteams.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.property.TeamPropertyValue;
import java.util.Optional;
import net.minecraft.class_2489;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class DoubleProperty
extends TeamProperty<Double> {
    public final double minValue;
    public final double maxValue;

    public DoubleProperty(class_2960 id, double def, double min, double max) {
        super(id, def);
        this.minValue = min;
        this.maxValue = max;
    }

    public DoubleProperty(class_2960 id, double def) {
        this(id, def, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DoubleProperty(class_2960 id, class_2540 buf) {
        super(id, buf.readDouble());
        this.minValue = buf.readDouble();
        this.maxValue = buf.readDouble();
    }

    @Override
    public TeamPropertyType<Double> getType() {
        return TeamPropertyType.DOUBLE;
    }

    @Override
    public Optional<Double> fromString(String string) {
        try {
            double num = Double.parseDouble(string);
            return Optional.of(class_3532.method_15350((double)num, (double)this.minValue, (double)this.maxValue));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    @Override
    public void write(class_2540 buf) {
        buf.writeDouble(((Double)this.defaultValue).doubleValue());
        buf.writeDouble(this.minValue);
        buf.writeDouble(this.maxValue);
    }

    @Override
    public void config(ConfigGroup config, TeamPropertyValue<Double> value) {
        config.addDouble(this.id.method_12836() + "." + this.id.method_12832(), ((Double)value.value).doubleValue(), value.consumer, ((Double)this.defaultValue).doubleValue(), this.minValue, this.maxValue);
    }

    @Override
    public class_2520 toNBT(Double value) {
        return class_2489.method_23241((double)value);
    }

    @Override
    public Optional<Double> fromNBT(class_2520 tag) {
        if (tag instanceof class_2514) {
            return Optional.of(class_3532.method_15350((double)((class_2514)tag).method_10697(), (double)this.minValue, (double)this.maxValue));
        }
        return Optional.empty();
    }
}

