/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.block.FTBQuestsBlocks;
import dev.ftb.mods.ftbquests.block.entity.ITaskScreen;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenAuxBlockEntity;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.block.fabric.TaskScreenBlockImpl;
import dev.ftb.mods.ftbquests.item.ScreenBlockItem;
import dev.ftb.mods.ftbquests.net.TaskScreenConfigRequest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3614;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class TaskScreenBlock
extends class_2237 {
    public static final class_2753 FACING = class_2383.field_11177;
    private final int size;

    protected TaskScreenBlock(int size) {
        super(class_4970.class_2251.method_9617((class_3614)class_3614.field_15953, (class_1767)class_1767.field_7963).method_9632(0.3f));
        this.size = size;
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    public int getSize() {
        return this.size;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING});
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return TaskScreenBlock.blockEntityProvider().create(blockPos, blockState);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_2591.class_5559<TaskScreenBlockEntity> blockEntityProvider() {
        return TaskScreenBlockImpl.blockEntityProvider();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_2591.class_5559<TaskScreenAuxBlockEntity> blockEntityAuxProvider() {
        return TaskScreenBlockImpl.blockEntityAuxProvider();
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2680 method_9605(class_1750 blockPlaceContext) {
        if (!this.validatePlaceable(blockPlaceContext)) {
            return null;
        }
        return (class_2680)super.method_9605(blockPlaceContext).method_11657((class_2769)FACING, (Comparable)blockPlaceContext.method_8042().method_10153());
    }

    private boolean validatePlaceable(class_1750 ctx) {
        int screenSize = ScreenBlockItem.getSize(ctx.method_8041());
        if (screenSize == 1) {
            return true;
        }
        class_2350 facing = ctx.method_8042();
        return class_2338.method_29715((class_238)TaskScreenBlock.getMultiblockBounds(ctx.method_8037(), this.getSize(), facing)).allMatch(pos -> ctx.method_8045().method_8320(pos).method_26166(ctx));
    }

    public void method_9567(class_1937 level, class_2338 blockPos, class_2680 blockState, @Nullable class_1309 livingEntity, class_1799 itemStack) {
        super.method_9567(level, blockPos, blockState, livingEntity, itemStack);
        class_2586 class_25862 = level.method_8321(blockPos);
        if (class_25862 instanceof TaskScreenBlockEntity) {
            TaskScreenBlockEntity coreScreen = (TaskScreenBlockEntity)class_25862;
            if (livingEntity instanceof class_3222) {
                class_3222 sp = (class_3222)livingEntity;
                coreScreen.setTeamId(ServerQuestFile.INSTANCE.getData((class_1297)sp).uuid);
            }
            class_2350 facing = (class_2350)blockState.method_11654((class_2769)FACING);
            class_2680 auxState = (class_2680)((class_2248)FTBQuestsBlocks.AUX_SCREEN.get()).method_9564().method_11657((class_2769)FACING, (Comparable)facing);
            class_2338.method_29715((class_238)TaskScreenBlock.getMultiblockBounds(blockPos, this.getSize(), facing)).filter(pos -> !pos.equals((Object)blockPos)).forEach(auxPos -> {
                level.method_8501(auxPos, auxState);
                class_2586 patt5218$temp = level.method_8321(auxPos);
                if (patt5218$temp instanceof TaskScreenAuxBlockEntity) {
                    TaskScreenAuxBlockEntity auxScreen = (TaskScreenAuxBlockEntity)patt5218$temp;
                    auxScreen.setCoreScreen(coreScreen);
                }
            });
        }
    }

    public void method_9536(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 newState, boolean isMoving) {
        class_2586 class_25862;
        if (blockState.method_26204() != newState.method_26204() && (class_25862 = level.method_8321(blockPos)) instanceof ITaskScreen) {
            ITaskScreen taskScreen = (ITaskScreen)class_25862;
            taskScreen.getCoreScreen().ifPresent(coreScreen -> {
                coreScreen.removeAllAuxScreens();
                if (coreScreen != taskScreen) {
                    level.method_8651(coreScreen.method_11016(), true, null);
                }
            });
            super.method_9536(blockState, level, blockPos, newState, isMoving);
        }
    }

    public float method_9594(class_2680 blockState, class_1657 player, class_1922 blockGetter, class_2338 blockPos) {
        ITaskScreen taskScreen;
        class_2586 class_25862 = player.field_6002.method_8321(blockPos);
        if (class_25862 instanceof ITaskScreen && (taskScreen = (ITaskScreen)class_25862).isIndestructible()) {
            return 0.0f;
        }
        return super.method_9594(blockState, player, blockGetter, blockPos);
    }

    public class_1269 method_9534(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            class_2586 class_25862 = level.method_8321(blockPos);
            if (class_25862 instanceof ITaskScreen) {
                ITaskScreen taskScreen = (ITaskScreen)class_25862;
                if (TaskScreenBlock.hasPermissionToEdit(sp, taskScreen)) {
                    taskScreen.getCoreScreen().ifPresent(coreScreen -> new TaskScreenConfigRequest(coreScreen.method_11016()).sendTo(sp));
                } else {
                    sp.method_7353((class_2561)class_2561.method_43471((String)"block.ftbquests.screen.no_permission").method_27692(class_124.field_1061), true);
                    return class_1269.field_5814;
                }
            }
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    public void method_9568(class_1799 itemStack, @Nullable class_1922 blockGetter, List<class_2561> list, class_1836 tooltipFlag) {
        super.method_9568(itemStack, blockGetter, list, tooltipFlag);
        if (itemStack.method_7969() != null && itemStack.method_7969().method_10573("BlockEntityTag", 10)) {
            Task task;
            class_2487 subTag = itemStack.method_7941("BlockEntityTag");
            QuestFile questFile = FTBQuests.PROXY.getQuestFile(true);
            if (questFile != null && (task = questFile.getTask(subTag.method_10537("TaskID"))) != null) {
                list.add((class_2561)class_2561.method_43471((String)"ftbquests.chapter").method_27693(": ").method_10852((class_2561)task.quest.chapter.getTitle().method_27661().method_27692(class_124.field_1054)));
                list.add((class_2561)class_2561.method_43471((String)"ftbquests.quest").method_27693(": ").method_10852((class_2561)task.quest.getTitle().method_27661().method_27692(class_124.field_1054)));
                list.add((class_2561)class_2561.method_43471((String)"ftbquests.task").method_27693(": ").method_10852((class_2561)task.getTitle().method_27661().method_27692(class_124.field_1054)));
            }
        }
    }

    public static boolean hasPermissionToEdit(class_3222 player, ITaskScreen screen) {
        if (player.method_5667().equals(screen.getTeamId())) {
            return true;
        }
        Team team = FTBTeamsAPI.getManager().getTeamByID(screen.getTeamId());
        return team != null && team.isMember(player.method_5667());
    }

    public static class_238 getMultiblockBounds(class_2338 corePos, int size, class_2350 facing) {
        if (size == 1) {
            return new class_238(corePos, corePos);
        }
        int size2 = size / 2;
        facing = facing.method_10160();
        return new class_238((double)(corePos.method_10263() - size2 * facing.method_10148()), (double)corePos.method_10264(), (double)(corePos.method_10260() - size2 * facing.method_10165()), (double)(corePos.method_10263() + size2 * facing.method_10148()), (double)(corePos.method_10264() + size - 1), (double)(corePos.method_10260() + size2 * facing.method_10165()));
    }

    public static class Aux
    extends TaskScreenBlock {
        protected Aux() {
            super(0);
        }

        @Override
        @Nullable
        public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
            return Aux.blockEntityAuxProvider().create(blockPos, blockState);
        }
    }
}

