/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.ISingleLongValueTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class XPTask
extends Task
implements ISingleLongValueTask {
    public long value = 1L;
    public boolean points = false;

    public XPTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.XP;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public String formatMaxProgress() {
        return Long.toUnsignedString(this.points && this.value <= Integer.MAX_VALUE ? (long)XPTask.getLevelForExperience((int)this.value) : this.value);
    }

    @Override
    public String formatProgress(TeamData teamData, long progress) {
        return Long.toUnsignedString(this.points && this.value <= Integer.MAX_VALUE ? (long)XPTask.getLevelForExperience((int)progress) : progress);
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10544("value", this.value);
        nbt.method_10556("points", this.points);
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.value = nbt.method_10537("value");
        this.points = nbt.method_10577("points");
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10791(this.value);
        buffer.writeBoolean(this.points);
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.value = buffer.method_10792();
        this.points = buffer.readBoolean();
    }

    @Override
    public void setValue(long v) {
        this.value = v;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 1L, 1L, Long.MAX_VALUE);
        config.addBool("points", this.points, v -> {
            this.points = v;
        }, false);
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return class_2561.method_43471((String)"ftbquests.reward.ftbquests.xp_levels").method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)this.formatMaxProgress()).method_27692(class_124.field_1061));
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    public static int getPlayerXP(class_1657 player) {
        return (int)((float)XPTask.getExperienceForLevel(player.field_7520) + player.field_7510 * (float)player.method_7349());
    }

    public static void addPlayerXP(class_1657 player, int amount) {
        int experience;
        player.field_7495 = experience = XPTask.getPlayerXP(player) + amount;
        player.field_7520 = XPTask.getLevelForExperience(experience);
        int expForLevel = XPTask.getExperienceForLevel(player.field_7520);
        player.field_7510 = (float)(experience - expForLevel) / (float)player.method_7349();
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return XPTask.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + XPTask.sum(level - 15, 37, 5);
        }
        return 1395 + XPTask.sum(level - 30, 112, 9);
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = XPTask.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    @Override
    public void submitTask(TeamData teamData, class_3222 player, class_1799 craftedItem) {
        int add = (int)Math.min(this.points ? (long)XPTask.getPlayerXP((class_1657)player) : (long)player.field_7520, Math.min(this.value - teamData.getProgress(this), Integer.MAX_VALUE));
        if (add <= 0) {
            return;
        }
        if (this.points) {
            XPTask.addPlayerXP((class_1657)player, -add);
            player.method_7316(0);
        } else {
            player.method_7316(-add);
        }
        teamData.addProgress(this, add);
    }
}

