/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.client;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftbteams.FTBTeams;
import dev.ftb.mods.ftbteams.FTBTeamsCommon;
import dev.ftb.mods.ftbteams.client.MyTeamScreen;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.TeamMessage;
import dev.ftb.mods.ftbteams.event.ClientTeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.net.OpenGUIMessage;
import dev.ftb.mods.ftbteams.net.OpenMyTeamGUIMessage;
import dev.ftb.mods.ftbteams.property.TeamProperties;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;

public class FTBTeamsClient
extends FTBTeamsCommon {
    public static final class_2960 OPEN_GUI_ID = new class_2960("ftbteams", "open_gui");
    public static class_304 openTeamsKey;

    public FTBTeamsClient() {
        this.registerKeys();
        CustomClickEvent.EVENT.register(event -> {
            if (event.id().equals((Object)OPEN_GUI_ID)) {
                new OpenGUIMessage().sendToServer();
                return EventResult.interruptTrue();
            }
            return EventResult.pass();
        });
        ClientRawInputEvent.KEY_PRESSED.register(this::keyPressed);
    }

    private void registerKeys() {
        openTeamsKey = new class_304("key.ftbteams.open_gui", class_3675.class_307.field_1668, -1, "key.categories.ftbteams");
        KeyMappingRegistry.register((class_304)openTeamsKey);
    }

    private EventResult keyPressed(class_310 client, int keyCode, int scanCode, int action, int modifiers) {
        if (openTeamsKey.method_1434()) {
            new OpenGUIMessage().sendToServer();
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    @Override
    public void openMyTeamGui(OpenMyTeamGUIMessage res) {
        new MyTeamScreen(res.properties, res.permissions).openGui();
    }

    @Override
    public void updateSettings(UUID id, TeamProperties properties) {
        if (ClientTeamManager.INSTANCE == null) {
            return;
        }
        ClientTeam team = ClientTeamManager.INSTANCE.getTeam(id);
        if (team != null) {
            TeamProperties old = team.properties.copy();
            team.properties.updateFrom(properties);
            ((Consumer)TeamEvent.CLIENT_PROPERTIES_CHANGED.invoker()).accept(new ClientTeamPropertiesChangedEvent(team, old));
        }
    }

    @Override
    public void sendMessage(UUID from, class_2561 text) {
        if (ClientTeamManager.INSTANCE == null) {
            return;
        }
        ClientTeamManager.INSTANCE.selfTeam.addMessage(new TeamMessage(from, System.currentTimeMillis(), text));
        MyTeamScreen screen = (MyTeamScreen)((Object)ClientUtils.getCurrentGuiAs(MyTeamScreen.class));
        if (screen != null) {
            screen.chatPanel.refreshWidgets();
        }
    }

    @Override
    public void updatePresence(KnownClientPlayer update) {
        if (ClientTeamManager.INSTANCE == null) {
            return;
        }
        KnownClientPlayer p = ClientTeamManager.INSTANCE.knownPlayers.get(update.uuid);
        if (p == null) {
            ClientTeamManager.INSTANCE.knownPlayers.put(update.uuid, update);
        } else {
            p.update(update);
        }
        if (Platform.isDevelopmentEnvironment()) {
            FTBTeams.LOGGER.info("Updated presence of " + update.name);
        }
    }
}

