/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.property;

import dev.ftb.mods.ftbteams.event.TeamCollectPropertiesEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import dev.ftb.mods.ftbteams.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.property.TeamPropertyValue;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class TeamProperties {
    public final Map<TeamProperty, TeamPropertyValue> map = new LinkedHashMap<TeamProperty, TeamPropertyValue>();

    public TeamProperties collect() {
        this.map.clear();
        ((Consumer)TeamEvent.COLLECT_PROPERTIES.invoker()).accept(new TeamCollectPropertiesEvent(prop -> this.map.put((TeamProperty)prop, new TeamPropertyValue(prop, prop.defaultValue))));
        return this;
    }

    public TeamProperties copy() {
        TeamProperties p = new TeamProperties();
        this.map.forEach((key, value) -> p.map.put((TeamProperty)key, value.copy()));
        return p;
    }

    public TeamProperties updateFrom(TeamProperties properties) {
        properties.map.forEach((key, value) -> this.set((TeamProperty)key, value.value));
        return this;
    }

    public <T> T get(TeamProperty<T> key) {
        TeamPropertyValue v = this.map.get(key);
        return v == null ? key.defaultValue : v.value;
    }

    public <T> void set(TeamProperty<T> key, T value) {
        this.map.computeIfAbsent(key, (Function<TeamProperty, TeamPropertyValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(dev.ftb.mods.ftbteams.property.TeamProperty<T> ), (Ldev/ftb/mods/ftbteams/property/TeamProperty;)Ldev/ftb/mods/ftbteams/property/TeamPropertyValue;)()).value = value;
    }

    public void read(class_2540 buffer) {
        int p = buffer.method_10816();
        this.map.clear();
        for (int i = 0; i < p; ++i) {
            TeamProperty tp = TeamPropertyType.MAP.get((Object)buffer.method_10800((int)Short.MAX_VALUE)).deserializer.apply(buffer.method_10810(), buffer);
            this.map.put(tp, new TeamPropertyValue(tp, tp.readValue(buffer)));
        }
    }

    public void write(class_2540 buffer) {
        buffer.method_10804(this.map.size());
        this.map.forEach((key, value) -> {
            TeamPropertyType.write(buffer, key);
            key.writeValue(buffer, value.value);
        });
    }

    public void writeSyncableOnly(class_2540 buffer, List<TeamProperty> syncableProps) {
        HashMap<TeamProperty, TeamPropertyValue> subMap = new HashMap<TeamProperty, TeamPropertyValue>();
        syncableProps.forEach(prop -> {
            if (this.map.containsKey(prop)) {
                subMap.put((TeamProperty)prop, this.map.get(prop));
            }
        });
        buffer.method_10804(subMap.size());
        subMap.forEach((key, value) -> {
            TeamPropertyType.write(buffer, key);
            key.writeValue(buffer, value.value);
        });
    }

    public void read(class_2487 tag) {
        tag.method_10541().forEach(key -> {
            TeamPropertyValue<?> property = this.findValue((String)key);
            if (property != null) {
                Optional optional = property.key.fromNBT(tag.method_10580(key));
                property.value = optional.isPresent() ? optional.get() : property.key.defaultValue;
            }
        });
    }

    @Nullable
    private TeamPropertyValue<?> findValue(String key) {
        class_2960 id = new class_2960(key);
        return this.map.entrySet().stream().filter(entry -> ((TeamProperty)entry.getKey()).id.equals((Object)id)).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public class_2487 write(class_2487 tag) {
        this.map.forEach((key, value) -> tag.method_10566(key.id.toString(), key.toNBT(value.value)));
        return tag;
    }
}

