/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.MutableColor4I;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.VerticalSpaceWidget;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;

public class EditConfigScreen
extends BaseScreen {
    public static final Color4I COLOR_BACKGROUND = Color4I.rgba(-1724697805);
    public static Theme THEME = new Theme(){

        @Override
        public void drawScrollBarBackground(class_4587 matrixStack, int x, int y, int w, int h, WidgetType type) {
            Color4I.BLACK.withAlpha(70).draw(matrixStack, x, y, w, h);
        }

        @Override
        public void drawScrollBar(class_4587 matrixStack, int x, int y, int w, int h, WidgetType type, boolean vertical) {
            this.getContentColor(WidgetType.NORMAL).withAlpha(100).withBorder(Color4I.GRAY.withAlpha(100), false).draw(matrixStack, x, y, w, h);
        }
    };
    private final ConfigGroup group;
    private final class_2561 title;
    private final List<Widget> configEntryButtons;
    private final Panel configPanel;
    private final Button buttonAccept;
    private final Button buttonCancel;
    private final Button buttonCollapseAll;
    private final Button buttonExpandAll;
    private final PanelScrollBar scroll;
    private int groupSize = 0;
    private boolean autoclose = false;
    private int dividerX;

    public EditConfigScreen(ConfigGroup g) {
        this.group = g;
        this.title = g.getName().method_27661().method_27692(class_124.field_1067);
        this.configEntryButtons = new ArrayList<Widget>();
        this.configPanel = new Panel(this){

            @Override
            public void addWidgets() {
                for (Widget w : EditConfigScreen.this.configEntryButtons) {
                    if (w instanceof ConfigEntryButton && ((ConfigEntryButton)w).group.collapsed) continue;
                    this.add(w);
                }
            }

            @Override
            public void alignWidgets() {
                for (Widget w : this.widgets) {
                    w.setWidth(this.width - 16);
                }
                EditConfigScreen.this.scroll.setMaxValue(this.align(WidgetLayout.VERTICAL));
            }
        };
        ArrayList<ConfigValue> list = new ArrayList<ConfigValue>();
        this.collectAllConfigValues(this.group, list);
        if (!list.isEmpty()) {
            list.sort(null);
            ConfigGroupButton group = null;
            for (ConfigValue value : list) {
                if (group == null || group.group != value.group) {
                    this.configEntryButtons.add(new VerticalSpaceWidget(this.configPanel, 4));
                    group = new ConfigGroupButton(this.configPanel, value.group);
                    this.configEntryButtons.add(group);
                    ++this.groupSize;
                }
                ConfigEntryButton btn = new ConfigEntryButton(this.configPanel, group, value);
                this.configEntryButtons.add(btn);
                this.dividerX = Math.max(this.dividerX, this.getTheme().getStringWidth((class_5348)btn.keyText));
            }
            if (this.groupSize == 1) {
                this.configEntryButtons.remove(group);
            }
        }
        this.dividerX += 10;
        this.scroll = new PanelScrollBar(this, this.configPanel);
        this.buttonAccept = new SimpleButton(this, (class_2561)class_2561.method_43471((String)"gui.accept"), Icons.ACCEPT, (widget, button) -> this.doAccept());
        this.buttonCancel = new SimpleButton(this, (class_2561)class_2561.method_43471((String)"gui.cancel"), Icons.CANCEL, (widget, button) -> this.doCancel());
        this.buttonExpandAll = new SimpleButton(this, (class_2561)class_2561.method_43471((String)"gui.expand_all"), Icons.ADD, (widget, button) -> {
            for (Widget w : this.configEntryButtons) {
                if (!(w instanceof ConfigGroupButton)) continue;
                ((ConfigGroupButton)w).setCollapsed(false);
            }
            this.scroll.setValue(0.0);
            widget.getGui().refreshWidgets();
        });
        this.buttonCollapseAll = new SimpleButton(this, (class_2561)class_2561.method_43471((String)"gui.collapse_all"), Icons.REMOVE, (widget, button) -> {
            for (Widget w : this.configEntryButtons) {
                if (!(w instanceof ConfigGroupButton)) continue;
                ((ConfigGroupButton)w).setCollapsed(true);
            }
            this.scroll.setValue(0.0);
            widget.getGui().refreshWidgets();
        });
    }

    private void collectAllConfigValues(ConfigGroup group, List<ConfigValue> list) {
        list.addAll(group.getValues());
        for (ConfigGroup group1 : group.getGroups()) {
            this.collectAllConfigValues(group1, list);
        }
    }

    @Override
    public boolean onInit() {
        return this.setFullscreen();
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        if (this.groupSize > 1) {
            this.add(this.buttonExpandAll);
            this.add(this.buttonCollapseAll);
        }
        this.add(this.configPanel);
        this.add(this.scroll);
    }

    @Override
    public void alignWidgets() {
        this.configPanel.setPosAndSize(0, 20, this.width, this.height - 20);
        this.configPanel.alignWidgets();
        this.scroll.setPosAndSize(this.width - 16, 20, 16, this.height - 20);
        this.buttonAccept.setPos(this.width - 18, 2);
        this.buttonCancel.setPos(this.width - 38, 2);
        if (this.groupSize > 1) {
            this.buttonExpandAll.setPos(this.width - 58, 2);
            this.buttonCollapseAll.setPos(this.width - 78, 2);
        }
    }

    public EditConfigScreen setAutoclose(boolean autoclose) {
        this.autoclose = autoclose;
        return this;
    }

    private void doAccept() {
        this.group.save(true);
        if (this.autoclose) {
            this.closeGui();
        }
    }

    private void doCancel() {
        this.group.save(false);
        if (this.autoclose) {
            this.closeGui();
        }
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.group.save(true);
            return true;
        }
        return false;
    }

    @Override
    public void drawBackground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        COLOR_BACKGROUND.draw(matrixStack, 0, 0, w, 20);
        theme.drawString(matrixStack, this.getTitle(), 6, 6, 2);
    }

    @Override
    public class_2561 getTitle() {
        return this.title;
    }

    @Override
    public Theme getTheme() {
        return THEME;
    }

    public static class ConfigGroupButton
    extends Button {
        public final ConfigGroup group;
        public class_5250 title;
        public class_5250 info;
        public boolean collapsed = false;

        public ConfigGroupButton(Panel panel, ConfigGroup g) {
            super(panel);
            this.setHeight(12);
            this.group = g;
            if (this.group.parent != null) {
                ArrayList<ConfigGroup> groups = new ArrayList<ConfigGroup>();
                do {
                    groups.add(g);
                } while ((g = g.parent) != null);
                groups.remove(groups.size() - 1);
                this.title = class_2561.method_43470((String)"");
                for (int i = groups.size() - 1; i >= 0; --i) {
                    this.title.method_10852(((ConfigGroup)groups.get(i)).getName());
                    if (i == 0) continue;
                    this.title.method_27693(" > ");
                }
            } else {
                this.title = class_2561.method_43471((String)"stat.generalButton");
            }
            this.title.method_27692(class_124.field_1054);
            String infoKey = this.group.getPath() + ".info";
            this.info = class_1074.method_4663((String)infoKey) ? class_2561.method_43471((String)infoKey) : null;
            this.setCollapsed(this.collapsed);
        }

        public void setCollapsed(boolean v) {
            this.collapsed = v;
            this.setTitle((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(this.collapsed ? "[-] " : "[v] ")).method_27692(this.collapsed ? class_124.field_1061 : class_124.field_1060)).method_10852((class_2561)this.title));
        }

        @Override
        public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
            COLOR_BACKGROUND.draw(matrixStack, x, y, w, h);
            theme.drawString(matrixStack, this.getTitle(), x + 3, y + 2);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Color4I.GRAY.withAlpha(80).draw(matrixStack, 0, y, this.width, 1);
            Color4I.GRAY.withAlpha(80).draw(matrixStack, 0, y, 1, this.height);
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(33).draw(matrixStack, x, y, w, h);
            }
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            if (this.info != null) {
                list.add((class_2561)this.info);
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            this.setCollapsed(!this.collapsed);
            this.getGui().refreshWidgets();
        }
    }

    private class ConfigEntryButton
    extends Button {
        public final ConfigGroupButton group;
        public final ConfigValue inst;
        public class_2561 keyText;

        public ConfigEntryButton(Panel panel, ConfigGroupButton g, ConfigValue i) {
            super(panel);
            this.setHeight(12);
            this.group = g;
            this.inst = i;
            this.keyText = !this.inst.getCanEdit() ? class_2561.method_43470((String)this.inst.getName()).method_27692(class_124.field_1080) : class_2561.method_43470((String)this.inst.getName());
        }

        @Override
        public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
            boolean mouseOver;
            boolean bl = mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            if (mouseOver) {
                Color4I.WHITE.withAlpha(33).draw(matrixStack, x, y, w, h);
            }
            theme.drawString(matrixStack, this.keyText, 5, y + 2, Bits.setFlag(0, 2, mouseOver));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_2561 s = this.inst.getStringForGUI(this.inst.value);
            int slen = theme.getStringWidth((class_5348)s);
            int maxLen = this.width - EditConfigScreen.this.dividerX - 10;
            if (slen > maxLen) {
                s = class_2561.method_43470((String)(theme.trimStringToWidth((class_5348)s, maxLen).getString().trim() + "..."));
                slen = maxLen + 2;
            }
            MutableColor4I textCol = this.inst.getColor(this.inst.value).mutable();
            textCol.setAlpha(255);
            if (mouseOver) {
                textCol.addBrightness(60);
                if (this.getMouseX() > x + w - slen - 9) {
                    Color4I.WHITE.withAlpha(33).draw(matrixStack, x + w - slen - 8, y, slen + 8, h);
                }
            }
            theme.drawString(matrixStack, s, EditConfigScreen.this.dividerX + 5, y + 2, textCol, 0);
            Color4I.GRAY.withAlpha(33).draw(matrixStack, EditConfigScreen.this.dividerX, y, 1, this.height);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onClicked(MouseButton button) {
            if (this.getMouseY() >= 20) {
                this.playClickSound();
                this.inst.onClicked(button, accepted -> this.run());
            }
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            if (this.getMouseY() > 18) {
                list.add((class_2561)this.keyText.method_27661().method_27692(class_124.field_1073));
                String tooltip = this.inst.getTooltip();
                if (!tooltip.isEmpty()) {
                    for (String s : tooltip.split("\n")) {
                        list.styledString(s, class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_27703(class_5251.method_27718((class_124)class_124.field_1080)));
                    }
                }
                list.blankLine();
                this.inst.addInfo(list);
            }
        }
    }
}

