/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.CursorType;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_7417;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class Widget
implements IScreenWrapper {
    public Panel parent;
    public int posX;
    public int posY;
    public int width;
    public int height;
    protected boolean isMouseOver;

    public Widget(Panel p) {
        this.parent = p;
    }

    @Override
    public BaseScreen getGui() {
        return this.parent.getGui();
    }

    public void setX(int v) {
        this.posX = v;
    }

    public void setY(int v) {
        this.posY = v;
    }

    public void setWidth(int v) {
        this.width = Math.max(v, 0);
    }

    public void setHeight(int v) {
        this.height = Math.max(v, 0);
    }

    public final void setPos(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public final void setSize(int w, int h) {
        this.setWidth(w);
        this.setHeight(h);
    }

    public final Widget setPosAndSize(int x, int y, int w, int h) {
        this.setX(x);
        this.setY(y);
        this.setWidth(w);
        this.setHeight(h);
        return this;
    }

    public int getX() {
        return this.parent.getX() + this.posX;
    }

    public int getY() {
        return this.parent.getY() + this.posY;
    }

    public boolean collidesWith(int x, int y, int w, int h) {
        int ay = this.getY();
        if (ay >= y + h || ay + this.height <= y) {
            return false;
        }
        int ax = this.getX();
        return ax < x + w && ax + this.width > x;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean shouldDraw() {
        return true;
    }

    public class_2561 getTitle() {
        return class_2561.method_43473();
    }

    public WidgetType getWidgetType() {
        return WidgetType.mouseOver(this.isMouseOver());
    }

    public void addMouseOverText(TooltipList list) {
        class_2561 title = this.getTitle();
        if (title.method_10851() != class_7417.field_39004) {
            list.add(title);
        }
    }

    public final boolean isMouseOver() {
        return this.isMouseOver;
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.parent == null) {
            return true;
        }
        if (!this.parent.isMouseOver()) {
            return false;
        }
        int ax = this.getX();
        int ay = this.getY();
        return mouseX >= ax && mouseY >= ay && mouseX < ax + this.width && mouseY < ay + this.height;
    }

    public void updateMouseOver(int mouseX, int mouseY) {
        this.isMouseOver = this.checkMouseOver(mouseX, mouseY);
    }

    public boolean shouldAddMouseOverText() {
        return this.isEnabled() && this.isMouseOver();
    }

    public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
    }

    public boolean mousePressed(MouseButton button) {
        return false;
    }

    public boolean mouseDoubleClicked(MouseButton button) {
        return false;
    }

    public void mouseReleased(MouseButton button) {
    }

    public boolean mouseScrolled(double scroll) {
        return false;
    }

    public boolean mouseDragged(int button, double dragX, double dragY) {
        return false;
    }

    public boolean keyPressed(Key key) {
        return false;
    }

    public void keyReleased(Key key) {
    }

    public boolean charTyped(char c, KeyModifiers modifiers) {
        return false;
    }

    public class_1041 getScreen() {
        return this.parent.getScreen();
    }

    public int getMouseX() {
        return this.parent.getMouseX();
    }

    public int getMouseY() {
        return this.parent.getMouseY();
    }

    public float getPartialTicks() {
        return this.parent.getPartialTicks();
    }

    public boolean handleClick(String scheme, String path) {
        return this.parent.handleClick(scheme, path);
    }

    public final boolean handleClick(String click) {
        int index = click.indexOf(58);
        if (index == -1) {
            return this.handleClick("", click);
        }
        return this.handleClick(click.substring(0, index), click.substring(index + 1));
    }

    public void onClosed() {
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return null;
    }

    public boolean isGhostIngredientTarget(Object ingredient) {
        return false;
    }

    public void acceptGhostIngredient(Object ingredient) {
    }

    public static boolean isMouseButtonDown(MouseButton button) {
        return GLFW.glfwGetMouseButton((long)class_310.method_1551().method_22683().method_4490(), (int)button.id) == 1;
    }

    public static boolean isKeyDown(int key) {
        return GLFW.glfwGetKey((long)class_310.method_1551().method_22683().method_4490(), (int)key) == 1;
    }

    public static String getClipboardString() {
        return class_310.method_1551().field_1774.method_1460();
    }

    public static void setClipboardString(String string) {
        class_310.method_1551().field_1774.method_1455(string);
    }

    public static boolean isShiftKeyDown() {
        return class_437.method_25442();
    }

    public static boolean isCtrlKeyDown() {
        return class_437.method_25441();
    }

    public void tick() {
    }

    public String toString() {
        String s = this.getClass().getSimpleName();
        if (s.isEmpty()) {
            s = this.getClass().getSuperclass().getSimpleName();
        }
        return s;
    }

    public void playClickSound() {
        GuiHelper.playSound(class_3417.field_15015, 1.0f);
    }

    @Nullable
    public CursorType getCursor() {
        return null;
    }
}

