/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import dev.architectury.fluid.FluidStack;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.FluidConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import java.util.Optional;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;

public class SelectFluidScreen
extends ButtonListBaseScreen {
    private final FluidConfig config;
    private final ConfigCallback callback;

    public SelectFluidScreen(FluidConfig c, ConfigCallback cb) {
        this.setTitle((class_2561)class_2561.method_43471((String)"ftblibrary.select_fluid.gui"));
        this.setHasSearchBox(true);
        this.config = c;
        this.callback = cb;
    }

    @Override
    public void addButtons(Panel panel) {
        if (this.config.allowEmptyFluid()) {
            FluidStack fluidStack = FluidStack.create((class_3611)class_3612.field_15906, (long)FluidStack.bucketAmount());
            this.addFluidButton(panel, ItemIcon.getItemIcon(class_1802.field_8550), fluidStack);
        }
        for (class_3611 fluid : class_7923.field_41173) {
            if (fluid == class_3612.field_15906 || !fluid.method_15785().method_15771()) continue;
            FluidStack fluidStack = FluidStack.create((class_3611)fluid, (long)FluidStack.bucketAmount());
            Icon icon = Icon.getIcon(ClientUtils.getStillTexture(fluidStack)).withTint(Color4I.rgb(ClientUtils.getFluidColor(fluidStack)));
            this.addFluidButton(panel, icon, fluidStack);
        }
    }

    private void addFluidButton(Panel panel, Icon icon, final FluidStack fluidStack) {
        panel.add(new SimpleTextButton(panel, fluidStack.getName(), icon){

            @Override
            public void onClicked(MouseButton button) {
                this.playClickSound();
                SelectFluidScreen.this.config.setCurrentValue(fluidStack.copy());
                SelectFluidScreen.this.callback.save(true);
            }

            @Override
            public Optional<PositionedIngredient> getIngredientUnderMouse() {
                return PositionedIngredient.of(fluidStack, this);
            }
        });
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return true;
        }
        return false;
    }
}

