/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface WidgetLayout {
    public static final Padding NO_PADDING = new Padding(0, 0);
    public static final WidgetLayout NONE = panel -> 0;
    public static final WidgetLayout VERTICAL = new Vertical(0, 0, 0);
    public static final WidgetLayout HORIZONTAL = new Horizontal(0, 0, 0);

    public int align(Panel var1);

    @NotNull
    default public Padding getLayoutPadding() {
        return NO_PADDING;
    }

    public record Padding(int vertical, int horizontal) {
    }

    public static class Vertical
    extends _Simple {
        public Vertical(int _pre, int _spacing, int _post) {
            super(_pre, _spacing, _post, Widget::getHeight, Widget::setY);
        }

        @Override
        @NotNull
        public Padding getLayoutPadding() {
            return new Padding(this.padding, 0);
        }
    }

    public static class Horizontal
    extends _Simple {
        public Horizontal(int _pre, int _spacing, int _post) {
            super(_pre, _spacing, _post, Widget::getWidth, Widget::setX);
        }

        @Override
        @NotNull
        public Padding getLayoutPadding() {
            return new Padding(0, this.padding);
        }
    }

    public static abstract class _Simple
    implements WidgetLayout {
        protected final int pre;
        protected final int spacing;
        protected final int post;
        private final Function<Widget, Integer> sizeGetter;
        private final BiConsumer<Widget, Integer> positionSetter;
        protected int padding;

        public _Simple(int _pre, int _spacing, int _post, Function<Widget, Integer> sizeGetter, BiConsumer<Widget, Integer> positionSetter) {
            this.pre = _pre;
            this.spacing = _spacing;
            this.post = _post;
            this.sizeGetter = sizeGetter;
            this.positionSetter = positionSetter;
        }

        @Override
        public int align(Panel panel) {
            int i = this.pre;
            if (!panel.widgets.isEmpty()) {
                for (Widget widget : panel.widgets) {
                    this.positionSetter.accept(widget, i);
                    i += this.sizeGetter.apply(widget).intValue();
                }
                i -= this.spacing;
            }
            this.padding = this.pre + this.post;
            return i + this.post;
        }
    }
}

