/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import dev.ftb.mods.ftbteams.api.TeamMessage;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.event.ClientTeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyCollection;
import dev.ftb.mods.ftbteams.data.AbstractTeam;
import dev.ftb.mods.ftbteams.data.AbstractTeamBase;
import dev.ftb.mods.ftbteams.data.TeamPropertyCollectionImpl;
import dev.ftb.mods.ftbteams.data.TeamType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class ClientTeam
extends AbstractTeamBase {
    private static final List<TeamProperty<?>> SYNCABLE_PROPS = List.of(TeamProperties.DISPLAY_NAME, TeamProperties.COLOR);
    private final TeamType type;
    private final UUID ownerID;
    private final boolean toBeRemoved;

    private ClientTeam(UUID id, UUID ownerId, TeamType type, boolean toBeRemoved) {
        super(id);
        this.ownerID = ownerId;
        this.type = type;
        this.toBeRemoved = toBeRemoved;
    }

    public static ClientTeam invalidTeam(AbstractTeam team) {
        return new ClientTeam(team.getId(), class_156.field_25140, team.getType(), true);
    }

    public static ClientTeam fromNetwork(class_2540 buffer) {
        UUID id = buffer.method_10790();
        UUID ownerID = buffer.readBoolean() ? buffer.method_10790() : class_156.field_25140;
        TeamType type = (TeamType)buffer.method_10818(TeamType.class);
        boolean mustRemove = buffer.readBoolean();
        ClientTeam clientTeam = new ClientTeam(id, ownerID, type, mustRemove);
        clientTeam.properties.read(buffer);
        int nMembers = buffer.method_10816();
        for (int i = 0; i < nMembers; ++i) {
            clientTeam.addMember(buffer.method_10790(), (TeamRank)buffer.method_10818(TeamRank.class));
        }
        clientTeam.extraData = buffer.method_10798();
        return clientTeam;
    }

    public static ClientTeam copyOf(AbstractTeam team) {
        ClientTeam clientTeam = new ClientTeam(team.id, team.getOwner(), team.getType(), false);
        clientTeam.properties.updateFrom(team.properties);
        clientTeam.ranks.putAll(team.ranks);
        clientTeam.extraData = team.extraData == null ? null : team.extraData.method_10553();
        return clientTeam;
    }

    @Override
    public TeamType getType() {
        return this.type;
    }

    @Override
    public UUID getOwner() {
        return this.ownerID;
    }

    @Override
    public void sendMessage(UUID senderId, String message) {
    }

    @Override
    public List<class_2561> getTeamInfo() {
        return List.of();
    }

    @Override
    public boolean isClientTeam() {
        return true;
    }

    @Override
    public Collection<class_3222> getOnlineMembers() {
        return List.of();
    }

    @Override
    public boolean isValid() {
        return !this.toBeRemoved();
    }

    @Override
    public boolean isPlayerTeam() {
        return this.type == TeamType.PLAYER;
    }

    @Override
    public boolean isPartyTeam() {
        return this.type == TeamType.PARTY;
    }

    @Override
    public boolean isServerTeam() {
        return this.type == TeamType.SERVER;
    }

    public void write(class_2540 buffer, boolean writeAllProperties) {
        buffer.method_10797(this.id);
        boolean hasOwner = !this.ownerID.equals(class_156.field_25140);
        buffer.writeBoolean(hasOwner);
        if (hasOwner) {
            buffer.method_10797(this.ownerID);
        }
        buffer.method_10817((Enum)this.type);
        buffer.writeBoolean(this.toBeRemoved);
        if (writeAllProperties) {
            this.properties.write(buffer);
        } else {
            this.properties.writeSyncableOnly(buffer, SYNCABLE_PROPS);
        }
        buffer.method_10804(this.ranks.size());
        for (Map.Entry entry : this.ranks.entrySet()) {
            buffer.method_10797((UUID)entry.getKey());
            buffer.method_10817((Enum)entry.getValue());
        }
        buffer.method_10794(this.extraData);
    }

    public void setMessageHistory(List<TeamMessage> messages) {
        this.messageHistory.clear();
        this.messageHistory.addAll(messages);
    }

    public boolean toBeRemoved() {
        return this.toBeRemoved;
    }

    public void updateProperties(TeamPropertyCollection newProps) {
        TeamPropertyCollectionImpl old = this.properties.copy();
        this.properties.updateFrom(newProps);
        ((Consumer)TeamEvent.CLIENT_PROPERTIES_CHANGED.invoker()).accept(new ClientTeamPropertiesChangedEvent(this, old));
    }
}

