/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.architectury.utils.Env;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.gui.CustomToast;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.DeleteObjectMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.StructureTask;
import dev.ftb.mods.ftbquests.quest.theme.QuestTheme;
import dev.ftb.mods.ftbquests.util.TextUtils;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_746;

public class ClientQuestFile
extends BaseQuestFile {
    private static final List<String> MISSING_DATA_ERR = List.of("Unable to open Quest GUI: no quest book data received from server!", "- Check that FTB Quests and FTB Teams are installed on the server", "  and that no server-side errors were logged when you connected.");
    public static ClientQuestFile INSTANCE;
    public TeamData selfTeamData;
    private QuestScreen questScreen;
    private QuestScreen.PersistedData persistedData;
    private boolean editorPermission;

    public static boolean exists() {
        return INSTANCE != null && !ClientQuestFile.INSTANCE.invalid;
    }

    public static void syncFromServer(BaseQuestFile newInstance) {
        if (!(newInstance instanceof ClientQuestFile)) {
            throw new IllegalArgumentException("need a client quest file instance!");
        }
        ClientQuestFile clientInstance = (ClientQuestFile)newInstance;
        if (INSTANCE != null) {
            INSTANCE.deleteChildren();
            INSTANCE.deleteSelf();
        }
        INSTANCE = clientInstance;
        INSTANCE.onReplaced();
    }

    private void onReplaced() {
        this.selfTeamData = new TeamData(class_156.field_25140, INSTANCE, "Loading...");
        this.selfTeamData.setLocked(true);
        this.refreshGui();
        FTBQuests.getRecipeModHelper().refreshRecipes(INSTANCE);
    }

    @Override
    public boolean canEdit() {
        return class_310.method_1551().field_1724 != null && this.hasEditorPermission() && this.selfTeamData.getCanEdit((class_1657)class_310.method_1551().field_1724);
    }

    @Override
    public void refreshGui() {
        this.clearCachedData();
        if (this.questScreen != null) {
            this.persistedData = this.questScreen.getPersistedScreenData();
            if (ClientUtils.getCurrentGuiAs(QuestScreen.class) != null) {
                double mx = class_310.method_1551().field_1729.method_1603();
                double my = class_310.method_1551().field_1729.method_1604();
                class_310.method_1551().method_1507(null);
                this.questScreen = new QuestScreen(this, this.persistedData);
                this.questScreen.openGui();
                class_3675.method_15984((long)class_310.method_1551().method_22683().method_4490(), (int)212993, (double)mx, (double)my);
            }
        }
    }

    public Optional<QuestScreen> getQuestScreen() {
        return Optional.ofNullable(this.questScreen);
    }

    public static QuestScreen openGui() {
        if (INSTANCE != null) {
            return INSTANCE.openQuestGui();
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            MISSING_DATA_ERR.forEach(arg_0 -> ClientQuestFile.lambda$openGui$0((class_1657)player, arg_0));
        }
        return null;
    }

    public static QuestScreen openGui(Quest quest, boolean focused) {
        QuestScreen screen = ClientQuestFile.openGui();
        if (screen != null) {
            screen.open(quest, focused);
        }
        return screen;
    }

    private QuestScreen openQuestGui() {
        if (ClientQuestFile.exists()) {
            if (this.isDisableGui() && !this.canEdit()) {
                class_310.method_1551().method_1566().method_1999((class_368)new CustomToast((class_2561)class_2561.method_43471((String)"item.ftbquests.book.disabled"), Icons.BARRIER, (class_2561)class_2561.method_43473()));
            } else if (this.selfTeamData.isLocked()) {
                class_310.method_1551().method_1566().method_1999((class_368)new CustomToast((class_2561)(this.lockMessage.isEmpty() ? class_2561.method_43470((String)"Quests locked!") : TextUtils.parseRawText(this.lockMessage)), Icons.BARRIER, (class_2561)class_2561.method_43473()));
            } else {
                if (this.canEdit()) {
                    StructureTask.maybeRequestStructureSync();
                }
                this.questScreen = new QuestScreen(this, this.persistedData);
                this.questScreen.openGui();
                this.questScreen.refreshWidgets();
                return this.questScreen;
            }
        }
        return null;
    }

    @Override
    public Env getSide() {
        return Env.CLIENT;
    }

    @Override
    public void deleteObject(long id) {
        new DeleteObjectMessage(id).sendToServer();
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        QuestTheme.instance.clearCache();
    }

    @Override
    public TeamData getOrCreateTeamData(class_1297 player) {
        KnownClientPlayer kcp = (KnownClientPlayer)FTBTeamsAPI.api().getClientManager().getKnownPlayer(player.method_5667()).orElseThrow(() -> new RuntimeException("Unknown client player " + player.method_5667()));
        return kcp.id().equals(class_310.method_1551().field_1724.method_5667()) ? this.selfTeamData : this.getOrCreateTeamData(kcp.teamId());
    }

    public void setPersistedScreenInfo(QuestScreen.PersistedData persistedData) {
        this.persistedData = persistedData;
    }

    public static boolean canClientPlayerEdit() {
        return ClientQuestFile.exists() && ClientQuestFile.INSTANCE.selfTeamData.getCanEdit(FTBQuestsClient.getClientPlayer());
    }

    public static boolean isQuestPinned(long id) {
        return ClientQuestFile.exists() && ClientQuestFile.INSTANCE.selfTeamData.isQuestPinned(FTBQuestsClient.getClientPlayer(), id);
    }

    @Override
    public boolean isPlayerOnTeam(class_1657 player, TeamData teamData) {
        return FTBTeamsAPI.api().getClientManager().getKnownPlayer(player.method_5667()).map(kcp -> kcp.teamId().equals(teamData.getTeamId())).orElse(false);
    }

    @Override
    public boolean moveChapterGroup(long id, boolean movingUp) {
        if (super.moveChapterGroup(id, movingUp)) {
            this.clearCachedData();
            QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
            if (gui != null) {
                gui.refreshChapterPanel();
            }
            return true;
        }
        return false;
    }

    public void setEditorPermission(boolean hasPermission) {
        this.editorPermission = hasPermission;
    }

    public boolean hasEditorPermission() {
        return this.editorPermission;
    }

    public static void openBookToQuestObject(long id) {
        if (ClientQuestFile.exists()) {
            ClientQuestFile file = INSTANCE;
            if (file.questScreen == null) {
                INSTANCE.openQuestGui();
            }
            if (file.questScreen != null) {
                if (id != 0L) {
                    QuestObject qo = file.get(id);
                    if (qo != null) {
                        file.questScreen.open(qo, true);
                    }
                } else {
                    file.questScreen.openGui();
                }
            }
        }
    }

    private static /* synthetic */ void lambda$openGui$0(class_1657 player, String s) {
        player.method_7353((class_2561)class_2561.method_43470((String)s).method_27692(class_124.field_1061), false);
    }
}

