/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.fluid.FluidStack;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.FluidConfig;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.config.IntConfig;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.config.ui.SelectFluidScreen;
import dev.ftb.mods.ftblibrary.config.ui.SelectItemStackScreen;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.block.FTBQuestsBlocks;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientEventHandler;
import dev.ftb.mods.ftbquests.client.QuestFileCacheReloader;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.net.SetCustomImageMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.reward.XPLevelsReward;
import dev.ftb.mods.ftbquests.quest.reward.XPReward;
import dev.ftb.mods.ftbquests.quest.task.CheckmarkTask;
import dev.ftb.mods.ftbquests.quest.task.DimensionTask;
import dev.ftb.mods.ftbquests.quest.task.FluidTask;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.LocationTask;
import dev.ftb.mods.ftbquests.quest.task.ObservationTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.quest.theme.ThemeLoader;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2633;
import net.minecraft.class_2680;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7706;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsClient {
    public static class_304 KEY_QUESTS;

    public static void init() {
        ClientLifecycleEvent.CLIENT_SETUP.register(FTBQuestsClient::onClientSetup);
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)new QuestFileCacheReloader());
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)new ThemeLoader());
        KEY_QUESTS = new class_304("key.ftbquests.quests", class_3675.class_307.field_1668, -1, "key.categories.ftbquests");
        KeyMappingRegistry.register((class_304)KEY_QUESTS);
        new FTBQuestsClientEventHandler().init();
    }

    private static void onClientSetup(class_310 minecraft) {
        RenderTypeRegistry.register((class_1921)class_1921.method_23583(), (class_2248[])new class_2248[]{(class_2248)FTBQuestsBlocks.BARRIER.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23583(), (class_2248[])new class_2248[]{(class_2248)FTBQuestsBlocks.STAGE_BARRIER.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23577(), (class_2248[])new class_2248[]{(class_2248)FTBQuestsBlocks.TASK_SCREEN_1.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23577(), (class_2248[])new class_2248[]{(class_2248)FTBQuestsBlocks.TASK_SCREEN_3.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23577(), (class_2248[])new class_2248[]{(class_2248)FTBQuestsBlocks.TASK_SCREEN_5.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23577(), (class_2248[])new class_2248[]{(class_2248)FTBQuestsBlocks.TASK_SCREEN_7.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23577(), (class_2248[])new class_2248[]{(class_2248)FTBQuestsBlocks.AUX_SCREEN.get()});
        FTBQuestsClient.setTaskGuiProviders();
        FTBQuestsClient.setRewardGuiProviders();
    }

    @Nullable
    public static BaseQuestFile getClientQuestFile() {
        return ClientQuestFile.INSTANCE;
    }

    public static void setTaskGuiProviders() {
        TaskTypes.ITEM.setGuiProvider((gui, quest, callback) -> {
            ItemStackConfig c = new ItemStackConfig(false, false);
            new SelectItemStackScreen(c, accepted -> {
                gui.run();
                if (accepted) {
                    ItemTask itemTask = new ItemTask(0L, quest).setStackAndCount((class_1799)c.getValue(), ((class_1799)c.getValue()).method_7947());
                    callback.accept(itemTask);
                }
            }).openGui();
        });
        TaskTypes.CHECKMARK.setGuiProvider((gui, quest, callback) -> {
            StringConfig c = new StringConfig(null);
            EditConfigFromStringScreen.open((ConfigFromString)c, (Object)"", (Object)"", accepted -> {
                if (accepted) {
                    CheckmarkTask checkmarkTask = new CheckmarkTask(0L, quest);
                    checkmarkTask.setRawTitle((String)c.getValue());
                    callback.accept(checkmarkTask);
                }
                gui.run();
            });
        });
        TaskTypes.FLUID.setGuiProvider((gui, quest, callback) -> {
            FluidConfig c = new FluidConfig(false);
            new SelectFluidScreen(c, accepted -> {
                gui.run();
                if (accepted) {
                    FluidTask fluidTask = new FluidTask(0L, quest).setFluid(((FluidStack)c.getValue()).getFluid());
                    callback.accept(fluidTask);
                }
            }).openGui();
        });
        TaskTypes.DIMENSION.setGuiProvider((gui, quest, callback) -> {
            DimensionTask task = new DimensionTask(0L, quest).withDimension((class_5321<class_1937>)class_310.method_1551().field_1687.method_27983());
            FTBQuestsClient.openSetupGui(gui, callback, task);
        });
        TaskTypes.OBSERVATION.setGuiProvider((gui, quest, callback) -> {
            ObservationTask task = new ObservationTask(0L, quest);
            class_239 patt5742$temp = class_310.method_1551().field_1765;
            if (patt5742$temp instanceof class_3965) {
                class_3965 bhr = (class_3965)patt5742$temp;
                class_2248 block = class_310.method_1551().field_1687.method_8320(bhr.method_17777()).method_26204();
                task.setToObserve(class_7923.field_41175.method_10221((Object)block).toString());
            }
            FTBQuestsClient.openSetupGui(gui, callback, task);
        });
        TaskTypes.LOCATION.setGuiProvider((gui, quest, callback) -> {
            class_3965 bhr;
            class_2586 blockEntity;
            LocationTask task = new LocationTask(0L, quest);
            class_310 mc = class_310.method_1551();
            class_239 patt6171$temp = mc.field_1765;
            if (patt6171$temp instanceof class_3965 && (blockEntity = mc.field_1687.method_8321((bhr = (class_3965)patt6171$temp).method_17777())) instanceof class_2633) {
                class_2633 structure = (class_2633)blockEntity;
                task.initFromStructure(structure);
                callback.accept(task);
                return;
            }
            FTBQuestsClient.openSetupGui(gui, callback, task);
        });
    }

    private static void openSetupGui(Runnable gui, Consumer<Task> callback, Task task) {
        ConfigGroup group = new ConfigGroup("ftbquests", accepted -> {
            gui.run();
            if (accepted) {
                callback.accept(task);
            }
        });
        task.fillConfigGroup(task.createSubGroup(group));
        new EditConfigScreen(group).openGui();
    }

    public static void setRewardGuiProviders() {
        RewardTypes.ITEM.setGuiProvider((gui, quest, callback) -> {
            ItemStackConfig c = new ItemStackConfig(false, false);
            new SelectItemStackScreen(c, accepted -> {
                if (accepted) {
                    class_1799 copy = ((class_1799)c.getValue()).method_7972();
                    copy.method_7939(1);
                    ItemReward reward = new ItemReward(0L, quest, copy, ((class_1799)c.getValue()).method_7947());
                    callback.accept(reward);
                }
                gui.run();
            }).openGui();
        });
        RewardTypes.XP.setGuiProvider((gui, quest, callback) -> {
            IntConfig c = new IntConfig(1, Integer.MAX_VALUE);
            EditConfigFromStringScreen.open((ConfigFromString)c, (Object)100, (Object)100, accepted -> {
                if (accepted) {
                    callback.accept(new XPReward(0L, quest, (Integer)c.getValue()));
                }
                gui.run();
            });
        });
        RewardTypes.XP_LEVELS.setGuiProvider((gui, quest, callback) -> {
            IntConfig c = new IntConfig(1, Integer.MAX_VALUE);
            EditConfigFromStringScreen.open((ConfigFromString)c, (Object)5, (Object)5, accepted -> {
                if (accepted) {
                    callback.accept(new XPLevelsReward(0L, quest, (Integer)c.getValue()));
                }
                gui.run();
            });
        });
    }

    public static class_1657 getClientPlayer() {
        return class_310.method_1551().field_1724;
    }

    public static class_1937 getClientLevel() {
        return class_310.method_1551().field_1687;
    }

    public static boolean isClientDataLoaded() {
        return ClientQuestFile.exists();
    }

    public static TeamData getClientPlayerData() {
        return ClientQuestFile.INSTANCE.selfTeamData;
    }

    public static BaseQuestFile createClientQuestFile() {
        return new ClientQuestFile();
    }

    public static void openGui() {
        ClientQuestFile.openGui();
    }

    public static void openCustomIconGui(class_1657 player, class_1268 hand) {
        ImageConfig config = new ImageConfig();
        config.onClicked(MouseButton.LEFT, b -> {
            if (b) {
                if (((String)config.getValue()).isEmpty()) {
                    player.method_5998(hand).method_7983("Icon");
                } else {
                    player.method_5998(hand).method_7959("Icon", (class_2520)class_2519.method_23256((String)((String)config.getValue())));
                }
                new SetCustomImageMessage(hand, (String)config.getValue()).sendToServer();
            }
            class_310.method_1551().method_1507(null);
        });
    }

    public static void openScreenConfigGui(class_2338 pos) {
        class_2586 class_25862 = class_310.method_1551().field_1687.method_8321(pos);
        if (class_25862 instanceof TaskScreenBlockEntity) {
            TaskScreenBlockEntity coreScreen = (TaskScreenBlockEntity)class_25862;
            new EditConfigScreen(coreScreen.fillConfigGroup(ClientQuestFile.INSTANCE.getOrCreateTeamData(coreScreen.getTeamId()))).setAutoclose(true).openGui();
        }
    }

    public static float[] getTextureUV(class_2680 state, class_2350 face) {
        if (state == null) {
            return null;
        }
        class_1087 model = class_310.method_1551().method_1541().method_3349(state);
        List quads = model.method_4707(state, face, class_5819.method_43047());
        if (!quads.isEmpty()) {
            class_1058 sprite = ((class_777)quads.get(0)).method_35788();
            return new float[]{sprite.method_4594(), sprite.method_4593(), sprite.method_4577(), sprite.method_4575()};
        }
        return new float[0];
    }

    public static void rebuildCreativeTabs() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            FTBQuests.LOGGER.debug("deferring creative tab rebuild, client player still null");
            FTBQuestsClientEventHandler.creativeTabRebuildPending = true;
        } else {
            FTBQuests.LOGGER.debug("rebuilding creative tabs now");
            class_1761.class_8128 params = new class_1761.class_8128(player.field_3944.method_45735(), player.method_7338(), (class_7225.class_7874)player.method_37908().method_30349());
            ((class_1761)FTBQuestsItems.CREATIVE_TAB.get()).method_47306(params);
            class_7706.method_47344().method_47306(params);
        }
    }

    public static Optional<class_5455> registryAccess() {
        return class_310.method_1551().field_1687 == null ? Optional.empty() : Optional.of(class_310.method_1551().field_1687.method_30349());
    }

    public static void copyToClipboard(QuestObjectBase qo) {
        Widget.setClipboardString((String)qo.getCodeString());
    }
}

