/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.architectury.hooks.item.ItemStackHooks;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.gui.IRewardListenerScreen;
import dev.ftb.mods.ftbquests.client.gui.QuestObjectUpdateListener;
import dev.ftb.mods.ftbquests.client.gui.RewardKey;
import dev.ftb.mods.ftbquests.client.gui.RewardToast;
import dev.ftb.mods.ftbquests.client.gui.ToastQuestObject;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.TeamDataUpdate;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.util.Date;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsNetClient {
    public static void syncTeamData(boolean self, TeamData data) {
        ClientQuestFile.INSTANCE.addData(data, true);
        if (self) {
            ClientQuestFile.INSTANCE.selfTeamData = data;
        }
    }

    public static void claimReward(UUID teamId, UUID player, long rewardId) {
        QuestScreen treeGui;
        Reward reward = ClientQuestFile.INSTANCE.getReward(rewardId);
        if (reward == null) {
            return;
        }
        TeamData data = ClientQuestFile.INSTANCE.getOrCreateTeamData(teamId);
        data.claimReward(player, reward, System.currentTimeMillis());
        if (data == ClientQuestFile.INSTANCE.selfTeamData && (treeGui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class))) != null) {
            treeGui.refreshViewQuestPanel();
            treeGui.otherButtonsTopPanel.refreshWidgets();
        }
    }

    public static void createObject(long id, long parent, QuestObjectType type, class_2487 nbt, @Nullable class_2487 extra, UUID creator) {
        QuestObjectUpdateListener listener;
        QuestObjectBase object = ClientQuestFile.INSTANCE.create(id, type, parent, extra == null ? new class_2487() : extra);
        object.readData(nbt);
        object.onCreated();
        ClientQuestFile.INSTANCE.refreshIDMap();
        object.editedFromGUI();
        FTBQuests.getRecipeModHelper().refreshRecipes(object);
        class_746 player = class_310.method_1551().field_1724;
        if (object instanceof QuestObject) {
            QuestObject qo = (QuestObject)object;
            if (player != null && creator.equals(player.method_5667())) {
                ClientQuestFile.INSTANCE.getQuestScreen().ifPresent(questScreen -> questScreen.open(qo, true));
            }
        }
        if ((listener = (QuestObjectUpdateListener)ClientUtils.getCurrentGuiAs(QuestObjectUpdateListener.class)) != null) {
            listener.onQuestObjectUpdate(object);
        }
    }

    public static void createOtherTeamData(TeamDataUpdate dataUpdate) {
        if (ClientQuestFile.INSTANCE != null) {
            TeamData data = new TeamData(dataUpdate.uuid, ClientQuestFile.INSTANCE, dataUpdate.name);
            ClientQuestFile.INSTANCE.addData(data, true);
        }
    }

    public static void teamDataChanged(TeamDataUpdate oldDataUpdate, TeamDataUpdate newDataUpdate) {
        if (ClientQuestFile.INSTANCE != null) {
            TeamData data = new TeamData(newDataUpdate.uuid, ClientQuestFile.INSTANCE, newDataUpdate.name);
            ClientQuestFile.INSTANCE.addData(data, false);
        }
    }

    public static void deleteObject(long id) {
        QuestObjectBase object = ClientQuestFile.INSTANCE.getBase(id);
        if (object != null) {
            object.deleteChildren();
            object.deleteSelf();
            ClientQuestFile.INSTANCE.refreshIDMap();
            object.editedFromGUI();
            FTBQuests.getRecipeModHelper().refreshRecipes(object);
        }
    }

    public static void displayCompletionToast(long id) {
        QuestScreen questScreen;
        QuestObject object = ClientQuestFile.INSTANCE.get(id);
        if (object != null) {
            class_310.method_1551().method_1566().method_1999((class_368)new ToastQuestObject(object));
        }
        if ((questScreen = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class))) != null) {
            questScreen.refreshQuestPanel();
            questScreen.refreshChapterPanel();
            questScreen.refreshViewQuestPanel();
        }
    }

    public static void displayItemRewardToast(class_1799 stack, int count) {
        class_1799 stack1 = ItemStackHooks.copyWithCount((class_1799)stack, (int)1);
        Icon icon = ItemIcon.getItemIcon((class_1799)stack1);
        if (!IRewardListenerScreen.add(new RewardKey(stack.method_7964().getString(), icon, stack1), count)) {
            class_5250 comp = count > 1 ? class_2561.method_43470((String)(count + "x ")).method_10852(stack.method_7964()) : stack.method_7964().method_27661();
            class_310.method_1551().method_1566().method_1999((class_368)new RewardToast((class_2561)comp.method_27692(stack.method_7932().field_8908), icon));
        }
    }

    public static void displayRewardToast(long id, class_2561 text, Icon icon) {
        Icon i;
        Icon icon2 = i = icon.isEmpty() ? ClientQuestFile.INSTANCE.getBase(id).getIcon() : icon;
        if (!IRewardListenerScreen.add(new RewardKey(text.getString(), i), 1)) {
            class_310.method_1551().method_1566().method_1999((class_368)new RewardToast(text, i));
        }
    }

    public static void editObject(long id, class_2487 nbt) {
        ClientQuestFile.INSTANCE.clearCachedData();
        QuestObjectBase object = ClientQuestFile.INSTANCE.getBase(id);
        if (object != null) {
            object.readData(nbt);
            object.editedFromGUI();
            FTBQuests.getRecipeModHelper().refreshRecipes(object);
        }
    }

    public static void moveChapter(long id, boolean movingUp) {
        Chapter chapter = ClientQuestFile.INSTANCE.getChapter(id);
        if (chapter != null && chapter.getGroup().moveChapterWithinGroup(chapter, movingUp)) {
            ClientQuestFile.INSTANCE.clearCachedData();
            QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
            if (gui != null) {
                gui.refreshChapterPanel();
            }
        }
    }

    public static void moveQuest(long id, long chapter, double x, double y) {
        QuestObject questObject = ClientQuestFile.INSTANCE.get(id);
        if (questObject instanceof Movable) {
            Movable movable = (Movable)((Object)questObject);
            movable.onMoved(x, y, chapter);
            QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
            if (gui != null) {
                gui.questPanel.withPreservedPos(Panel::refreshWidgets);
            }
        }
    }

    public static void syncEditingMode(UUID teamId, boolean editingMode) {
        if (ClientQuestFile.INSTANCE.getOrCreateTeamData(teamId).setCanEdit((class_1657)class_310.method_1551().field_1724, editingMode)) {
            FTBQuestsNetClient.setEditorPermission(editingMode);
            ClientQuestFile.INSTANCE.refreshGui();
        }
    }

    public static void togglePinned(long id, boolean pinned) {
        TeamData data = FTBQuestsClient.getClientPlayerData();
        data.setQuestPinned((class_1657)class_310.method_1551().field_1724, id, pinned);
        ClientQuestFile.INSTANCE.getQuestScreen().ifPresent(questScreen -> {
            questScreen.otherButtonsTopPanel.refreshWidgets();
            questScreen.refreshViewQuestPanel();
        });
    }

    public static void updateTeamData(UUID teamId, String name) {
        TeamData data = ClientQuestFile.INSTANCE.getOrCreateTeamData(teamId);
        data.setName(name);
    }

    public static void updateTaskProgress(UUID teamId, long task, long progress) {
        Task t = ClientQuestFile.INSTANCE.getTask(task);
        if (t != null) {
            TeamData data = ClientQuestFile.INSTANCE.getOrCreateTeamData(teamId);
            ClientQuestFile.INSTANCE.clearCachedProgress();
            data.setProgress(t, progress);
        }
    }

    public static void changeChapterGroup(long id, long newGroupId) {
        Chapter chapter = ClientQuestFile.INSTANCE.getChapter(id);
        if (chapter != null) {
            ChapterGroup newGroup = ClientQuestFile.INSTANCE.getChapterGroup(newGroupId);
            if (chapter.getGroup() != newGroup) {
                chapter.getGroup().removeChapter(chapter);
                newGroup.addChapter(chapter);
                chapter.file.clearCachedData();
                chapter.editedFromGUI();
            }
        }
    }

    public static void moveChapterGroup(long id, boolean movingUp) {
        ClientQuestFile.INSTANCE.moveChapterGroup(id, movingUp);
    }

    public static void objectStarted(UUID teamId, long id, @Nullable Date time) {
        TeamData teamData = ClientQuestFile.INSTANCE.getOrCreateTeamData(teamId);
        teamData.setStarted(id, time);
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null) {
            gui.refreshChapterPanel();
            if (gui.viewQuestPanel != null) {
                gui.viewQuestPanel.refreshWidgets();
            }
        }
    }

    public static void objectCompleted(UUID teamId, long id, @Nullable Date time) {
        TeamData teamData = ClientQuestFile.INSTANCE.getOrCreateTeamData(teamId);
        teamData.setCompleted(id, time);
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null) {
            gui.refreshChapterPanel();
            if (gui.viewQuestPanel != null) {
                gui.viewQuestPanel.refreshWidgets();
            }
        }
        FTBQuests.getRecipeModHelper().refreshRecipes(ClientQuestFile.INSTANCE.get(id));
    }

    public static void syncLock(UUID id, boolean lock) {
        if (ClientQuestFile.INSTANCE.getOrCreateTeamData(id).setLocked(lock)) {
            ClientQuestFile.INSTANCE.refreshGui();
        }
    }

    public static void resetReward(UUID teamId, UUID player, long rewardId) {
        QuestScreen gui;
        Reward reward = ClientQuestFile.INSTANCE.getReward(rewardId);
        if (reward == null) {
            return;
        }
        TeamData teamData = ClientQuestFile.INSTANCE.getOrCreateTeamData(teamId);
        if (teamData.resetReward(player, reward) && (gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class))) != null) {
            gui.refreshChapterPanel();
            if (gui.viewQuestPanel != null) {
                gui.viewQuestPanel.refreshWidgets();
            }
        }
    }

    public static void toggleChapterPinned(boolean pinned) {
        ClientQuestFile.INSTANCE.selfTeamData.setChapterPinned(FTBQuestsClient.getClientPlayer(), pinned);
        ClientQuestFile.INSTANCE.getQuestScreen().ifPresent(QuestScreen::refreshChapterPanel);
    }

    public static void syncRewardBlocking(UUID teamId, boolean rewardsBlocked) {
        if (ClientQuestFile.INSTANCE.getOrCreateTeamData(teamId).setRewardsBlocked(rewardsBlocked)) {
            ClientQuestFile.INSTANCE.refreshGui();
        }
    }

    public static void setEditorPermission(boolean hasPermission) {
        if (ClientQuestFile.exists()) {
            ClientQuestFile.INSTANCE.setEditorPermission(hasPermission);
        }
    }
}

