/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui;

import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.DoubleConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.VerticalSpaceWidget;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.client.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class EditRewardTableScreen
extends ButtonListBaseScreen {
    private final RewardTable originalTable;
    private final RewardTable rewardTable;
    private final Runnable callback;

    public EditRewardTableScreen(RewardTable originalTable, Runnable callback) {
        this.originalTable = originalTable;
        this.callback = callback;
        this.rewardTable = QuestObjectBase.copy(originalTable, () -> new RewardTable(0L, originalTable.getFile()));
        this.setTitle((class_2561)class_2561.method_43471((String)"ftbquests.reward_table").method_27693(": " + Objects.requireNonNull(this.rewardTable).getRawTitle()));
        this.setBorder(1, 1, 1);
    }

    public void addButtons(Panel panel) {
        panel.add((Widget)new RewardTableSettingsButton(panel));
        panel.add((Widget)new SaveRewardTableButton(panel));
        panel.add((Widget)new AddWeightedRewardButton(panel));
        panel.add((Widget)new VerticalSpaceWidget(panel, 1));
        this.rewardTable.getWeightedRewards().forEach(wr -> panel.add((Widget)new WeightedRewardButton(panel, (WeightedReward)wr)));
    }

    public void alignWidgets() {
        this.width = 186;
        super.alignWidgets();
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public boolean keyPressed(Key key) {
        if (key.esc()) {
            this.onBack();
            return true;
        }
        return super.keyPressed(key);
    }

    private class RewardTableSettingsButton
    extends SimpleTextButton {
        private RewardTableSettingsButton(Panel panel) {
            super(panel, (class_2561)class_2561.method_43471((String)"gui.settings"), Icons.SETTINGS);
            this.setHeight(12);
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            ConfigGroup group = new ConfigGroup("ftbquests", accepted -> this.run());
            EditRewardTableScreen.this.rewardTable.fillConfigGroup(EditRewardTableScreen.this.rewardTable.createSubGroup(group));
            new EditConfigScreen(group).openGui();
        }
    }

    private class SaveRewardTableButton
    extends SimpleTextButton {
        private SaveRewardTableButton(Panel panel) {
            super(panel, (class_2561)class_2561.method_43471((String)"gui.accept"), Icons.ACCEPT);
            this.setHeight(12);
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            this.closeGui();
            class_2487 nbt = new class_2487();
            EditRewardTableScreen.this.rewardTable.writeData(nbt);
            EditRewardTableScreen.this.originalTable.readData(nbt);
            EditRewardTableScreen.this.callback.run();
        }
    }

    private class AddWeightedRewardButton
    extends SimpleTextButton {
        private AddWeightedRewardButton(Panel panel) {
            super(panel, (class_2561)class_2561.method_43471((String)"gui.add"), Icons.ADD);
            this.setHeight(12);
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            for (RewardType type : RewardTypes.TYPES.values()) {
                if (type.getExcludeFromListRewards()) continue;
                contextMenu.add(new ContextMenuItem(type.getDisplayName(), type.getIconSupplier(), () -> {
                    this.playClickSound();
                    type.getGuiProvider().openCreationGui((Runnable)((Object)this), EditRewardTableScreen.this.rewardTable.getFakeQuest(), reward -> {
                        EditRewardTableScreen.this.rewardTable.addReward(new WeightedReward((Reward)reward, 1.0f));
                        this.openGui();
                    });
                }));
            }
            this.getGui().openContextMenu(contextMenu);
        }
    }

    private class WeightedRewardButton
    extends SimpleTextButton {
        private final WeightedReward wr;

        private WeightedRewardButton(Panel panel, WeightedReward wr) {
            super(panel, wr.getReward().getTitle(), wr.getReward().getIcon());
            this.wr = wr;
        }

        public void addMouseOverText(TooltipList list) {
            super.addMouseOverText(list);
            this.wr.getReward().addMouseOverText(list);
            String w = String.format("%.2f", Float.valueOf(this.wr.getWeight()));
            String str = WeightedReward.chanceString(this.wr.getWeight(), EditRewardTableScreen.this.rewardTable.getTotalWeight(true));
            list.add((class_2561)class_2561.method_43471((String)"ftbquests.reward_table.weight").method_27693(": " + w).method_10852((class_2561)class_2561.method_43470((String)(" [" + str + "]")).method_27692(class_124.field_1063)));
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"selectServer.edit"), Icons.SETTINGS, () -> {
                ConfigGroup group = new ConfigGroup("ftbquests", accepted -> this.run());
                this.wr.getReward().fillConfigGroup(this.wr.getReward().createSubGroup(group));
                new EditConfigScreen(group).openGui();
            }));
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.reward_table.set_weight"), Icons.SETTINGS, () -> {
                DoubleConfig c = new DoubleConfig(0.0, Double.POSITIVE_INFINITY);
                EditConfigFromStringScreen.open((ConfigFromString)c, (Object)this.wr.getWeight(), (Object)1.0, accepted -> {
                    if (accepted) {
                        this.wr.setWeight(((Double)c.getValue()).floatValue());
                    }
                    this.run();
                });
            }));
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"selectServer.delete"), Icons.REMOVE, () -> {
                EditRewardTableScreen.this.rewardTable.removeReward(this.wr);
                EditRewardTableScreen.this.refreshWidgets();
            }).setYesNoText((class_2561)class_2561.method_43469((String)"delete_item", (Object[])new Object[]{this.wr.getReward().getTitle()})));
            EditRewardTableScreen.this.openContextMenu(contextMenu);
        }

        public Optional<PositionedIngredient> getIngredientUnderMouse() {
            return PositionedIngredient.of(this.wr.getReward().getIngredient((Widget)this), (Widget)this);
        }
    }
}

