/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.config.ListConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.ContextMenu;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.MultilineTextBox;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.ScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.NordColors;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.ImageComponent;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.client.gui.quests.ViewQuestPanel;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import joptsimple.internal.Strings;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7533;
import org.jetbrains.annotations.NotNull;

public class MultilineTextEditorScreen
extends BaseScreen {
    private static final Pattern STRIP_FORMATTING_PATTERN = Pattern.compile("(?i)&[0-9A-FK-OR]");
    private static final int MAX_UNDO = 10;
    protected static final String LINK_TEXT_TEMPLATE = "{ \"text\": \"%s\", \"underlined\": \"true\", \"clickEvent\": { \"action\": \"change_page\", \"value\": \"%016X\" } }";
    private final class_2561 title;
    private final ListConfig<String, StringConfig> config;
    private final ConfigCallback callback;
    private final Panel outerPanel;
    private final Panel toolbarPanel;
    private final Panel textBoxPanel;
    private final MultilineTextBox textBox;
    private final PanelScrollBar scrollBar;
    private long ticksOpen = 0L;
    private final String initialText;
    private long lastChange = 0L;
    private final Deque<HistoryElement> redoStack = new ArrayDeque<HistoryElement>();
    private final Map<Integer, Runnable> hotKeys = Map.of(66, () -> this.insertFormatting(class_124.field_1067), 73, () -> this.insertFormatting(class_124.field_1056), 85, () -> this.insertFormatting(class_124.field_1073), 83, () -> this.insertFormatting(class_124.field_1055), 82, this::resetFormatting, 80, () -> this.insertAtEndOfLine("\n{@pagebreak}"), 77, this::openImageSelector, 90, this::undoLast, 76, this::openLinkInsert);

    public MultilineTextEditorScreen(class_2561 title, ListConfig<String, StringConfig> config, ConfigCallback callback) {
        this.title = title;
        this.config = config;
        this.callback = callback;
        this.outerPanel = new OuterPanel(this);
        this.toolbarPanel = new ToolbarPanel(this.outerPanel);
        this.textBoxPanel = new TextBoxPanel(this.outerPanel);
        this.textBox = new MultilineTextBox(this.textBoxPanel);
        this.textBox.setText(Strings.join((Iterable)((Iterable)config.getValue()), (String)"\n"));
        this.textBox.setFocused(true);
        this.textBox.setValueListener(this::onValueChanged);
        this.textBox.seekCursor(class_7533.field_39535, 0);
        this.redoStack.addLast(new HistoryElement(this.textBox.getText(), this.textBox.cursorPos()));
        this.scrollBar = new PanelScrollBar(this.outerPanel, ScrollBar.Plane.VERTICAL, this.textBoxPanel);
        this.scrollBar.setScrollStep((double)this.getTheme().getFontHeight());
        this.initialText = this.textBox.getText();
    }

    private void onValueChanged(String newValue) {
        this.lastChange = class_310.method_1551().field_1687.method_8510();
    }

    public void tick() {
        super.tick();
        ++this.ticksOpen;
        if (this.lastChange > 0L && class_310.method_1551().field_1687.method_8510() - this.lastChange > 5L) {
            this.redoStack.addLast(new HistoryElement(this.textBox.getText(), this.textBox.cursorPos()));
            while (this.redoStack.size() > 10) {
                this.redoStack.removeFirst();
            }
            this.lastChange = 0L;
        }
    }

    public boolean onInit() {
        this.setWidth(this.getScreen().method_4486() / 5 * 4);
        this.setHeight(this.getScreen().method_4502() / 5 * 4);
        this.ticksOpen = 0L;
        return true;
    }

    public void addWidgets() {
        this.add((Widget)this.outerPanel);
    }

    public void alignWidgets() {
        this.outerPanel.setPosAndSize(0, 0, this.width, this.height);
        this.toolbarPanel.setPosAndSize(2, 2, this.width - 4, 18);
        this.toolbarPanel.alignWidgets();
        this.textBoxPanel.setPosAndSize(2, this.toolbarPanel.height + 4, this.width - 18, this.height - this.toolbarPanel.height - 6);
        this.textBoxPanel.alignWidgets();
        this.scrollBar.setPosAndSize(this.width - 14, this.textBoxPanel.posY, 12, this.height - this.textBoxPanel.posY - 4);
    }

    public void drawBackground(class_332 matrixStack, Theme theme, int x, int y, int w, int h) {
        super.drawBackground(matrixStack, theme, x, y, w, h);
        theme.drawString(matrixStack, (Object)this.title, x + (this.width - theme.getStringWidth((class_5348)this.title)) / 2, y - theme.getFontHeight() - 2, 2);
    }

    public boolean keyPressed(Key key) {
        if (key.esc()) {
            this.cancel();
            return true;
        }
        if (key.enter() && class_437.method_25442()) {
            this.saveAndExit();
            return true;
        }
        if (this.textBox.isFocused()) {
            this.textBox.keyPressed(key);
            return true;
        }
        return false;
    }

    public void keyReleased(Key key) {
        this.executeHotkey(key.keyCode, true);
    }

    private void executeHotkey(int keycode, boolean checkModifier) {
        if (this.hotKeys.containsKey(keycode) && (!checkModifier || MultilineTextEditorScreen.isHotKeyModifierPressed(keycode))) {
            this.hotKeys.get(keycode).run();
            this.textBox.setFocused(true);
        }
    }

    public boolean charTyped(char c, KeyModifiers modifiers) {
        if (this.ticksOpen < 2L) {
            return true;
        }
        char keyCode = Character.toUpperCase(c);
        if (MultilineTextEditorScreen.isHotKeyModifierPressed(keyCode) && this.hotKeys.containsKey(keyCode)) {
            return false;
        }
        return super.charTyped(c, modifiers);
    }

    private static boolean isHotKeyModifierPressed(int keycode) {
        return keycode == 90 ? class_437.method_25441() : class_437.method_25443();
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private void openLinkInsert() {
        StringConfig c = new StringConfig(null);
        EditConfigFromStringScreen.open((ConfigFromString)c, (Object)"", (Object)"", (class_2561)class_2561.method_43470((String)"Enter Quest ID"), accepted -> {
            int pos = this.textBox.cursorPos();
            if (accepted) {
                QuestObjectBase.parseHexId((String)c.getValue()).ifPresentOrElse(questId -> {
                    QuestObject qo = FTBQuestsClient.getClientQuestFile().get((long)questId);
                    if (qo != null) {
                        this.doLinkInsertion((long)questId);
                    } else {
                        this.errorToPlayer("Unknown quest object id: %s", c.getValue());
                    }
                }, () -> this.errorToPlayer("Invalid quest object id: %s", c.getValue()));
            }
            this.run();
            this.textBox.seekCursor(class_7533.field_39535, pos);
        });
    }

    private void doLinkInsertion(long questID) {
        String text;
        if (this.textBox.hasSelection() && !(text = this.textBox.getSelectedText()).contains("\n")) {
            MultilineTextBox.StringExtents lineExtents = this.textBox.getLineView();
            MultilineTextBox.StringExtents selectionExtents = this.textBox.getSelected();
            ArrayList<String> parts = new ArrayList<String>();
            parts.add(this.textBox.getText().substring(lineExtents.start(), selectionExtents.start()));
            parts.add(this.textBox.getText().substring(selectionExtents.start(), selectionExtents.end()));
            parts.add(this.textBox.getText().substring(selectionExtents.end(), lineExtents.end()));
            StringBuilder builder = new StringBuilder("[ ");
            if (!((String)parts.get(0)).isEmpty()) {
                builder.append("\"").append((String)parts.get(0)).append("\", ");
            }
            builder.append(String.format(LINK_TEXT_TEMPLATE, parts.get(1), questID)).append(", ");
            if (!((String)parts.get(2)).isEmpty()) {
                builder.append("\"").append((String)parts.get(2)).append("\"");
            }
            builder.append(" ]");
            this.textBox.selectCurrentLine();
            this.textBox.insertText(builder.toString());
            return;
        }
        this.insertAtEndOfLine(String.format("\n{ \"text\": \"%s\", \"underlined\": \"true\", \"clickEvent\": { \"action\": \"change_page\", \"value\": \"%016X\" } }", "EDIT HERE", questID));
    }

    private void errorToPlayer(String msg, Object ... args) {
        QuestScreen.displayError((class_2561)class_2561.method_43470((String)String.format(msg, args)).method_27692(class_124.field_1061));
    }

    private void openImageSelector() {
        int cursor = this.textBox.cursorPos();
        ImageComponent component = new ImageComponent();
        ConfigGroup group = new ConfigGroup("ftbquests", accepted -> {
            this.openGui();
            if (accepted) {
                this.textBox.seekCursor(class_7533.field_39535, cursor);
                this.insertAtEndOfLine("\n" + component);
            }
        });
        group.add("image", (ConfigValue)new ImageConfig(), (Object)component.image.toString(), v -> {
            component.image = Icon.getIcon((String)v);
        }, (Object)"");
        group.addInt("width", component.width, v -> {
            component.width = v;
        }, 0, 1, 1000);
        group.addInt("height", component.height, v -> {
            component.height = v;
        }, 0, 1, 1000);
        group.addInt("align", component.align, v -> {
            component.align = v;
        }, 0, 1, 2);
        group.addBool("fit", component.fit, v -> {
            component.fit = v;
        }, false);
        new EditConfigScreen(group).openGui();
    }

    private void cancel() {
        if (!this.textBox.getText().equals(this.initialText)) {
            this.getGui().openYesNo((class_2561)class_2561.method_43471((String)"ftbquests.gui.confirm_esc"), (class_2561)class_2561.method_43473(), () -> this.callback.save(false));
        } else {
            this.callback.save(false);
        }
    }

    private void saveAndExit() {
        ((List)this.config.getValue()).clear();
        Collections.addAll((Collection)this.config.getValue(), this.textBox.getText().split("\n"));
        this.closeGui();
        this.callback.save(true);
    }

    private void insertFormatting(class_124 c) {
        if (this.textBox.hasSelection()) {
            this.textBox.insertText("&" + c.method_36145() + this.textBox.getSelectedText() + "&r");
        } else {
            this.textBox.insertText("&" + c.method_36145());
        }
        this.textBox.setFocused(true);
    }

    private void resetFormatting() {
        if (this.textBox.hasSelection()) {
            this.textBox.insertText(MultilineTextEditorScreen.stripFormatting(this.textBox.getSelectedText()));
        } else {
            this.textBox.insertText("&r");
        }
    }

    private static String stripFormatting(@NotNull String selectedText) {
        return STRIP_FORMATTING_PATTERN.matcher(selectedText).replaceAll("");
    }

    private void insertAtEndOfLine(String toInsert) {
        this.textBox.keyPressed(new Key(269, -1, 0));
        this.textBox.insertText(toInsert);
    }

    private void undoLast() {
        if (this.redoStack.size() > 1) {
            this.redoStack.removeLast();
            HistoryElement h = this.redoStack.peekLast();
            this.textBox.setValueListener(s -> {});
            this.textBox.setText(Objects.requireNonNull(h).text());
            this.textBox.setValueListener(this::onValueChanged);
            this.textBox.setSelecting(false);
            this.textBox.seekCursor(class_7533.field_39535, h.cursorPos());
        }
    }

    private class OuterPanel
    extends Panel {
        public OuterPanel(MultilineTextEditorScreen screen) {
            super((Panel)screen);
        }

        public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            theme.drawPanelBackground(graphics, x, y, w, h);
        }

        public void addWidgets() {
            this.addAll(List.of(MultilineTextEditorScreen.this.toolbarPanel, MultilineTextEditorScreen.this.textBoxPanel, MultilineTextEditorScreen.this.scrollBar));
        }

        public void alignWidgets() {
        }
    }

    private class ToolbarPanel
    extends Panel {
        private final ToolbarButton acceptButton;
        private final ToolbarButton cancelButton;
        private final ToolbarButton boldButton;
        private final ToolbarButton italicButton;
        private final ToolbarButton underlineButton;
        private final ToolbarButton strikethroughButton;
        private final ToolbarButton colorButton;
        private final ToolbarButton resetButton;
        private final ToolbarButton pageBreakButton;
        private final ToolbarButton imageButton;
        private final ToolbarButton undoButton;
        private final ToolbarButton linkButton;

        public ToolbarPanel(Panel outerPanel) {
            super(outerPanel);
            this.acceptButton = new ToolbarButton(this, (class_2561)class_2561.method_43471((String)"gui.accept"), Icons.ACCEPT, MultilineTextEditorScreen.this::saveAndExit).withTooltip(ToolbarPanel.hotkey("Shift + Enter"));
            this.cancelButton = new ToolbarButton(this, (class_2561)class_2561.method_43471((String)"gui.cancel"), Icons.CANCEL, MultilineTextEditorScreen.this::cancel).withTooltip(ToolbarPanel.hotkey("Escape"));
            this.boldButton = new ToolbarButton(this, (class_2561)class_2561.method_43470((String)"B").method_27692(class_124.field_1067), () -> MultilineTextEditorScreen.this.executeHotkey(66, false)).withTooltip(ToolbarPanel.hotkey("Alt + B"));
            this.italicButton = new ToolbarButton(this, (class_2561)class_2561.method_43470((String)"I").method_27692(class_124.field_1056), () -> MultilineTextEditorScreen.this.executeHotkey(73, false)).withTooltip(ToolbarPanel.hotkey("Alt + I"));
            this.underlineButton = new ToolbarButton(this, (class_2561)class_2561.method_43470((String)"U").method_27692(class_124.field_1073), () -> MultilineTextEditorScreen.this.executeHotkey(85, false)).withTooltip(ToolbarPanel.hotkey("Alt + U"));
            this.strikethroughButton = new ToolbarButton(this, (class_2561)class_2561.method_43470((String)"S").method_27692(class_124.field_1055), () -> MultilineTextEditorScreen.this.executeHotkey(83, false)).withTooltip(ToolbarPanel.hotkey("Alt + S"));
            this.colorButton = new ToolbarButton(this, (class_2561)class_2561.method_43473(), Icons.COLOR_RGB, this::openColorContextMenu);
            this.linkButton = new ToolbarButton(this, (class_2561)class_2561.method_43470((String)"L"), () -> MultilineTextEditorScreen.this.executeHotkey(76, false)).withTooltip(new class_2561[]{class_2561.method_43471((String)"ftbquests.gui.insert_link"), ToolbarPanel.hotkey("Alt + L")});
            this.resetButton = new ToolbarButton(this, (class_2561)class_2561.method_43470((String)"r"), () -> MultilineTextEditorScreen.this.executeHotkey(82, false)).withTooltip(new class_2561[]{class_2561.method_43471((String)"ftbquests.gui.clear_formatting"), ToolbarPanel.hotkey("Alt + R")});
            this.pageBreakButton = new ToolbarButton(this, (class_2561)class_2561.method_43473(), ViewQuestPanel.PAGEBREAK_ICON, () -> MultilineTextEditorScreen.this.executeHotkey(80, false)).withTooltip(new class_2561[]{class_2561.method_43471((String)"ftbquests.gui.page_break"), ToolbarPanel.hotkey("Alt + P")});
            this.imageButton = new ToolbarButton(this, (class_2561)class_2561.method_43473(), Icons.ART, () -> MultilineTextEditorScreen.this.executeHotkey(77, false)).withTooltip(new class_2561[]{class_2561.method_43471((String)"ftbquests.chapter.image"), ToolbarPanel.hotkey("Alt + M")});
            this.undoButton = new ToolbarButton(this, (class_2561)class_2561.method_43473(), Icons.REFRESH, () -> MultilineTextEditorScreen.this.executeHotkey(90, false)).withTooltip(new class_2561[]{class_2561.method_43471((String)"ftbquests.gui.undo"), ToolbarPanel.hotkey("Ctrl + Z")});
        }

        private static class_2561 hotkey(String str) {
            return class_2561.method_43470((String)("[" + str + "]")).method_27692(class_124.field_1063);
        }

        private void openColorContextMenu() {
            ArrayList<ContextMenuItem> items = new ArrayList<ContextMenuItem>();
            for (class_124 cf : class_124.values()) {
                if (cf.method_532() == null) continue;
                items.add(new ContextMenuItem((class_2561)class_2561.method_43473(), (Icon)Color4I.rgb((int)cf.method_532()), () -> MultilineTextEditorScreen.this.insertFormatting(cf)));
            }
            ContextMenu cMenu = new ContextMenu((Panel)MultilineTextEditorScreen.this, items);
            cMenu.setMaxRows(4);
            cMenu.setDrawVerticalSeparators(false);
            MultilineTextEditorScreen.this.openContextMenu(cMenu);
        }

        public void tick() {
            this.undoButton.setVisible(MultilineTextEditorScreen.this.redoStack.size() > 1);
        }

        public void addWidgets() {
            this.addAll(List.of(this.acceptButton, this.cancelButton, this.boldButton, this.italicButton, this.underlineButton, this.strikethroughButton, this.colorButton, this.linkButton, this.resetButton, this.pageBreakButton, this.imageButton, this.undoButton));
        }

        public void alignWidgets() {
            this.acceptButton.setPosAndSize(1, 1, 16, 16);
            this.boldButton.setPosAndSize(27, 1, 16, 16);
            this.italicButton.setPosAndSize(43, 1, 16, 16);
            this.underlineButton.setPosAndSize(59, 1, 16, 16);
            this.strikethroughButton.setPosAndSize(75, 1, 16, 16);
            this.colorButton.setPosAndSize(91, 1, 16, 16);
            this.linkButton.setPosAndSize(107, 1, 16, 16);
            this.resetButton.setPosAndSize(123, 1, 16, 16);
            this.pageBreakButton.setPosAndSize(149, 1, 16, 16);
            this.imageButton.setPosAndSize(165, 1, 16, 16);
            this.undoButton.setPosAndSize(191, 1, 16, 16);
            this.cancelButton.setPosAndSize(this.width - 17, 1, 16, 16);
        }

        public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            NordColors.POLAR_NIGHT_0.draw(graphics, x, y, w, h);
            theme.drawPanelBackground(graphics, x, y, w, h);
        }
    }

    private class TextBoxPanel
    extends Panel {
        private int cursorPos;

        public TextBoxPanel(Panel outerPanel) {
            super(outerPanel);
        }

        public void addWidgets() {
            this.add((Widget)MultilineTextEditorScreen.this.textBox);
        }

        public void refreshWidgets() {
            this.cursorPos = MultilineTextEditorScreen.this.textBox.cursorPos();
            super.refreshWidgets();
        }

        public void alignWidgets() {
            MultilineTextEditorScreen.this.textBox.setWidth(this.width - 3);
            this.setScrollY(0.0);
            MultilineTextEditorScreen.this.textBox.seekCursor(class_7533.field_39535, this.cursorPos);
        }

        public boolean mousePressed(MouseButton button) {
            boolean res = super.mousePressed(button);
            MultilineTextEditorScreen.this.textBox.setFocused(this.isMouseOver());
            return res;
        }
    }

    private record HistoryElement(@NotNull String text, int cursorPos) {
    }

    private static class ToolbarButton
    extends SimpleTextButton {
        private final Runnable onClick;
        private final List<class_2561> tooltip = new ArrayList<class_2561>();
        private boolean visible = true;

        public ToolbarButton(Panel panel, class_2561 txt, Icon icon, Runnable onClick) {
            super(panel, txt, icon);
            this.onClick = onClick;
        }

        public ToolbarButton(Panel panel, class_2561 txt, Runnable onClick) {
            this(panel, txt, (Icon)Color4I.empty(), onClick);
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public void onClicked(MouseButton button) {
            if (this.visible) {
                this.onClick.run();
            }
        }

        public void addMouseOverText(TooltipList list) {
            if (this.getGui().getTheme().getStringWidth((class_5348)this.title) > 0) {
                super.addMouseOverText(list);
            }
            if (this.visible) {
                this.tooltip.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
            }
        }

        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            if (this.visible) {
                super.draw(graphics, theme, x, y, w, h);
            }
        }

        public ToolbarButton withTooltip(class_2561 ... lines) {
            this.tooltip.addAll(Arrays.asList(lines));
            return this;
        }
    }
}

