/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestPositionableButton;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.ChapterImage;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;

public class ChapterImageButton
extends Button
implements QuestPositionableButton,
Comparable<ChapterImageButton> {
    private final QuestScreen questScreen;
    private final ChapterImage chapterImage;

    public ChapterImageButton(Panel panel, ChapterImage i) {
        super(panel, (class_2561)class_2561.method_43473(), i.getImage());
        this.questScreen = (QuestScreen)panel.getGui();
        this.setSize(20, 20);
        this.chapterImage = i;
    }

    public static Optional<ChapterImage> getClipboardImage() {
        ChapterImage img = (ChapterImage)ChapterImage.clipboard.get();
        if (img != null) {
            if (img.getChapter().isValid()) {
                return Optional.of(img);
            }
            ChapterImage.clipboard = new WeakReference<Object>(null);
        }
        return Optional.empty();
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.questScreen.questPanel.mouseOverQuest != null || this.questScreen.movingObjects || this.questScreen.viewQuestPanel.isMouseOver() || this.questScreen.chapterPanel.isMouseOver() || this.chapterImage.getClick().isEmpty() && !this.questScreen.file.canEdit()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public void onClicked(MouseButton button) {
        if (this.questScreen.file.canEdit() && button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"selectServer.edit"), (Icon)ThemeProperties.EDIT_ICON.get(), () -> {
                String name = this.chapterImage.getImage() instanceof Color4I ? this.chapterImage.getColor().toString() : this.chapterImage.getImage().toString();
                ConfigGroup group = new ConfigGroup("ftbquests", accepted -> {
                    if (accepted) {
                        new EditObjectMessage(this.chapterImage.getChapter()).sendToServer();
                    }
                    this.run();
                }).setNameKey("Img: " + name);
                this.chapterImage.fillConfigGroup(group.getOrCreateSubgroup("chapter").getOrCreateSubgroup("image"));
                new EditConfigScreen(group).openGui();
            }));
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.move"), (Icon)ThemeProperties.MOVE_UP_ICON.get(this.chapterImage.getChapter()), () -> this.questScreen.initiateMoving(this.chapterImage)){

                public void addMouseOverText(TooltipList list) {
                    list.add((class_2561)class_2561.method_43471((String)"ftbquests.gui.move_tooltip").method_27692(class_124.field_1063));
                }
            });
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.copy"), Icons.INFO, this.chapterImage::copyToClipboard){

                public void addMouseOverText(TooltipList list) {
                    list.add((class_2561)class_2561.method_43470((String)ChapterImageButton.this.chapterImage.getImage().toString()).method_27692(class_124.field_1063));
                }
            });
            if (this.chapterImage.isAspectRatioOff()) {
                contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.fix_aspect_ratio_w"), Icons.ART, () -> this.chapterImage.fixupAspectRatio(true)));
                contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.fix_aspect_ratio_h"), Icons.ART, () -> this.chapterImage.fixupAspectRatio(false)));
            }
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"selectServer.delete"), (Icon)ThemeProperties.DELETE_ICON.get(), () -> {
                this.chapterImage.getChapter().removeImage(this.chapterImage);
                new EditObjectMessage(this.chapterImage.getChapter()).sendToServer();
            }).setYesNoText((class_2561)class_2561.method_43469((String)"delete_item", (Object[])new Object[]{this.chapterImage.getImage().toString()})));
            this.getGui().openContextMenu(contextMenu);
        } else if (button.isLeft()) {
            if (class_437.method_25441() && this.questScreen.file.canEdit()) {
                this.questScreen.toggleSelected(this.chapterImage);
            } else if (!this.chapterImage.getClick().isEmpty()) {
                this.playClickSound();
                this.handleClick(this.chapterImage.getClick());
            }
        } else if (this.questScreen.file.canEdit() && button.isMiddle()) {
            if (!this.questScreen.selectedObjects.contains(this.chapterImage)) {
                this.questScreen.toggleSelected(this.chapterImage);
            }
            this.questScreen.movingObjects = true;
        }
    }

    public void addMouseOverText(TooltipList list) {
        this.chapterImage.addHoverText(list);
    }

    public boolean shouldDraw() {
        return false;
    }

    public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        boolean transparent;
        Icon image = this.chapterImage.getImage();
        boolean bl = transparent = !this.chapterImage.shouldShowImage(this.questScreen.file.selfTeamData);
        if (transparent) {
            image = image.withColor(Color4I.WHITE.withAlpha(100));
        } else if (!this.chapterImage.getColor().equals((Object)Color4I.WHITE) || this.chapterImage.getAlpha() < 255) {
            image = image.withColor(this.chapterImage.getColor().withAlpha(this.chapterImage.getAlpha()));
        }
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        if (this.chapterImage.isAlignToCorner()) {
            poseStack.method_46416((float)x, (float)y, 0.0f);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)this.chapterImage.getRotation()));
            poseStack.method_22905((float)w, (float)h, 1.0f);
            image.draw(graphics, 0, 0, 1, 1);
            if (this.questScreen.selectedObjects.contains(this.moveAndDeleteFocus())) {
                Color4I col = Color4I.WHITE.withAlpha((int)(128.0 + Math.sin((double)System.currentTimeMillis() * 0.003) * 50.0));
                col.draw(graphics, 0, 0, 1, 1);
            }
        } else {
            poseStack.method_46416((float)((int)((double)x + (double)w / 2.0)), (float)((int)((double)y + (double)h / 2.0)), 0.0f);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)this.chapterImage.getRotation()));
            poseStack.method_22905((float)w / 2.0f, (float)h / 2.0f, 1.0f);
            image.draw(graphics, -1, -1, 2, 2);
            if (this.questScreen.selectedObjects.contains(this.moveAndDeleteFocus())) {
                Color4I col = Color4I.WHITE.withAlpha((int)(128.0 + Math.sin((double)System.currentTimeMillis() * 0.003) * 50.0));
                col.draw(graphics, -1, -1, 2, 2);
            }
        }
        poseStack.method_22909();
    }

    @Override
    public QuestPositionableButton.Position getPosition() {
        return new QuestPositionableButton.Position(this.chapterImage.getX(), this.chapterImage.getY(), this.chapterImage.getWidth(), this.chapterImage.getHeight());
    }

    @Override
    public int compareTo(@NotNull ChapterImageButton o) {
        return Integer.compare(this.chapterImage.getOrder(), o.chapterImage.getOrder());
    }

    @Override
    public Movable moveAndDeleteFocus() {
        return this.chapterImage;
    }
}

