/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.gui.ChangeChapterGroupScreen;
import dev.ftb.mods.ftbquests.client.gui.ContextMenuBuilder;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.CreateObjectMessage;
import dev.ftb.mods.ftbquests.net.MoveChapterGroupMessage;
import dev.ftb.mods.ftbquests.net.MoveChapterMessage;
import dev.ftb.mods.ftbquests.net.ToggleChapterPinnedMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.ftb.mods.ftbquests.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;

public class ChapterPanel
extends Panel {
    public static final Icon ARROW_COLLAPSED = Icon.getIcon((String)"ftbquests:textures/gui/arrow_collapsed.png");
    public static final Icon ARROW_EXPANDED = Icon.getIcon((String)"ftbquests:textures/gui/arrow_expanded.png");
    private final QuestScreen questScreen;
    boolean expanded = this.isPinned();

    public ChapterPanel(Panel panel) {
        super(panel);
        this.questScreen = (QuestScreen)panel.getGui();
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.questScreen.viewQuestPanel.viewingQuest()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public void addWidgets() {
        this.add((Widget)new ModpackButton(this, this.questScreen.file));
        boolean canEdit = this.questScreen.file.canEdit();
        for (Chapter chapter : this.questScreen.file.getDefaultChapterGroup().getVisibleChapters(this.questScreen.file.selfTeamData)) {
            this.add((Widget)new ChapterButton(this, chapter));
        }
        if (canEdit) {
            // empty if block
        }
        this.questScreen.file.forAllChapterGroups(group -> {
            if (!group.isDefaultGroup()) {
                ChapterGroupButton button = new ChapterGroupButton(this, (ChapterGroup)group);
                if (canEdit || !button.visibleChapters.isEmpty()) {
                    this.add((Widget)button);
                    if (!group.isGuiCollapsed()) {
                        button.visibleChapters.forEach(chapter -> this.add((Widget)new ChapterButton(this, (Chapter)chapter)));
                    }
                }
            }
        });
    }

    public void alignWidgets() {
        int wd = 100;
        for (Widget w : this.widgets) {
            wd = Math.min(Math.max(wd, ((ListButton)w).getActualWidth(this.questScreen)), 800);
        }
        this.setPosAndSize((this.expanded || this.isPinned()) && !this.questScreen.isViewingQuest() ? 0 : -wd, 0, wd, this.questScreen.height);
        for (Widget w : this.widgets) {
            w.setWidth(wd);
        }
        this.align(WidgetLayout.VERTICAL);
        if (this.getContentHeight() <= this.height) {
            this.setScrollY(0.0);
        }
    }

    public void updateMouseOver(int mouseX, int mouseY) {
        super.updateMouseOver(mouseX, mouseY);
        if (this.expanded && !this.isPinned() && !this.isMouseOver()) {
            this.setExpanded(false);
        }
    }

    public int getX() {
        return (this.expanded || this.isPinned()) && !this.questScreen.isViewingQuest() ? 0 : -this.width;
    }

    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        theme.drawContextMenuBackground(graphics, x, y, w, h);
    }

    public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 600.0f);
        RenderSystem.enableDepthTest();
        super.draw(graphics, theme, x, y, w, h);
        graphics.method_51448().method_22909();
    }

    public void setExpanded(boolean b) {
        this.expanded = b;
    }

    boolean isPinned() {
        return ClientQuestFile.INSTANCE.selfTeamData.isChapterPinned((class_1657)class_310.method_1551().field_1724);
    }

    public static class ModpackButton
    extends ListButton {
        public ModpackButton(ChapterPanel panel, ClientQuestFile f) {
            super(panel, f.getTitle(), f.getIcon());
            this.setSize(100, 18);
        }

        public void onClicked(MouseButton button) {
            if (this.getMouseX() > this.getX() + this.width - 18) {
                this.playClickSound();
                new ToggleChapterPinnedMessage().sendToServer();
            } else if (this.chapterPanel.questScreen.file.canEdit() && this.getMouseX() > this.getX() + this.width - 34) {
                this.playClickSound();
                ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
                contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.chapter"), (Icon)ThemeProperties.ADD_ICON.get(), () -> {
                    StringConfig c = new StringConfig(Pattern.compile("^.+$"));
                    EditConfigFromStringScreen.open((ConfigFromString)c, (Object)"", (Object)"", accepted -> {
                        this.chapterPanel.questScreen.openGui();
                        if (accepted && !((String)c.getValue()).isEmpty()) {
                            Chapter chapter = new Chapter(0L, this.chapterPanel.questScreen.file, this.chapterPanel.questScreen.file.getDefaultChapterGroup());
                            chapter.setRawTitle((String)c.getValue());
                            class_2487 extra = new class_2487();
                            extra.method_10544("group", 0L);
                            new CreateObjectMessage(chapter, extra).sendToServer();
                        }
                        this.run();
                    });
                }));
                contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.chapter_group"), (Icon)ThemeProperties.ADD_ICON.get(), () -> {
                    this.playClickSound();
                    StringConfig c = new StringConfig(Pattern.compile("^.+$"));
                    EditConfigFromStringScreen.open((ConfigFromString)c, (Object)"", (Object)"", accepted -> {
                        this.chapterPanel.questScreen.openGui();
                        if (accepted) {
                            ChapterGroup group = new ChapterGroup(0L, ClientQuestFile.INSTANCE);
                            group.setRawTitle((String)c.getValue());
                            new CreateObjectMessage(group, null).sendToServer();
                        }
                    });
                }));
                this.chapterPanel.questScreen.openContextMenu(contextMenu);
            }
        }

        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            GuiHelper.setupDrawing();
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(40).draw(graphics, x + 1, y + 1, w - 2, h - 2);
            }
            class_124 f = this.isMouseOver() ? class_124.field_1068 : class_124.field_1080;
            this.icon.draw(graphics, x + 2, y + 3, 12, 12);
            theme.drawString(graphics, (Object)class_2561.method_43470((String)"").method_10852(this.title).method_27692(f), x + 16, y + 5);
            ((Color4I)ThemeProperties.WIDGET_BORDER.get(ClientQuestFile.INSTANCE)).draw(graphics, x, y + h - 1, w, 1);
            boolean canEdit = this.chapterPanel.questScreen.file.canEdit();
            ((Icon)(this.chapterPanel.isPinned() ? ThemeProperties.PIN_ICON_ON : ThemeProperties.PIN_ICON_OFF).get()).draw(graphics, x + w - 16, y + 3, 12, 12);
            if (canEdit) {
                ((Icon)ThemeProperties.ADD_ICON.get()).draw(graphics, x + w - 31, y + 3, 12, 12);
            }
        }

        @Override
        public int getActualWidth(QuestScreen screen) {
            boolean canEdit = this.chapterPanel.questScreen.file.canEdit();
            return screen.getTheme().getStringWidth((class_5348)this.title) + 36 + (canEdit ? 16 : 0);
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            this.chapterPanel.questScreen.addInfoTooltip(list, this.chapterPanel.questScreen.file);
            if (this.getMouseX() > this.getX() + this.width - 18) {
                list.string(this.chapterPanel.isPinned() ? "Stays open" : "Doesn't stay open");
            } else if (this.chapterPanel.questScreen.file.canEdit() && this.getMouseX() > this.getX() + this.width - 34) {
                list.translate("gui.add", new Object[0]);
            }
        }
    }

    public static class ChapterButton
    extends ListButton {
        private final Chapter chapter;
        private final List<? extends class_2561> description;

        public ChapterButton(ChapterPanel panel, Chapter c) {
            super(panel, c.getTitle(), c.getIcon());
            this.chapter = c;
            this.description = this.chapter.getRawSubtitle().stream().map(line -> TextUtils.parseRawText(line).method_27661().method_27692(class_124.field_1080)).toList();
        }

        public void onClicked(MouseButton button) {
            if (this.chapterPanel.questScreen.file.canEdit() || this.chapter.hasAnyVisibleChildren()) {
                this.playClickSound();
                if (this.chapterPanel.questScreen.selectedChapter != this.chapter) {
                    this.chapterPanel.questScreen.open(this.chapter, false);
                    this.chapter.getAutofocus().ifPresent(this.chapterPanel.questScreen::scrollTo);
                }
            }
            if (this.chapterPanel.questScreen.file.canEdit() && button.isRight()) {
                ContextMenuBuilder.create(this.chapter, this.chapterPanel.questScreen).insertAtTop(List.of(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.move"), (Icon)ThemeProperties.MOVE_UP_ICON.get(), () -> new MoveChapterMessage(this.chapter.id, true).sendToServer()).setEnabled(this.chapter.getIndex() > 0).setCloseMenu(false), new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.move"), (Icon)ThemeProperties.MOVE_DOWN_ICON.get(), () -> new MoveChapterMessage(this.chapter.id, false).sendToServer()).setEnabled(this.chapter.getIndex() < this.chapter.getGroup().getChapters().size() - 1).setCloseMenu(false), new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.change_group"), Icons.COLOR_RGB, () -> new ChangeChapterGroupScreen(this.chapter, this.chapterPanel.questScreen).openGui()))).openContextMenu(this.chapterPanel.questScreen);
            }
        }

        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            GuiHelper.setupDrawing();
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(40).draw(graphics, x + 1, y, w - 2, h);
            }
            Color4I c = this.chapter.getProgressColor(this.chapterPanel.questScreen.file.selfTeamData, !this.isMouseOver());
            int xOff = this.chapter.getGroup().isDefaultGroup() ? 0 : 7;
            this.icon.draw(graphics, x + 2 + xOff, y + 1, 12, 12);
            class_5250 text = class_2561.method_43470((String)"").method_10852(this.title).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)c.rgb())));
            if (this.chapterPanel.questScreen.selectedChapter != null && this.chapter.id == this.chapterPanel.questScreen.selectedChapter.id) {
                text.method_10852((class_2561)class_2561.method_43470((String)" \u25c0").method_27692(class_124.field_1080));
            }
            theme.drawString(graphics, (Object)text, x + 16 + xOff, y + 3);
            GuiHelper.setupDrawing();
            if (!this.chapter.hasAnyVisibleChildren()) {
                ((Icon)ThemeProperties.CLOSE_ICON.get()).draw(graphics, x + w - 12, y + 3, 8, 8);
            } else if (this.chapterPanel.questScreen.file.selfTeamData.hasUnclaimedRewards(class_310.method_1551().field_1724.method_5667(), this.chapter)) {
                ((Icon)ThemeProperties.ALERT_ICON.get()).draw(graphics, x + w - 12, y + 3, 8, 8);
            }
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            this.chapterPanel.questScreen.addInfoTooltip(list, this.chapter);
            for (class_2561 class_25612 : this.description) {
                list.add(class_25612);
            }
        }

        @Override
        public int getActualWidth(QuestScreen screen) {
            int extra;
            int n = extra = this.chapter.getGroup().isDefaultGroup() ? 0 : 7;
            if (!this.chapter.hasAnyVisibleChildren() || this.chapterPanel.questScreen.file.selfTeamData.hasUnclaimedRewards(class_310.method_1551().field_1724.method_5667(), this.chapter)) {
                extra += 16;
            }
            return screen.getTheme().getStringWidth((class_5348)this.title) + 20 + extra;
        }
    }

    public static abstract class ListButton
    extends Button {
        public final ChapterPanel chapterPanel;

        public ListButton(ChapterPanel panel, class_2561 t, Icon i) {
            super((Panel)panel, t, i);
            this.setSize(100, 14);
            this.chapterPanel = panel;
        }

        public int getActualWidth(QuestScreen screen) {
            return screen.getTheme().getStringWidth((class_5348)this.title) + 20;
        }

        public void addMouseOverText(TooltipList list) {
        }

        public Optional<PositionedIngredient> getIngredientUnderMouse() {
            return PositionedIngredient.of((Object)this.icon.getIngredient(), (Widget)this);
        }
    }

    public static class ChapterGroupButton
    extends ListButton {
        public final ChapterGroup group;
        public final List<Chapter> visibleChapters;

        public ChapterGroupButton(ChapterPanel panel, ChapterGroup g) {
            super(panel, g.getTitle(), g.getIcon());
            this.setSize(100, 18);
            this.group = g;
            this.visibleChapters = g.getVisibleChapters(panel.questScreen.file.selfTeamData);
        }

        public void onClicked(MouseButton button) {
            if (this.chapterPanel.questScreen.file.canEdit() && this.getMouseX() > this.getX() + this.width - 15) {
                this.playClickSound();
                StringConfig c = new StringConfig(Pattern.compile("^.+$"));
                EditConfigFromStringScreen.open((ConfigFromString)c, (Object)"", (Object)"", accepted -> {
                    this.chapterPanel.questScreen.openGui();
                    if (accepted && !((String)c.getValue()).isEmpty()) {
                        Chapter chapter = new Chapter(0L, this.chapterPanel.questScreen.file, this.chapterPanel.questScreen.file.getDefaultChapterGroup());
                        chapter.setRawTitle((String)c.getValue());
                        class_2487 extra = new class_2487();
                        extra.method_10544("group", this.group.id);
                        new CreateObjectMessage(chapter, extra).sendToServer();
                    }
                    this.run();
                });
                return;
            }
            if (this.chapterPanel.questScreen.file.canEdit() && button.isRight() && !this.group.isDefaultGroup()) {
                ContextMenuBuilder.create(this.group, this.chapterPanel.questScreen).insertAtTop(List.of(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.move"), (Icon)ThemeProperties.MOVE_UP_ICON.get(), () -> new MoveChapterGroupMessage(this.group.id, true).sendToServer()).setEnabled(!this.group.isFirstGroup()).setCloseMenu(false), new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.move"), (Icon)ThemeProperties.MOVE_DOWN_ICON.get(), () -> new MoveChapterGroupMessage(this.group.id, false).sendToServer()).setEnabled(!this.group.isLastGroup()).setCloseMenu(false))).openContextMenu(this.chapterPanel.questScreen);
                return;
            }
            this.group.toggleCollapsed();
            this.parent.refreshWidgets();
        }

        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            GuiHelper.setupDrawing();
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(40).draw(graphics, x + 1, y, w - 2, h);
            }
            class_124 f = this.isMouseOver() ? class_124.field_1068 : class_124.field_1080;
            (this.group.isGuiCollapsed() ? ARROW_COLLAPSED : ARROW_EXPANDED).withColor(Color4I.getChatFormattingColor((class_124)f)).draw(graphics, x + 3, y + 5, 8, 8);
            theme.drawString(graphics, (Object)class_2561.method_43470((String)"").method_10852(this.title).method_27692(f), x + 15, y + 5);
            boolean canEdit = this.chapterPanel.questScreen.file.canEdit();
            if (canEdit) {
                ((Icon)ThemeProperties.ADD_ICON.get()).draw(graphics, x + w - 14, y + 3, 12, 12);
            }
        }

        @Override
        public int getActualWidth(QuestScreen screen) {
            boolean canEdit = this.chapterPanel.questScreen.file.canEdit();
            return screen.getTheme().getStringWidth((class_5348)this.title) + 20 + (canEdit ? 16 : 0);
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            this.chapterPanel.questScreen.addInfoTooltip(list, this.group);
        }
    }
}

