/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import org.apache.commons.lang3.tuple.Pair;

public class KeyReferenceScreen
extends BaseScreen {
    private final Panel textPanel;
    private final PanelScrollBar scrollBar;
    private final SimpleTextButton closeButton;
    private final String[] translationKeys;
    private static final int SCROLLBAR_WIDTH = 16;
    private static final int GUTTER_SIZE = 2;

    public KeyReferenceScreen(String ... translationKeys) {
        this.translationKeys = translationKeys;
        this.textPanel = new TextPanel((Panel)this);
        this.closeButton = new SimpleTextButton((Panel)this, (class_2561)class_2561.method_43471((String)"gui.close"), Icons.CLOSE){

            public void onClicked(MouseButton button) {
                KeyReferenceScreen.this.onBack();
            }
        };
        this.scrollBar = new PanelScrollBar((Panel)this, this.textPanel);
    }

    public boolean onInit() {
        return this.setSizeProportional(0.7f, 0.8f);
    }

    public Theme getTheme() {
        return EditConfigScreen.THEME;
    }

    public void addWidgets() {
        this.add((Widget)this.textPanel);
        this.add((Widget)this.scrollBar);
        this.add((Widget)this.closeButton);
    }

    public void alignWidgets() {
        int textPanelWidth = this.getGui().width - 6 - 16;
        this.textPanel.setPosAndSize(2, 2, textPanelWidth, this.getGui().height - 4);
        this.textPanel.alignWidgets();
        this.scrollBar.setPosAndSize(this.getGui().width - 2 - 16, this.textPanel.getPosY(), 16, this.textPanel.getHeight());
        this.closeButton.setPosAndSize(this.width + 2, 0, 20, 20);
    }

    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        Color4I.DARK_GRAY.draw(graphics, x, y, w, h);
        class_5250 msg = class_2561.method_43471((String)"ftbquests.gui.key_reference");
        int w1 = theme.getStringWidth((class_5348)msg);
        theme.drawString(graphics, (Object)msg, x + (w - w1) / 2, y - theme.getFontHeight() - 1, Color4I.rgb((int)65535), 2);
    }

    private static List<Pair<class_2561, class_2561>> buildText(String ... translationKeys) {
        ArrayList<Pair<class_2561, class_2561>> res = new ArrayList<Pair<class_2561, class_2561>>();
        for (String translationKey : translationKeys) {
            block5: for (String line : class_1074.method_4662((String)translationKey, (Object[])new Object[0]).split("\\n")) {
                String[] parts = line.split(";", 2);
                switch (parts.length) {
                    case 0: {
                        res.add((Pair<class_2561, class_2561>)Pair.of((Object)class_2561.method_43473(), (Object)class_2561.method_43473()));
                        continue block5;
                    }
                    case 1: {
                        res.add((Pair<class_2561, class_2561>)Pair.of((Object)class_2561.method_43470((String)parts[0]).method_27695(new class_124[]{class_124.field_1054, class_124.field_1073}), (Object)class_2561.method_43473()));
                        continue block5;
                    }
                    default: {
                        res.add((Pair<class_2561, class_2561>)Pair.of((Object)class_2561.method_43470((String)parts[0]), (Object)class_2561.method_43470((String)parts[1]).method_27692(class_124.field_1080)));
                    }
                }
            }
            res.add((Pair<class_2561, class_2561>)Pair.of((Object)class_2561.method_43473(), (Object)class_2561.method_43473()));
        }
        return res;
    }

    private class TextPanel
    extends Panel {
        private final TwoColumnList textWidget;

        public TextPanel(Panel panel) {
            super(panel);
            this.textWidget = new TwoColumnList(this, KeyReferenceScreen.buildText(KeyReferenceScreen.this.translationKeys));
        }

        public void addWidgets() {
            this.add(this.textWidget);
        }

        public void alignWidgets() {
            this.align(WidgetLayout.VERTICAL);
            this.textWidget.setPos(2, 2);
        }

        public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            ((Icon)ThemeProperties.BACKGROUND.get()).draw(graphics, x, y, w, h);
        }
    }

    private static class TwoColumnList
    extends Widget {
        private final int widestL;
        private final List<Pair<class_2561, class_2561>> data;

        public TwoColumnList(Panel p, List<Pair<class_2561, class_2561>> data) {
            super(p);
            Theme theme = this.getGui().getTheme();
            this.data = data;
            int widestL = 0;
            int widestR = 0;
            int h = 0;
            for (Pair<class_2561, class_2561> entry : data) {
                boolean header = ((class_2561)entry.getRight()).method_10851().equals(class_7417.field_39004);
                widestL = Math.max(widestL, theme.getStringWidth((class_5348)entry.getLeft()));
                widestR = Math.max(widestR, theme.getStringWidth((class_5348)entry.getRight()));
                h += theme.getFontHeight() + (header ? 3 : 1);
            }
            this.widestL = widestL;
            this.width = widestL + 10 + widestR;
            this.height = h;
        }

        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            int yPos = y;
            for (Pair<class_2561, class_2561> entry : this.data) {
                boolean header = ((class_2561)entry.getRight()).method_10851().equals(class_7417.field_39004);
                int xOff = header ? this.widestL + 10 : this.widestL - theme.getStringWidth((class_5348)entry.getLeft()) - 2;
                theme.drawString(graphics, entry.getLeft(), x + xOff, yPos);
                theme.drawString(graphics, entry.getRight(), x + this.widestL + 10, yPos);
                yPos += theme.getFontHeight() + (header ? 3 : 1);
            }
        }
    }
}

