/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.gui.ContextMenuBuilder;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class RewardButton
extends Button {
    private final QuestScreen questScreen;
    private final Reward reward;

    public RewardButton(Panel panel, Reward reward) {
        super(panel, reward.getTitle(), reward.getIcon());
        this.questScreen = (QuestScreen)panel.getGui();
        this.reward = reward;
        this.setSize(18, 18);
    }

    public class_2561 getTitle() {
        if (this.reward.isTeamReward()) {
            return super.getTitle().method_27661().method_27692(class_124.field_1078);
        }
        return super.getTitle();
    }

    public void addMouseOverText(TooltipList list) {
        this.questScreen.addInfoTooltip(list, this.reward);
        if (this.reward.addTitleInMouseOverText()) {
            Reward reward = this.reward;
            if (reward instanceof ItemReward) {
                ItemReward itemReward = (ItemReward)reward;
                class_1836.class_1837 flag = class_310.method_1551().field_1690.field_1827 ? class_1836.field_41071 : class_1836.field_41070;
                itemReward.getItem().method_7950(FTBQuestsClient.getClientPlayer(), (class_1836)flag).forEach(arg_0 -> ((TooltipList)list).add(arg_0));
            } else {
                list.add(this.getTitle());
            }
        }
        if (this.reward.isTeamReward() || this.questScreen.file.selfTeamData.isRewardBlocked(this.reward)) {
            this.getIngredientUnderMouse().ifPresent(ingredient -> {
                class_1799 stack;
                Object patt2292$temp;
                if (ingredient.tooltip() && (patt2292$temp = ingredient.ingredient()) instanceof class_1799 && !(stack = (class_1799)patt2292$temp).method_7960()) {
                    ArrayList list1 = new ArrayList();
                    GuiHelper.addStackTooltip((class_1799)stack, list1);
                    list1.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
                }
            });
            list.blankLine();
            this.reward.addMouseOverText(list);
            if (this.reward.isTeamReward()) {
                list.add((class_2561)class_2561.method_43471((String)"ftbquests.reward.team_reward").method_27695(new class_124[]{class_124.field_1078, class_124.field_1073}));
            } else if (this.questScreen.file.selfTeamData.isRewardBlocked(this.reward)) {
                list.add((class_2561)class_2561.method_43469((String)"ftbquests.reward.this_blocked", (Object[])new Object[]{this.questScreen.file.selfTeamData}).method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}));
            }
        } else {
            this.reward.addMouseOverText(list);
            if (!list.shouldRender()) {
                list.zOffset = 580;
            }
        }
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (button.isRight() || this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public WidgetType getWidgetType() {
        if (!ClientQuestFile.exists() || !ClientQuestFile.INSTANCE.selfTeamData.isCompleted(this.reward.getQuest())) {
            return WidgetType.DISABLED;
        }
        return super.getWidgetType();
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            if (ClientQuestFile.exists()) {
                this.reward.onButtonClicked(this, ClientQuestFile.INSTANCE.selfTeamData.getClaimType(class_310.method_1551().field_1724.method_5667(), this.reward).canClaim());
            }
        } else if (button.isRight() && ClientQuestFile.exists() && ClientQuestFile.INSTANCE.canEdit()) {
            this.playClickSound();
            ContextMenuBuilder.create(this.reward, this.questScreen).openContextMenu(this.getGui());
        }
    }

    public Optional<PositionedIngredient> getIngredientUnderMouse() {
        return PositionedIngredient.of(this.reward.getIngredient((Widget)this), (Widget)this);
    }

    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(graphics, theme, x, y, w, h);
        }
    }

    public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        String s;
        int bs = h >= 32 ? 32 : 16;
        GuiHelper.setupDrawing();
        this.drawBackground(graphics, theme, x, y, w, h);
        this.drawIcon(graphics, theme, x + (w - bs) / 2, y + (h - bs) / 2, bs, bs);
        if (this.questScreen.file.selfTeamData == null) {
            return;
        }
        if (this.questScreen.getContextMenu().isEmpty()) {
            // empty if block
        }
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 200.0f);
        RenderSystem.enableBlend();
        boolean completed = false;
        if (this.questScreen.file.selfTeamData.getClaimType(class_310.method_1551().field_1724.method_5667(), this.reward).isClaimed()) {
            ((Icon)ThemeProperties.CHECK_ICON.get()).draw(graphics, x + w - 9, y + 1, 8, 8);
            completed = true;
        } else if (this.questScreen.file.selfTeamData.isCompleted(this.reward.getQuest())) {
            ((Icon)ThemeProperties.ALERT_ICON.get()).draw(graphics, x + w - 9, y + 1, 8, 8);
        }
        poseStack.method_22909();
        if (!completed && !(s = this.reward.getButtonText()).isEmpty()) {
            poseStack.method_22903();
            poseStack.method_22904((double)(x + 19) - (double)theme.getStringWidth(s) / 2.0, (double)(y + 15), 200.0);
            poseStack.method_22905(0.5f, 0.5f, 1.0f);
            theme.drawString(graphics, (Object)s, 0, 0, Color4I.WHITE, 2);
            poseStack.method_22909();
        }
    }
}

