/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import com.mojang.datafixers.util.Pair;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.config.ListConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.BlankPanel;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ColorWidget;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.CursorType;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.VerticalSpaceWidget;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.CompactGridLayout;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.ImageComponent;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.gui.ImageComponentWidget;
import dev.ftb.mods.ftbquests.client.gui.MultilineTextEditorScreen;
import dev.ftb.mods.ftbquests.client.gui.quests.AddRewardButton;
import dev.ftb.mods.ftbquests.client.gui.quests.AddTaskButton;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.client.gui.quests.RewardButton;
import dev.ftb.mods.ftbquests.client.gui.quests.TaskButton;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.net.TogglePinnedMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestLink;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.theme.QuestTheme;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import org.jetbrains.annotations.Nullable;

public class ViewQuestPanel
extends Panel {
    public static final Icon PAGEBREAK_ICON = Icon.getIcon((class_2960)new class_2960("ftbquests", "textures/gui/pagebreak.png"));
    private final QuestScreen questScreen;
    private Quest quest = null;
    boolean hidePanel = false;
    private Icon icon = Color4I.empty();
    private Button buttonOpenDependencies;
    private BlankPanel panelContent;
    private BlankPanel panelTasks;
    private BlankPanel panelText;
    private TextField titleField;
    private final List<Pair<Integer, Integer>> pageIndices = new ArrayList<Pair<Integer, Integer>>();
    private final Long2IntMap currentPages = new Long2IntOpenHashMap();
    private long lastScrollTime = 0L;

    public ViewQuestPanel(QuestScreen g) {
        super((Panel)g);
        this.questScreen = g;
        this.setPosAndSize(-1, -1, 0, 0);
        this.setOnlyRenderWidgetsInside(true);
        this.setOnlyInteractWithWidgetsInside(true);
    }

    public boolean viewingQuest() {
        return this.quest != null;
    }

    public boolean viewingQuest(Quest quest) {
        return this.quest == quest;
    }

    public Quest getViewedQuest() {
        return this.quest;
    }

    public boolean setViewedQuest(Quest newQuest) {
        if (this.quest != newQuest) {
            this.quest = newQuest;
            this.refreshWidgets();
            return true;
        }
        return false;
    }

    public boolean canEdit() {
        return this.quest.getQuestFile().canEdit();
    }

    private void buildPageIndices() {
        this.pageIndices.clear();
        if (this.quest != null) {
            this.pageIndices.addAll(this.quest.buildDescriptionIndex());
        }
    }

    private int getCurrentPage() {
        if (this.quest == null) {
            return 0;
        }
        int page = this.currentPages.getOrDefault(this.quest.id, 0);
        if (page < 0 || page >= this.pageIndices.size()) {
            page = 0;
            this.currentPages.put(this.quest.id, 0);
        }
        return page;
    }

    private void setCurrentPage(int page) {
        if (this.quest != null) {
            this.currentPages.put(this.quest.id, page);
        }
    }

    public void addWidgets() {
        SimpleButton buttonOpenDependants;
        this.setPosAndSize(-1, -1, 1, 1);
        if (this.quest == null || this.hidePanel) {
            return;
        }
        QuestObjectBase prev = QuestTheme.currentObject;
        QuestTheme.currentObject = this.quest;
        this.setScrollX(0.0);
        this.setScrollY(0.0);
        this.icon = this.quest.getIcon();
        boolean canEdit = this.questScreen.file.canEdit();
        this.titleField = new QuestDescriptionField(this, canEdit, b -> this.editTitle()).addFlags(4).setMinWidth(150).setMaxWidth(500).setSpacing(9).setText((class_2561)this.quest.getTitle().method_27661().method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)((Color4I)ThemeProperties.QUEST_VIEW_TITLE.get()).rgb()))));
        int w = Math.max(200, this.titleField.width + 54);
        if (this.quest.getMinWidth() > 0) {
            w = Math.max(this.quest.getMinWidth(), w);
        } else if (this.questScreen.selectedChapter.getDefaultMinWidth() > 0) {
            w = Math.max(this.questScreen.selectedChapter.getDefaultMinWidth(), w);
        }
        this.titleField.setPosAndSize(27, 4, w - 54, this.titleField.height);
        this.add((Widget)this.titleField);
        this.panelContent = new BlankPanel((Panel)this, "ContentPanel");
        this.add((Widget)this.panelContent);
        this.panelTasks = new BlankPanel((Panel)this.panelContent, "TasksPanel");
        this.panelContent.add((Widget)this.panelTasks);
        BlankPanel panelRewards = new BlankPanel((Panel)this.panelContent, "RewardsPanel");
        this.panelContent.add((Widget)panelRewards);
        this.panelText = new BlankPanel((Panel)this.panelContent, "TextPanel");
        this.panelContent.add((Widget)this.panelText);
        int bsize = 18;
        boolean seq = this.quest.getRequireSequentialTasks();
        for (Task task : this.quest.getTasks()) {
            TaskButton taskButton = new TaskButton((Panel)this.panelTasks, task);
            this.panelTasks.add((Widget)taskButton);
            taskButton.setSize(bsize, bsize);
            if (canEdit || !seq || this.questScreen.file.selfTeamData.isCompleted(task)) continue;
            break;
        }
        if (!canEdit && this.panelTasks.getWidgets().isEmpty()) {
            Object noTasks = new DisabledButtonTextField((Panel)this.panelTasks, (class_2561)class_2561.method_43471((String)"ftbquests.gui.no_tasks"));
            noTasks.setSize(((DisabledButtonTextField)((Object)noTasks)).width + 8, bsize);
            noTasks.setColor((Color4I)ThemeProperties.DISABLED_TEXT_COLOR.get(this.quest));
            this.panelTasks.add(noTasks);
        }
        for (Reward reward : this.quest.getRewards()) {
            if (!canEdit && (this.questScreen.file.selfTeamData.isRewardBlocked(reward) || reward.getAutoClaimType() == RewardAutoClaim.INVISIBLE)) continue;
            RewardButton b2 = new RewardButton((Panel)panelRewards, reward);
            panelRewards.add((Widget)b2);
            b2.setSize(bsize, bsize);
        }
        if (!canEdit && panelRewards.getWidgets().isEmpty()) {
            DisabledButtonTextField noRewards = new DisabledButtonTextField((Panel)panelRewards, (class_2561)class_2561.method_43471((String)"ftbquests.gui.no_rewards"));
            noRewards.setSize(noRewards.width + 8, bsize);
            noRewards.setColor((Color4I)ThemeProperties.DISABLED_TEXT_COLOR.get(this.quest));
            panelRewards.add((Widget)noRewards);
        }
        if (this.questScreen.file.canEdit()) {
            this.panelTasks.add((Widget)new AddTaskButton((Panel)this.panelTasks, this.quest));
            panelRewards.add((Widget)new AddRewardButton((Panel)panelRewards, this.quest));
        }
        int ww = 0;
        for (Widget widget2 : this.panelTasks.getWidgets()) {
            ww = Math.max(ww, widget2.width);
        }
        for (Widget widget2 : panelRewards.getWidgets()) {
            ww = Math.max(ww, widget2.width);
        }
        Color4I color4I = (Color4I)ThemeProperties.WIDGET_BORDER.get(this.questScreen.selectedChapter);
        ww = class_3532.method_15340((int)ww, (int)70, (int)140);
        w = Math.max(w, ww * 2 + 10);
        if ((Integer)ThemeProperties.FULL_SCREEN_QUEST.get(this.quest) == 1) {
            w = this.questScreen.width - 1;
        }
        if (w % 2 == 0) {
            ++w;
        }
        this.setWidth(w);
        this.panelContent.setPosAndSize(0, Math.max(16, this.titleField.height + 8), w, 0);
        int iconSize = Math.min(16, this.titleField.height + 2);
        CloseViewQuestButton buttonClose = new CloseViewQuestButton();
        this.add((Widget)buttonClose);
        buttonClose.setPosAndSize(w - iconSize - 2, 4, iconSize, iconSize);
        PinViewQuestButton buttonPin = new PinViewQuestButton();
        this.add((Widget)buttonPin);
        buttonPin.setPosAndSize(w - iconSize * 2 - 4, 4, iconSize, iconSize);
        if (this.questScreen.selectedChapter.id != this.quest.getChapter().id) {
            GotoLinkedQuestButton b3 = new GotoLinkedQuestButton();
            this.add((Widget)b3);
            b3.setPosAndSize(iconSize + 4, 0, iconSize, iconSize);
        }
        ArrayList<QuestLink> links = new ArrayList<QuestLink>();
        this.questScreen.file.forAllChapters(chapter -> chapter.getQuestLinks().stream().filter(link -> chapter != this.questScreen.selectedChapter && link.linksTo(this.quest)).forEach(links::add));
        ViewQuestLinksButton linksButton = new ViewQuestLinksButton(links);
        this.add((Widget)linksButton);
        linksButton.setPosAndSize(w - iconSize * 3 - 4, 0, iconSize, iconSize);
        if (!this.quest.hasDependencies()) {
            this.buttonOpenDependencies = new SimpleButton((Panel)this, (class_2561)class_2561.method_43471((String)"ftbquests.gui.no_dependencies"), Icon.getIcon((String)"ftbquests:textures/gui/arrow_left.png").withTint(color4I), (widget, button) -> {});
            this.add((Widget)this.buttonOpenDependencies);
        } else {
            this.buttonOpenDependencies = new SimpleButton((Panel)this, (class_2561)class_2561.method_43471((String)"ftbquests.gui.view_dependencies"), Icon.getIcon((String)"ftbquests:textures/gui/arrow_left.png").withTint((Color4I)ThemeProperties.QUEST_VIEW_TITLE.get()), (widget, button) -> this.showList(this.quest.streamDependencies().toList(), true));
            this.add((Widget)this.buttonOpenDependencies);
        }
        if (this.quest.getDependants().isEmpty()) {
            buttonOpenDependants = new SimpleButton((Panel)this, (class_2561)class_2561.method_43471((String)"ftbquests.gui.no_dependants"), Icon.getIcon((String)"ftbquests:textures/gui/arrow_right.png").withTint(color4I), (widget, button) -> {});
            this.add((Widget)buttonOpenDependants);
        } else {
            buttonOpenDependants = new SimpleButton((Panel)this, (class_2561)class_2561.method_43471((String)"ftbquests.gui.view_dependants"), Icon.getIcon((String)"ftbquests:textures/gui/arrow_right.png").withTint((Color4I)ThemeProperties.QUEST_VIEW_TITLE.get()), (widget, button) -> this.showList(this.quest.getDependants(), false));
            this.add((Widget)buttonOpenDependants);
        }
        this.buttonOpenDependencies.setPosAndSize(0, this.panelContent.posY + 2, 13, 13);
        buttonOpenDependants.setPosAndSize(w - 13, this.panelContent.posY + 2, 13, 13);
        TextField textFieldTasks = new TextField((Panel)this.panelContent){

            public TextField resize(Theme theme) {
                return this;
            }
        };
        int w2 = w / 2;
        textFieldTasks.setPosAndSize(2, 2, w2 - 3, 13);
        textFieldTasks.setMaxWidth(w);
        textFieldTasks.addFlags(36);
        textFieldTasks.setText((class_2561)class_2561.method_43471((String)"ftbquests.tasks"));
        textFieldTasks.setColor((Color4I)ThemeProperties.TASKS_TEXT_COLOR.get(this.quest));
        this.panelContent.add((Widget)textFieldTasks);
        TextField textFieldRewards = new TextField((Panel)this.panelContent){

            public TextField resize(Theme theme) {
                return this;
            }
        };
        textFieldRewards.setPosAndSize(w2 + 2, 2, w2 - 3, 13);
        textFieldRewards.setMaxWidth(w);
        textFieldRewards.addFlags(36);
        textFieldRewards.setText((class_2561)class_2561.method_43471((String)"ftbquests.rewards"));
        textFieldRewards.setColor((Color4I)ThemeProperties.REWARDS_TEXT_COLOR.get(this.quest));
        this.panelContent.add((Widget)textFieldRewards);
        this.panelTasks.setPosAndSize(2, 16, w2 - 3, 0);
        panelRewards.setPosAndSize(w2 + 2, 16, w2 - 3, 0);
        int at = this.panelTasks.align((WidgetLayout)new CompactGridLayout(bsize + 2));
        int ar = panelRewards.align((WidgetLayout)new CompactGridLayout(bsize + 2));
        int h = Math.max(at, ar);
        this.panelTasks.setHeight(h);
        panelRewards.setHeight(h);
        int tox = (this.panelTasks.width - this.panelTasks.getContentWidth()) / 2;
        int rox = (panelRewards.width - panelRewards.getContentWidth()) / 2;
        int toy = (this.panelTasks.height - this.panelTasks.getContentHeight()) / 2;
        int roy = (panelRewards.height - panelRewards.getContentHeight()) / 2;
        for (Widget widget3 : this.panelTasks.getWidgets()) {
            widget3.setX(widget3.posX + tox);
            widget3.setY(widget3.posY + toy);
        }
        for (Widget widget3 : panelRewards.getWidgets()) {
            widget3.setX(widget3.posX + rox);
            widget3.setY(widget3.posY + roy);
        }
        this.panelText.setPosAndSize(3, 16 + h + 12, w - 6, 0);
        class_2561 subtitle = this.quest.getSubtitle();
        if (subtitle.method_10851() == class_7417.field_39004 && canEdit) {
            subtitle = class_2561.method_43470((String)"[No Subtitle]");
        }
        if (!subtitle.equals(class_2561.method_43473())) {
            this.panelText.add((Widget)new QuestDescriptionField((Panel)this.panelText, canEdit, b -> this.editSubtitle()).addFlags(4).setMinWidth(this.panelText.width).setMaxWidth(this.panelText.width).setSpacing(9).setText((class_2561)class_2561.method_43470((String)"").method_10852(subtitle).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080})));
        }
        boolean showText = !this.quest.getHideTextUntilComplete().get(false) || this.questScreen.file.selfTeamData != null && this.questScreen.file.selfTeamData.isCompleted(this.quest);
        this.buildPageIndices();
        if (showText) {
            if (!this.pageIndices.isEmpty()) {
                this.addDescriptionText(canEdit, subtitle);
            }
            if (!this.quest.getGuidePage().isEmpty()) {
                if (subtitle.method_10851() != class_7417.field_39004) {
                    this.panelText.add((Widget)new VerticalSpaceWidget((Panel)this.panelText, 7));
                }
                this.panelText.add((Widget)new OpenInGuideButton((Panel)this.panelText, this.quest));
            }
        }
        if (this.pageIndices.size() > 1 || canEdit) {
            this.addButtonBar(canEdit);
        }
        if (this.panelText.getWidgets().isEmpty()) {
            this.panelContent.add(new ColorWidget((Panel)this.panelContent, color4I, null).setPosAndSize(w2, 0, 1, h + 40));
            this.panelText.setHeight(0);
            this.setHeight(Math.min(this.panelContent.getContentHeight(), this.parent.height - 10));
        } else {
            this.panelContent.add(new ColorWidget((Panel)this.panelContent, color4I, null).setPosAndSize(w2, 0, 1, 16 + h + 6));
            this.panelContent.add(new ColorWidget((Panel)this.panelContent, color4I, null).setPosAndSize(1, 16 + h + 6, w - 2, 1));
            this.panelText.setHeight(this.panelText.align((WidgetLayout)new WidgetLayout.Vertical(0, 1, 2)));
            this.setHeight(Math.min(this.panelContent.getContentHeight() + this.titleField.height + 12, this.parent.height - 10));
        }
        if ((Integer)ThemeProperties.FULL_SCREEN_QUEST.get(this.quest) == 1) {
            this.height = this.questScreen.height;
        }
        this.setPos((this.parent.width - this.width) / 2, (this.parent.height - this.height) / 2);
        this.panelContent.setHeight(this.height - 17);
        QuestTheme.currentObject = prev;
    }

    private void addDescriptionText(boolean canEdit, class_2561 subtitle) {
        Pair<Integer, Integer> pageSpan = this.pageIndices.get(this.getCurrentPage());
        if (subtitle.method_10851() != class_7417.field_39004) {
            this.panelText.add((Widget)new VerticalSpaceWidget((Panel)this.panelText, 7));
        }
        for (int i = ((Integer)pageSpan.getFirst()).intValue(); i <= (Integer)pageSpan.getSecond() && i < this.quest.getDescription().size(); ++i) {
            class_2561 component = this.quest.getDescription().get(i);
            ImageComponent img = this.findImageComponent(component);
            if (img != null) {
                ImageComponentWidget cw = new ImageComponentWidget(this, (Panel)this.panelText, img, i);
                if (cw.getComponent().fit) {
                    double scale = (double)this.panelText.width / (double)cw.width;
                    cw.setSize((int)((double)cw.width * scale), (int)((double)cw.height * scale));
                } else if (cw.getComponent().align == 1) {
                    cw.setX((this.panelText.width - cw.width) / 2);
                } else if (cw.getComponent().align == 2) {
                    cw.setX(this.panelText.width - cw.width);
                } else {
                    cw.setX(0);
                }
                this.panelText.add((Widget)cw);
                continue;
            }
            int line = i;
            TextField field = new QuestDescriptionField((Panel)this.panelText, canEdit, context -> this.editDescLine(line, (boolean)context, null)).setMaxWidth(this.panelText.width).setSpacing(9).setText(component);
            field.setWidth(this.panelText.width);
            this.panelText.add((Widget)field);
        }
    }

    private void addButtonBar(boolean canEdit) {
        this.panelText.add((Widget)new VerticalSpaceWidget((Panel)this.panelText, 3));
        BlankPanel buttonPanel = new BlankPanel((Panel)this.panelText);
        buttonPanel.setSize(this.panelText.width, 14);
        this.panelText.add((Widget)buttonPanel);
        final int currentPage = this.getCurrentPage();
        class_5250 page = class_2561.method_43470((String)(currentPage + 1 + "/" + this.pageIndices.size())).method_27692(class_124.field_1080);
        int labelWidth = this.questScreen.getTheme().getStringWidth((class_5348)page);
        if (currentPage > 0) {
            SimpleTextButton prevPage = new SimpleTextButton((Panel)buttonPanel, (class_2561)class_2561.method_43473(), (Icon)ThemeProperties.LEFT_ARROW.get()){

                public void onClicked(MouseButton mouseButton) {
                    ViewQuestPanel.this.setCurrentPage(Math.max(0, currentPage - 1));
                    ViewQuestPanel.this.refreshWidgets();
                }

                public void addMouseOverText(TooltipList list) {
                    list.add((class_2561)class_2561.method_43470((String)"[Page Up]").method_27692(class_124.field_1063));
                    list.add((class_2561)class_2561.method_43470((String)"[Mousewheel Up]").method_27692(class_124.field_1063));
                }
            };
            prevPage.setX(this.panelText.width - 43 - labelWidth);
            prevPage.setSize(16, 14);
            buttonPanel.add((Widget)prevPage);
        }
        if (this.pageIndices.size() > 1) {
            TextField pageLabel = new TextField((Panel)buttonPanel);
            pageLabel.setText((class_2561)page);
            pageLabel.setPosAndSize(this.panelText.width - 24 - labelWidth, 3, 20, 14);
            buttonPanel.add((Widget)pageLabel);
        }
        if (currentPage < this.pageIndices.size() - 1) {
            SimpleTextButton nextPage = new SimpleTextButton((Panel)buttonPanel, (class_2561)class_2561.method_43473(), (Icon)ThemeProperties.RIGHT_ARROW.get()){

                public void onClicked(MouseButton mouseButton) {
                    ViewQuestPanel.this.setCurrentPage(Math.min(ViewQuestPanel.this.pageIndices.size() + 1, currentPage + 1));
                    ViewQuestPanel.this.refreshWidgets();
                }

                public void addMouseOverText(TooltipList list) {
                    list.add((class_2561)class_2561.method_43470((String)"[Page Down]").method_27692(class_124.field_1063));
                    list.add((class_2561)class_2561.method_43470((String)"[Mousewheel Down]").method_27692(class_124.field_1063));
                }
            };
            nextPage.setSize(16, 14);
            nextPage.setX(this.panelText.width - 5 - nextPage.width);
            buttonPanel.add((Widget)nextPage);
        }
        if (canEdit) {
            SimpleTextButton edit = new SimpleTextButton((Panel)buttonPanel, (class_2561)class_2561.method_43471((String)"ftbquests.gui.edit").method_27693(" \u25bc"), (Icon)ThemeProperties.EDIT_ICON.get()){

                public void onClicked(MouseButton mouseButton) {
                    ViewQuestPanel.this.openEditButtonContextMenu();
                }
            };
            edit.setX((this.panelText.width - edit.width) / 2);
            edit.setHeight(14);
            buttonPanel.add((Widget)edit);
        }
    }

    private ImageComponent findImageComponent(class_2561 c) {
        Iterator iterator = c.method_10855().iterator();
        if (iterator.hasNext()) {
            class_2561 c1 = (class_2561)iterator.next();
            class_7417 class_74172 = c1.method_10851();
            if (class_74172 instanceof ImageComponent) {
                ImageComponent img = (ImageComponent)class_74172;
                return img;
            }
            return this.findImageComponent(c1);
        }
        return null;
    }

    public void alignWidgets() {
    }

    public void tick() {
        super.tick();
        if (this.quest != null && this.quest.hasDependencies() && !this.questScreen.file.selfTeamData.canStartTasks(this.quest) && this.buttonOpenDependencies != null) {
            float red = class_3532.method_15374((float)((float)(System.currentTimeMillis() % 1200L) * 0.0026179939f));
            Color4I col = Color4I.rgb((int)((int)(red * 127.0f + 63.0f)), (int)0, (int)0);
            this.buttonOpenDependencies.setIcon(Icon.getIcon((String)"ftbquests:textures/gui/arrow_left.png").withTint(col));
        }
    }

    private void showList(Collection<QuestObject> c, boolean dependencies) {
        int hidden = 0;
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        if (dependencies && this.quest.getMinRequiredDependencies() > 0) {
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43469((String)"ftbquests.quest.min_required_header", (Object[])new Object[]{this.quest.getMinRequiredDependencies()}).method_27692(class_124.field_1073), (Icon)Color4I.empty(), null).setEnabled(false));
        }
        for (QuestObject object : c) {
            if (this.questScreen.file.canEdit() || object.isVisible(this.questScreen.file.selfTeamData)) {
                class_5250 title = object.getMutableTitle();
                if (object.getQuestChapter() != null && object.getQuestChapter() != this.quest.getQuestChapter()) {
                    class_5250 suffix = class_2561.method_43470((String)" [").method_10852(object.getQuestChapter().getTitle()).method_27693("]").method_27692(class_124.field_1080);
                    title.method_10852((class_2561)suffix);
                }
                contextMenu.add(new ContextMenuItem((class_2561)title, (Icon)Color4I.empty(), () -> this.questScreen.open(object, true)));
                continue;
            }
            ++hidden;
        }
        if (hidden > 0) {
            class_5250 prefix = hidden == c.size() ? class_2561.method_43473() : class_2561.method_43470((String)"+ ");
            contextMenu.add(new ContextMenuItem((class_2561)prefix.method_10852((class_2561)class_2561.method_43469((String)"ftbquests.quest.hidden_quests_footer", (Object[])new Object[]{hidden})), (Icon)Color4I.empty(), null).setEnabled(false));
        }
        this.getGui().openContextMenu(contextMenu);
    }

    public void keyReleased(Key key) {
        if (this.hidePanel || this.quest == null) {
            return;
        }
        if (this.questScreen.file.canEdit()) {
            if (key.is(83)) {
                this.editSubtitle();
            } else if (key.is(84)) {
                this.editTitle();
            } else if (key.is(68)) {
                this.editDescription();
            } else if (key.is(80)) {
                this.addPageBreak();
            } else if (key.is(76)) {
                this.editDescLine0(-1, null);
            } else if (key.is(73)) {
                this.editDescLine0(-1, new ImageComponent());
            } else if (key.is(81)) {
                this.quest.onEditButtonClicked((Runnable)((Object)this.questScreen));
            }
        }
        if (key.is(266) || key.is(263)) {
            this.setCurrentPage(Math.max(0, this.getCurrentPage() - 1));
            this.refreshWidgets();
        } else if (key.is(267) || key.is(262)) {
            this.setCurrentPage(Math.min(this.pageIndices.size() - 1, this.getCurrentPage() + 1));
            this.refreshWidgets();
        }
    }

    private void editTitle() {
        StringConfig c = new StringConfig(null);
        QuestObject qo = this.quest;
        String titleKey = "ftbquests.title";
        for (Widget w : this.panelTasks.getWidgets()) {
            TaskButton b;
            if (!(w instanceof TaskButton) || !(b = (TaskButton)w).isMouseOver()) continue;
            qo = b.task;
            titleKey = "ftbquests.task_title";
            break;
        }
        Quest qo1 = qo;
        EditConfigFromStringScreen.open((ConfigFromString)c, (Object)qo1.getRawTitle(), (Object)"", (class_2561)class_2561.method_43471((String)titleKey), accepted -> {
            if (accepted) {
                qo1.setRawTitle((String)c.getValue());
                new EditObjectMessage(qo1).sendToServer();
            }
            this.openGui();
        });
    }

    private void editSubtitle() {
        StringConfig c = new StringConfig(null);
        EditConfigFromStringScreen.open((ConfigFromString)c, (Object)this.quest.getRawSubtitle(), (Object)"", (class_2561)class_2561.method_43471((String)"ftbquests.quest.subtitle"), accepted -> {
            if (accepted) {
                this.quest.setRawSubtitle((String)c.getValue());
                new EditObjectMessage(this.quest).sendToServer();
            }
            this.openGui();
        });
    }

    private void editDescription() {
        ListConfig lc = new ListConfig((ConfigValue)new StringConfig());
        lc.setValue(this.quest.getRawDescription());
        new MultilineTextEditorScreen((class_2561)class_2561.method_43471((String)"ftbquests.gui.edit_description"), (ListConfig<String, StringConfig>)lc, accepted -> {
            if (accepted) {
                new EditObjectMessage(this.quest).sendToServer();
                this.refreshWidgets();
            }
            this.openGui();
        }).openGui();
    }

    private void openEditButtonContextMenu() {
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.title").method_10852(ViewQuestPanel.hotkey("T")), Icons.NOTES, this::editTitle));
        contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.quest.subtitle").method_10852(ViewQuestPanel.hotkey("S")), Icons.NOTES, this::editSubtitle));
        contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.quest.description").method_10852(ViewQuestPanel.hotkey("D")), Icons.NOTES, this::editDescription));
        contextMenu.add(ContextMenuItem.SEPARATOR);
        contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.line").method_10852(ViewQuestPanel.hotkey("L")), Icons.NOTES, () -> this.editDescLine0(-1, null)));
        contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.page_break").method_10852(ViewQuestPanel.hotkey("P")), PAGEBREAK_ICON, this::addPageBreak));
        contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.image").method_10852(ViewQuestPanel.hotkey("I")), Icons.ART, () -> this.editDescLine0(-1, new ImageComponent())));
        contextMenu.add(ContextMenuItem.SEPARATOR);
        contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.edit_quest_props").method_10852(ViewQuestPanel.hotkey("Q")), Icons.SETTINGS, () -> this.quest.onEditButtonClicked((Runnable)((Object)this.questScreen))));
        this.getGui().openContextMenu(contextMenu);
    }

    private static class_2561 hotkey(String key) {
        return class_2561.method_43470((String)(" [" + key + "]")).method_27692(class_124.field_1063);
    }

    private void addPageBreak() {
        this.appendToPage(this.quest.getRawDescription(), List.of("{@pagebreak}", "(new page placeholder text)"), this.getCurrentPage());
        new EditObjectMessage(this.quest).sendToServer();
        this.setCurrentPage(Math.min(this.pageIndices.size() - 1, this.getCurrentPage() + 1));
        this.refreshWidgets();
    }

    private void editDescLine0(int line, @Nullable Object type) {
        if (type instanceof ImageComponent) {
            this.editImage(line, (ImageComponent)type);
            return;
        }
        StringConfig c = new StringConfig(null);
        List<String> rawDesc = this.quest.getRawDescription();
        int l = line + 1;
        int s = rawDesc.size();
        if (l == 0) {
            l = rawDesc.size() + 1;
            ++s;
        }
        class_5250 title = class_2561.method_43471((String)"ftbquests.quest.description").method_27693(String.format(": %d/%d", l, s));
        EditConfigFromStringScreen.open((ConfigFromString)c, (Object)(line == -1 ? "" : rawDesc.get(line)), (Object)"", (class_2561)title, accepted -> {
            if (accepted) {
                if (line == -1) {
                    this.appendToPage(rawDesc, List.of((String)c.getValue()), this.getCurrentPage());
                } else {
                    rawDesc.set(line, (String)c.getValue());
                }
                new EditObjectMessage(this.quest).sendToServer();
                this.refreshWidgets();
            }
            this.openGui();
        });
    }

    private void editImage(int line, ImageComponent component) {
        ConfigGroup group = new ConfigGroup("ftbquests", accepted -> {
            this.openGui();
            if (accepted) {
                if (line == -1) {
                    this.appendToPage(this.quest.getRawDescription(), List.of(component.toString()), this.getCurrentPage());
                } else {
                    this.quest.getRawDescription().set(line, component.toString());
                }
                new EditObjectMessage(this.quest).sendToServer();
                this.refreshWidgets();
            }
        });
        group.add("image", (ConfigValue)new ImageConfig(), (Object)component.image.toString(), v -> {
            component.image = Icon.getIcon((String)v);
        }, (Object)"");
        group.addInt("width", component.width, v -> {
            component.width = v;
        }, 0, 1, 1000);
        group.addInt("height", component.height, v -> {
            component.height = v;
        }, 0, 1, 1000);
        group.addInt("align", component.align, v -> {
            component.align = v;
        }, 0, 1, 2);
        group.addBool("fit", component.fit, v -> {
            component.fit = v;
        }, false);
        new EditConfigScreen(group).openGui();
    }

    private void appendToPage(List<String> list, List<String> toAdd, int pageNumber) {
        if (this.pageIndices.isEmpty()) {
            list.addAll(toAdd);
            this.buildPageIndices();
        } else {
            int idx = (Integer)this.pageIndices.get(pageNumber).getSecond() + 1;
            for (String line : toAdd) {
                list.add(idx, line);
                ++idx;
            }
        }
    }

    public void editDescLine(int line, boolean context, @Nullable Object type) {
        if (context) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"selectServer.edit"), (Icon)ThemeProperties.EDIT_ICON.get(), () -> this.editDescLine0(line, type)));
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"selectServer.delete"), (Icon)ThemeProperties.DELETE_ICON.get(), () -> {
                this.quest.getRawDescription().remove(line);
                new EditObjectMessage(this.quest).sendToServer();
                this.refreshWidgets();
            }));
            this.getGui().openContextMenu(contextMenu);
        } else {
            this.editDescLine0(line, type);
        }
    }

    public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        if (this.quest != null && !this.hidePanel) {
            QuestObjectBase prev = QuestTheme.currentObject;
            QuestTheme.currentObject = this.quest;
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, 500.0f);
            super.draw(graphics, theme, x, y, w, h);
            graphics.method_51448().method_22909();
            QuestTheme.currentObject = prev;
        }
    }

    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        Color4I borderColor = (Color4I)ThemeProperties.QUEST_VIEW_BORDER.get();
        Color4I.DARK_GRAY.withAlpha(120).draw(graphics, this.questScreen.getX(), this.questScreen.getY(), this.questScreen.width, this.questScreen.height);
        Icon background = (Icon)ThemeProperties.QUEST_VIEW_BACKGROUND.get();
        background.draw(graphics, x, y, w, h);
        if (this.titleField != null && this.panelContent != null) {
            int iconSize = Math.min(16, this.titleField.height + 2);
            this.icon.draw(graphics, x + 4, y + 4, iconSize, iconSize);
            borderColor.draw(graphics, x + 1, this.panelContent.getY(), w - 2, 1);
        }
    }

    public boolean mousePressed(MouseButton button) {
        return super.mousePressed(button) || this.isMouseOver();
    }

    public boolean mouseScrolled(double scroll) {
        long now = System.currentTimeMillis();
        if (super.mouseScrolled(scroll)) {
            this.lastScrollTime = now;
            return true;
        }
        if (now - this.lastScrollTime > 500L) {
            if (scroll < 0.0 && this.getCurrentPage() < this.pageIndices.size() - 1) {
                this.setCurrentPage(this.getCurrentPage() + 1);
                this.refreshWidgets();
                this.lastScrollTime = now;
                return true;
            }
            if (scroll > 0.0 && this.getCurrentPage() > 0) {
                this.setCurrentPage(this.getCurrentPage() - 1);
                this.refreshWidgets();
                this.lastScrollTime = now;
                return true;
            }
        }
        return false;
    }

    private class QuestDescriptionField
    extends TextField {
        private final boolean canEdit;
        private final Consumer<Boolean> editCallback;

        QuestDescriptionField(Panel panel, boolean canEdit, Consumer<Boolean> editCallback) {
            super(panel);
            this.canEdit = canEdit;
            this.editCallback = editCallback;
        }

        public boolean mousePressed(MouseButton button) {
            if (this.isMouseOver()) {
                Optional style;
                if (this.canEdit && button.isRight()) {
                    this.editCallback.accept(true);
                    return true;
                }
                if (button.isLeft() && class_310.method_1551().field_1755 != null && (style = this.getComponentStyleAt(ViewQuestPanel.this.questScreen.getTheme(), this.getMouseX(), this.getMouseY())).isPresent()) {
                    return this.handleCustomClickEvent((class_2583)style.get()) || class_310.method_1551().field_1755.method_25430((class_2583)style.get());
                }
            }
            return super.mousePressed(button);
        }

        private boolean handleCustomClickEvent(class_2583 style) {
            if (style == null) {
                return false;
            }
            class_2558 clickEvent = style.method_10970();
            if (clickEvent == null) {
                return false;
            }
            if (clickEvent.method_10845() == class_2558.class_2559.field_11748) {
                QuestObjectBase.parseHexId(clickEvent.method_10844()).ifPresentOrElse(questId -> {
                    QuestObject qo = ViewQuestPanel.this.quest.getQuestFile().get((long)questId);
                    if (qo != null) {
                        ViewQuestPanel.this.questScreen.open(qo, false);
                    } else {
                        this.errorToPlayer("Unknown quest object id: %s", clickEvent.method_10844());
                    }
                }, () -> this.errorToPlayer("Invalid quest object id: %s", clickEvent.method_10844()));
                return true;
            }
            if (clickEvent.method_10845() == class_2558.class_2559.field_11749) {
                try {
                    URI uri = new URI(clickEvent.method_10844());
                    String scheme = uri.getScheme();
                    if (scheme == null) {
                        throw new URISyntaxException(clickEvent.method_10844(), "Missing protocol");
                    }
                    if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
                        throw new URISyntaxException(clickEvent.method_10844(), "Unsupported protocol: " + scheme.toLowerCase(Locale.ROOT));
                    }
                    class_437 curScreen = class_310.method_1551().field_1755;
                    class_310.method_1551().method_1507((class_437)new class_407(accepted -> {
                        if (accepted) {
                            class_156.method_668().method_673(uri);
                        }
                        class_310.method_1551().method_1507(curScreen);
                    }, clickEvent.method_10844(), false));
                    return true;
                }
                catch (URISyntaxException e) {
                    this.errorToPlayer("Can't open url for %s (%s)", clickEvent.method_10844(), e.getMessage());
                    return true;
                }
            }
            return false;
        }

        private void errorToPlayer(String msg, Object ... args) {
            QuestScreen.displayError((class_2561)class_2561.method_43470((String)String.format(msg, args)).method_27692(class_124.field_1061));
        }

        public boolean mouseDoubleClicked(MouseButton button) {
            if (this.isMouseOver() && this.canEdit) {
                this.editCallback.accept(false);
                return true;
            }
            return false;
        }

        @Nullable
        public CursorType getCursor() {
            return this.canEdit ? CursorType.IBEAM : null;
        }

        public void addMouseOverText(TooltipList list) {
            if (!this.isMouseOver()) {
                return;
            }
            super.addMouseOverText(list);
            this.getComponentStyleAt(ViewQuestPanel.this.questScreen.getTheme(), this.getMouseX(), this.getMouseY()).ifPresent(style -> {
                if (style.method_10969() != null) {
                    class_1836.class_1837 flag;
                    class_2568 hoverevent = style.method_10969();
                    class_2568.class_5249 stackInfo = (class_2568.class_5249)hoverevent.method_10891(class_2568.class_5247.field_24343);
                    class_310 mc = class_310.method_1551();
                    class_1836.class_1837 class_18372 = flag = mc.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070;
                    if (stackInfo != null) {
                        stackInfo.method_27683().method_7950((class_1657)mc.field_1724, (class_1836)flag).forEach(arg_0 -> ((TooltipList)list).add(arg_0));
                    } else {
                        class_2568.class_5248 entityInfo = (class_2568.class_5248)hoverevent.method_10891(class_2568.class_5247.field_24344);
                        if (entityInfo != null) {
                            if (flag.method_8035()) {
                                entityInfo.method_27682().forEach(arg_0 -> ((TooltipList)list).add(arg_0));
                            }
                        } else {
                            class_2561 component = (class_2561)hoverevent.method_10891(class_2568.class_5247.field_24342);
                            if (component != null) {
                                list.add(component);
                            }
                        }
                    }
                }
            });
        }
    }

    public static class DisabledButtonTextField
    extends TextField {
        public DisabledButtonTextField(Panel panel, class_2561 text) {
            super(panel);
            this.addFlags(36);
            this.setText(text);
        }
    }

    private class CloseViewQuestButton
    extends AbstractPanelButton {
        private CloseViewQuestButton() {
            super((class_2561)class_2561.method_43471((String)"gui.close"), (Icon)ThemeProperties.CLOSE_ICON.get(ViewQuestPanel.this.quest));
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            ViewQuestPanel.this.questScreen.closeQuest();
        }
    }

    private class PinViewQuestButton
    extends AbstractPanelButton {
        private PinViewQuestButton() {
            super((class_2561)class_2561.method_43471((String)(ClientQuestFile.isQuestPinned(ViewQuestPanel.this.quest.id) ? "ftbquests.gui.unpin" : "ftbquests.gui.pin")), ClientQuestFile.isQuestPinned(ViewQuestPanel.this.quest.id) ? (Icon)ThemeProperties.PIN_ICON_ON.get() : (Icon)ThemeProperties.PIN_ICON_OFF.get());
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            new TogglePinnedMessage(ViewQuestPanel.this.quest.id).sendToServer();
        }
    }

    private class GotoLinkedQuestButton
    extends AbstractPanelButton {
        public GotoLinkedQuestButton() {
            super((class_2561)class_2561.method_43469((String)"ftbquests.gui.goto_linked_quest", (Object[])new Object[]{ViewQuestPanel.this.quest.getChapter().getMutableTitle().method_27692(class_124.field_1054)}), (Icon)ThemeProperties.LINK_ICON.get());
        }

        public void onClicked(MouseButton button) {
            double qx = ViewQuestPanel.this.quest.getX() + 0.5;
            double qy = ViewQuestPanel.this.quest.getY() + 0.5;
            ViewQuestPanel.this.questScreen.selectChapter(ViewQuestPanel.this.quest.getChapter());
            ViewQuestPanel.this.questScreen.questPanel.scrollTo(qx, qy);
        }
    }

    private class ViewQuestLinksButton
    extends AbstractPanelButton {
        private final List<QuestLink> links;

        public ViewQuestLinksButton(Collection<QuestLink> links) {
            super((class_2561)class_2561.method_43471((String)"ftbquests.gui.view_quest_links"), (Icon)ThemeProperties.LINK_ICON.get());
            this.links = List.copyOf(links);
        }

        public void onClicked(MouseButton button) {
            ArrayList items = new ArrayList();
            for (QuestLink link : this.links) {
                link.getQuest().ifPresent(quest -> {
                    class_5250 title = quest.getTitle().method_27661().method_27693(": ").method_10852((class_2561)link.getChapter().getTitle().method_27661().method_27692(class_124.field_1054));
                    items.add(new ContextMenuItem((class_2561)title, quest.getIcon(), () -> this.gotoLink(link)));
                });
            }
            if (!items.isEmpty()) {
                ViewQuestPanel.this.questScreen.openContextMenu(items);
            }
        }

        private void gotoLink(QuestLink link) {
            ViewQuestPanel.this.questScreen.closeQuest();
            ViewQuestPanel.this.questScreen.selectChapter(link.getChapter());
            ViewQuestPanel.this.questScreen.questPanel.scrollTo(link.getX() + 0.5, link.getX() + 0.5);
        }

        public boolean isEnabled() {
            return !this.links.isEmpty();
        }

        public boolean shouldDraw() {
            return !this.links.isEmpty();
        }
    }

    public static class OpenInGuideButton
    extends SimpleTextButton {
        private final Quest quest;

        public OpenInGuideButton(Panel panel, Quest q) {
            super(panel, (class_2561)class_2561.method_43471((String)"ftbquests.gui.open_in_guide"), ItemIcon.getItemIcon((class_1792)class_1802.field_8529));
            this.setHeight(13);
            this.setX((panel.width - this.width) / 2);
            this.quest = q;
        }

        public void onClicked(MouseButton button) {
            this.handleClick("guide", this.quest.getGuidePage());
        }

        public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        }
    }

    private abstract class AbstractPanelButton
    extends SimpleTextButton {
        public AbstractPanelButton(class_2561 txt, Icon icon) {
            super((Panel)ViewQuestPanel.this, txt, icon);
        }

        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            this.drawIcon(graphics, theme, x + 1, y + 1, w - 2, h - 2);
        }
    }
}

