/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.integration.item_filtering;

import dev.ftb.mods.ftbquests.api.ItemFilterAdapter;
import dev.ftb.mods.ftbquests.api.event.CustomFilterDisplayItemsEvent;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class DisplayStacksCache {
    private static final int MAX_CACHE_SIZE = 1024;
    private static final Object2ObjectLinkedOpenHashMap<CacheKey, List<class_1799>> cache = new Object2ObjectLinkedOpenHashMap(1024);

    @NotNull
    public static List<class_1799> getCachedDisplayStacks(class_1799 filterStack, ItemFilterAdapter adapter) {
        CacheKey key = new CacheKey(filterStack);
        List<class_1799> result = (List<class_1799>)cache.getAndMoveToFirst((Object)key);
        if (result == null) {
            result = DisplayStacksCache.computeMatchingStacks(adapter.getMatcher(filterStack));
            cache.put((Object)key, result);
            if (cache.size() >= 1024) {
                cache.removeLast();
            }
        }
        return result;
    }

    private static List<class_1799> computeMatchingStacks(ItemFilterAdapter.Matcher matcher) {
        FTBQuestsClient.registryAccess().ifPresent(ra -> class_7706.method_47330((class_7699)class_7701.field_40183, (boolean)true, (class_7225.class_7874)ra));
        List res = class_7706.method_47344().method_45414().stream().filter(matcher).collect(Collectors.toCollection(ArrayList::new));
        ArrayList extra = new ArrayList();
        ((Consumer)CustomFilterDisplayItemsEvent.ADD_ITEMSTACK.invoker()).accept(new CustomFilterDisplayItemsEvent(extra::add));
        res.addAll(extra.stream().filter(matcher).toList());
        return Collections.unmodifiableList(res);
    }

    public static void clear() {
        cache.clear();
    }

    private static class CacheKey {
        private final int key;

        private CacheKey(class_1799 filterStack) {
            this.key = Objects.hash(class_7923.field_41178.method_10206((Object)filterStack.method_7909()), filterStack.method_7985() ? filterStack.method_7969().hashCode() : 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.key == cacheKey.key;
        }

        public int hashCode() {
            return this.key;
        }
    }
}

