/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import dev.architectury.event.EventActor;
import dev.architectury.utils.Env;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.api.QuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.events.ClearFileCacheEvent;
import dev.ftb.mods.ftbquests.events.CustomTaskEvent;
import dev.ftb.mods.ftbquests.events.ObjectCompletedEvent;
import dev.ftb.mods.ftbquests.events.ObjectStartedEvent;
import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.integration.RecipeModHelper;
import dev.ftb.mods.ftbquests.item.MissingItem;
import dev.ftb.mods.ftbquests.net.DeleteObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.DefaultChapterGroup;
import dev.ftb.mods.ftbquests.quest.ProgressionMode;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestLink;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.loot.EntityWeight;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.reward.CustomReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.task.CustomTask;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.ftb.mods.ftbquests.util.FileUtils;
import dev.ftb.mods.ftbquests.util.NetUtils;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseQuestFile
extends QuestObject
implements QuestFile {
    public static int VERSION = 13;
    private final DefaultChapterGroup defaultChapterGroup = new DefaultChapterGroup(this);
    final List<ChapterGroup> chapterGroups = new ArrayList<ChapterGroup>();
    private final List<RewardTable> rewardTables;
    protected final Map<UUID, TeamData> teamDataMap;
    private final Long2ObjectOpenHashMap<QuestObjectBase> questObjectMap;
    protected final Int2ObjectOpenHashMap<TaskType> taskTypeIds;
    protected final Int2ObjectOpenHashMap<RewardType> rewardTypeIds;
    private final List<class_1799> emergencyItems;
    private int emergencyItemsCooldown;
    private int fileVersion = 0;
    private boolean defaultPerTeamReward;
    private boolean defaultTeamConsumeItems;
    private RewardAutoClaim defaultRewardAutoClaim;
    private String defaultQuestShape;
    private boolean defaultQuestDisableJEI;
    private boolean dropLootCrates;
    private final EntityWeight lootCrateNoDrop;
    private boolean disableGui;
    private double gridScale;
    private boolean pauseGame;
    protected String lockMessage;
    private ProgressionMode progressionMode;
    private int detectionDelay;
    private List<Task> allTasks;
    private List<Task> submitTasks;
    private List<Task> craftingTasks;

    public BaseQuestFile() {
        super(1L);
        this.chapterGroups.add(this.defaultChapterGroup);
        this.rewardTables = new ArrayList<RewardTable>();
        this.teamDataMap = new HashMap<UUID, TeamData>();
        this.questObjectMap = new Long2ObjectOpenHashMap();
        this.taskTypeIds = new Int2ObjectOpenHashMap();
        this.rewardTypeIds = new Int2ObjectOpenHashMap();
        this.emergencyItems = new ArrayList<class_1799>();
        this.emergencyItemsCooldown = 300;
        this.defaultPerTeamReward = false;
        this.defaultTeamConsumeItems = false;
        this.defaultRewardAutoClaim = RewardAutoClaim.DISABLED;
        this.defaultQuestShape = "circle";
        this.defaultQuestDisableJEI = false;
        this.dropLootCrates = false;
        this.lootCrateNoDrop = new EntityWeight();
        this.lootCrateNoDrop.passive = 4000;
        this.lootCrateNoDrop.monster = 600;
        this.lootCrateNoDrop.boss = 0;
        this.disableGui = false;
        this.gridScale = 0.5;
        this.pauseGame = false;
        this.lockMessage = "";
        this.progressionMode = ProgressionMode.LINEAR;
        this.detectionDelay = 20;
        this.allTasks = null;
    }

    public abstract Env getSide();

    @Override
    public boolean isServerSide() {
        return this.getSide() == Env.SERVER;
    }

    @Override
    public BaseQuestFile getQuestFile() {
        return this;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.FILE;
    }

    public boolean isLoading() {
        return false;
    }

    @Override
    public boolean canEdit() {
        return false;
    }

    public Path getFolder() {
        throw new IllegalStateException("This quest file doesn't have a folder!");
    }

    @Override
    public int getRelativeProgressFromChildren(TeamData data) {
        MutableInt progress = new MutableInt(0);
        MutableInt chapters = new MutableInt(0);
        this.forAllChapters(chapter -> {
            progress.add(data.getRelativeProgress((QuestObject)chapter));
            chapters.increment();
        });
        return BaseQuestFile.getRelativeProgressFromChildren(progress.intValue(), chapters.intValue());
    }

    @Override
    public void onStarted(QuestProgressEventData<?> data) {
        data.setStarted(this.id);
        ((EventActor)ObjectStartedEvent.FILE.invoker()).act((Object)new ObjectStartedEvent.FileEvent(data.withObject(this)));
    }

    @Override
    public void onCompleted(QuestProgressEventData<?> data) {
        data.setCompleted(this.id);
        ((EventActor)ObjectCompletedEvent.FILE.invoker()).act((Object)new ObjectCompletedEvent.FileEvent(data.withObject(this)));
        if (!this.disableToast) {
            data.notifyPlayers(this.id);
        }
    }

    @Override
    public void deleteSelf() {
        this.invalid = true;
    }

    @Override
    public void deleteChildren() {
        this.forAllChapters(chapter -> {
            chapter.deleteChildren();
            chapter.invalid = true;
        });
        this.defaultChapterGroup.clearChapters();
        this.chapterGroups.clear();
        this.chapterGroups.add(this.defaultChapterGroup);
        for (RewardTable table : this.rewardTables) {
            table.deleteChildren();
            table.invalid = true;
        }
        this.rewardTables.clear();
    }

    @Nullable
    public QuestObjectBase getBase(long id) {
        if (id <= 0L) {
            return null;
        }
        if (id == 1L) {
            return this;
        }
        QuestObjectBase object = (QuestObjectBase)this.questObjectMap.get(id);
        return object == null || object.invalid ? null : object;
    }

    @Nullable
    public QuestObject get(long id) {
        QuestObject qo;
        QuestObjectBase questObjectBase = this.getBase(id);
        return questObjectBase instanceof QuestObject ? (qo = (QuestObject)questObjectBase) : null;
    }

    @Nullable
    public QuestObjectBase remove(long id) {
        QuestObjectBase object = (QuestObjectBase)this.questObjectMap.remove(id);
        if (object != null) {
            if (object instanceof QuestObject) {
                QuestObject qo = (QuestObject)object;
                this.forAllQuests(quest -> quest.removeDependency(qo));
            }
            object.invalid = true;
            this.refreshIDMap();
            return object;
        }
        return null;
    }

    @Nullable
    public Chapter getChapter(long id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof Chapter ? (Chapter)object : null;
    }

    @NotNull
    public Chapter getChapterOrThrow(long id) {
        QuestObjectBase questObjectBase = this.getBase(id);
        if (questObjectBase instanceof Chapter) {
            Chapter c = (Chapter)questObjectBase;
            return c;
        }
        throw new IllegalArgumentException("Unknown chapter ID: c");
    }

    @Nullable
    public Quest getQuest(long id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof Quest ? (Quest)object : null;
    }

    @Nullable
    public Task getTask(long id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof Task ? (Task)object : null;
    }

    @Nullable
    public Reward getReward(long id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof Reward ? (Reward)object : null;
    }

    @Nullable
    public RewardTable getRewardTable(long id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof RewardTable ? (RewardTable)object : null;
    }

    @Nullable
    public LootCrate getLootCrate(String id) {
        RewardTable table;
        if (!id.startsWith("#")) {
            for (RewardTable table2 : this.rewardTables) {
                if (table2.getLootCrate() == null || !table2.getLootCrate().getStringID().equals(id)) continue;
                return table2.getLootCrate();
            }
        }
        return (table = this.getRewardTable(this.getID(id))) == null ? null : table.getLootCrate();
    }

    public ChapterGroup getChapterGroup(long id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof ChapterGroup ? (ChapterGroup)object : this.defaultChapterGroup;
    }

    public void refreshIDMap() {
        this.clearCachedData();
        this.questObjectMap.clear();
        this.chapterGroups.forEach(group -> this.questObjectMap.put(group.id, group));
        this.rewardTables.forEach(table -> this.questObjectMap.put(table.id, table));
        this.forAllChapters(chapter -> {
            this.questObjectMap.put(chapter.id, chapter);
            for (Quest quest : chapter.getQuests()) {
                this.questObjectMap.put(quest.id, (Object)quest);
                quest.getTasks().forEach(task -> this.questObjectMap.put(task.id, task));
                quest.getRewards().forEach(reward -> this.questObjectMap.put(reward.id, reward));
            }
            chapter.getQuestLinks().forEach(link -> this.questObjectMap.put(link.id, link));
        });
        this.clearCachedData();
    }

    public QuestObjectBase create(long id, QuestObjectType type, long parent, class_2487 extra) {
        switch (type) {
            case CHAPTER: {
                return new Chapter(id, this, this.getChapterGroup(extra.method_10537("group")));
            }
            case QUEST: {
                Chapter chapter = this.getChapter(parent);
                if (chapter != null) {
                    return new Quest(id, chapter);
                }
                throw new IllegalArgumentException("Parent chapter not found!");
            }
            case QUEST_LINK: {
                Chapter chapter = this.getChapter(parent);
                if (chapter != null) {
                    return new QuestLink(id, chapter, 0L);
                }
                throw new IllegalArgumentException("Parent chapter not found!");
            }
            case TASK: {
                Quest quest = this.getQuest(parent);
                if (quest != null) {
                    Task task = TaskType.createTask(id, quest, extra.method_10558("type"));
                    if (task != null) {
                        return task;
                    }
                    throw new IllegalArgumentException("Unknown task type!");
                }
                throw new IllegalArgumentException("Parent quest not found!");
            }
            case REWARD: {
                Quest quest = this.getQuest(parent);
                if (quest != null) {
                    Reward reward = RewardType.createReward(id, quest, extra.method_10558("type"));
                    if (reward != null) {
                        return reward;
                    }
                    throw new IllegalArgumentException("Unknown reward type!");
                }
                throw new IllegalArgumentException("Parent quest not found!");
            }
            case REWARD_TABLE: {
                return new RewardTable(id, this);
            }
            case CHAPTER_GROUP: {
                return new ChapterGroup(id, this);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    @Override
    public final void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10556("default_reward_team", this.defaultPerTeamReward);
        nbt.method_10556("default_consume_items", this.defaultTeamConsumeItems);
        nbt.method_10582("default_autoclaim_rewards", this.defaultRewardAutoClaim.id);
        nbt.method_10582("default_quest_shape", this.defaultQuestShape);
        nbt.method_10556("default_quest_disable_jei", this.defaultQuestDisableJEI);
        if (!this.emergencyItems.isEmpty()) {
            class_2499 list = new class_2499();
            for (class_1799 stack : this.emergencyItems) {
                list.add((Object)MissingItem.writeItem(stack));
            }
            nbt.method_10566("emergency_items", (class_2520)list);
        }
        nbt.method_10569("emergency_items_cooldown", this.emergencyItemsCooldown);
        nbt.method_10556("drop_loot_crates", this.dropLootCrates);
        SNBTCompoundTag lootCrateNoDropTag = new SNBTCompoundTag();
        this.lootCrateNoDrop.writeData((class_2487)lootCrateNoDropTag);
        nbt.method_10566("loot_crate_no_drop", (class_2520)lootCrateNoDropTag);
        nbt.method_10556("disable_gui", this.disableGui);
        nbt.method_10549("grid_scale", this.gridScale);
        nbt.method_10556("pause_game", this.pauseGame);
        nbt.method_10582("lock_message", this.lockMessage);
        nbt.method_10582("progression_mode", this.progressionMode.getId());
        nbt.method_10569("detection_delay", this.detectionDelay);
    }

    @Override
    public final void readData(class_2487 nbt) {
        super.readData(nbt);
        this.defaultPerTeamReward = nbt.method_10577("default_reward_team");
        this.defaultTeamConsumeItems = nbt.method_10577("default_consume_items");
        this.defaultRewardAutoClaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP_NO_DEFAULT.get(nbt.method_10558("default_autoclaim_rewards")));
        this.defaultQuestShape = nbt.method_10558("default_quest_shape");
        if (this.defaultQuestShape.equals("default")) {
            this.defaultQuestShape = "";
        }
        this.defaultQuestDisableJEI = nbt.method_10577("default_quest_disable_jei");
        this.emergencyItems.clear();
        class_2499 emergencyItemsTag = nbt.method_10554("emergency_items", 10);
        for (int i = 0; i < emergencyItemsTag.size(); ++i) {
            class_1799 stack = MissingItem.readItem(emergencyItemsTag.method_10602(i));
            if (stack.method_7960()) continue;
            this.emergencyItems.add(stack);
        }
        this.emergencyItemsCooldown = nbt.method_10550("emergency_items_cooldown");
        this.dropLootCrates = nbt.method_10577("drop_loot_crates");
        if (nbt.method_10545("loot_crate_no_drop")) {
            this.lootCrateNoDrop.readData(nbt.method_10562("loot_crate_no_drop"));
        }
        this.disableGui = nbt.method_10577("disable_gui");
        this.gridScale = nbt.method_10545("grid_scale") ? nbt.method_10574("grid_scale") : 0.5;
        this.pauseGame = nbt.method_10577("pause_game");
        this.lockMessage = nbt.method_10558("lock_message");
        this.progressionMode = (ProgressionMode)((Object)ProgressionMode.NAME_MAP_NO_DEFAULT.get(nbt.method_10558("progression_mode")));
        if (nbt.method_10545("detection_delay")) {
            this.detectionDelay = nbt.method_10550("detection_delay");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeDataFull(Path folder) {
        boolean prev = false;
        try {
            prev = SNBT.setShouldSortKeysOnWrite((boolean)true);
            SNBTCompoundTag fileNBT = new SNBTCompoundTag();
            fileNBT.method_10569("version", VERSION);
            this.writeData((class_2487)fileNBT);
            SNBT.write((Path)folder.resolve("data.snbt"), (class_2487)fileNBT);
            for (ChapterGroup group : this.chapterGroups) {
                for (int ci = 0; ci < group.getChapters().size(); ++ci) {
                    Chapter chapter = group.getChapters().get(ci);
                    SNBTCompoundTag chapterNBT = new SNBTCompoundTag();
                    chapterNBT.method_10582("id", chapter.getCodeString());
                    chapterNBT.method_10582("group", group.isDefaultGroup() ? "" : group.getCodeString());
                    chapterNBT.method_10569("order_index", ci);
                    chapter.writeData((class_2487)chapterNBT);
                    class_2499 questList = new class_2499();
                    for (Quest quest : chapter.getQuests()) {
                        if (!quest.isValid()) continue;
                        SNBTCompoundTag questNBT = new SNBTCompoundTag();
                        quest.writeData((class_2487)questNBT);
                        questNBT.method_10582("id", quest.getCodeString());
                        if (!quest.getTasks().isEmpty()) {
                            quest.writeTasks((class_2487)questNBT);
                        }
                        if (!quest.getRewards().isEmpty()) {
                            quest.writeRewards((class_2487)questNBT);
                        }
                        questList.add((Object)questNBT);
                    }
                    chapterNBT.method_10566("quests", (class_2520)questList);
                    class_2499 linkList = new class_2499();
                    for (QuestLink link : chapter.getQuestLinks()) {
                        if (!link.getQuest().isPresent()) continue;
                        SNBTCompoundTag linkNBT = new SNBTCompoundTag();
                        link.writeData((class_2487)linkNBT);
                        linkNBT.method_10582("id", link.getCodeString());
                        linkList.add((Object)linkNBT);
                    }
                    chapterNBT.method_10566("quest_links", (class_2520)linkList);
                    SNBT.write((Path)folder.resolve("chapters/" + chapter.getFilename() + ".snbt"), (class_2487)chapterNBT);
                }
            }
            for (int ri = 0; ri < this.rewardTables.size(); ++ri) {
                RewardTable table = this.rewardTables.get(ri);
                SNBTCompoundTag tableNBT = new SNBTCompoundTag();
                tableNBT.method_10582("id", table.getCodeString());
                tableNBT.method_10569("order_index", ri);
                table.writeData((class_2487)tableNBT);
                SNBT.write((Path)folder.resolve("reward_tables/" + table.getFilename() + ".snbt"), (class_2487)tableNBT);
            }
            class_2499 chapterGroupTag = new class_2499();
            for (ChapterGroup group : this.chapterGroups) {
                if (group.isDefaultGroup()) continue;
                SNBTCompoundTag groupTag = new SNBTCompoundTag();
                groupTag.singleLine();
                groupTag.method_10582("id", group.getCodeString());
                group.writeData((class_2487)groupTag);
                chapterGroupTag.add((Object)groupTag);
            }
            SNBTCompoundTag groupNBT = new SNBTCompoundTag();
            groupNBT.method_10566("chapter_groups", (class_2520)chapterGroupTag);
            SNBT.write((Path)folder.resolve("chapter_groups.snbt"), (class_2487)groupNBT);
        }
        finally {
            SNBT.setShouldSortKeysOnWrite((boolean)prev);
        }
    }

    public final void readDataFull(Path folder) {
        Path rewardTableFolder;
        SNBTCompoundTag chapterGroupsTag;
        Path groupsFile;
        this.clearCachedData();
        this.questObjectMap.clear();
        this.defaultChapterGroup.clearChapters();
        this.chapterGroups.clear();
        this.chapterGroups.add(this.defaultChapterGroup);
        this.rewardTables.clear();
        MutableInt chapterCounter = new MutableInt();
        MutableInt questCounter = new MutableInt();
        Long2ObjectOpenHashMap dataCache = new Long2ObjectOpenHashMap();
        SNBTCompoundTag fileNBT = SNBT.read((Path)folder.resolve("data.snbt"));
        if (fileNBT != null) {
            this.fileVersion = fileNBT.method_10550("version");
            this.questObjectMap.put(1L, (Object)this);
            this.readData((class_2487)fileNBT);
        }
        if (Files.exists(groupsFile = folder.resolve("chapter_groups.snbt"), new LinkOption[0]) && (chapterGroupsTag = SNBT.read((Path)groupsFile)) != null) {
            class_2499 groupListTag = chapterGroupsTag.method_10554("chapter_groups", 10);
            for (int i = 0; i < groupListTag.size(); ++i) {
                class_2487 groupNBT = groupListTag.method_10602(i);
                ChapterGroup chapterGroup = new ChapterGroup(this.readID(groupNBT.method_10580("id")), this);
                this.questObjectMap.put(chapterGroup.id, (Object)chapterGroup);
                dataCache.put(chapterGroup.id, (Object)groupNBT);
                this.chapterGroups.add(chapterGroup);
            }
        }
        Path chaptersFolder = folder.resolve("chapters");
        Long2IntOpenHashMap objectOrderMap = new Long2IntOpenHashMap();
        objectOrderMap.defaultReturnValue(-1);
        if (Files.exists(chaptersFolder, new LinkOption[0])) {
            try (Stream<Path> s = Files.list(chaptersFolder);){
                s.filter(path -> path.toString().endsWith(".snbt")).forEach(path -> {
                    SNBTCompoundTag chapterNBT = SNBT.read((Path)path);
                    if (chapterNBT != null) {
                        Chapter chapter = new Chapter(this.readID(chapterNBT.method_10580("id")), this, this.getChapterGroup(this.getID(chapterNBT.method_10580("group"))), path.getFileName().toString().replace(".snbt", ""));
                        objectOrderMap.put(chapter.id, chapterNBT.method_10550("order_index"));
                        this.questObjectMap.put(chapter.id, (Object)chapter);
                        dataCache.put(chapter.id, (Object)chapterNBT);
                        chapter.getGroup().addChapter(chapter);
                        class_2499 questList = chapterNBT.method_10554("quests", 10);
                        for (int i = 0; i < questList.size(); ++i) {
                            class_2487 questNBT = questList.method_10602(i);
                            Quest quest = new Quest(this.readID(questNBT.method_10580("id")), chapter);
                            this.questObjectMap.put(quest.id, (Object)quest);
                            dataCache.put(quest.id, (Object)questNBT);
                            chapter.addQuest(quest);
                            class_2499 taskList = questNBT.method_10554("tasks", 10);
                            for (int j = 0; j < taskList.size(); ++j) {
                                class_2487 taskNBT = taskList.method_10602(j);
                                long taskId = this.readID(taskNBT.method_10580("id"));
                                Task task = TaskType.createTask(taskId, quest, taskNBT.method_10558("type"));
                                if (task == null) {
                                    task = new CustomTask(taskId, quest);
                                    task.rawTitle = "Unknown type: " + taskNBT.method_10558("type");
                                }
                                this.questObjectMap.put(task.id, (Object)task);
                                dataCache.put(task.id, (Object)taskNBT);
                                quest.addTask(task);
                            }
                            class_2499 rewardList = questNBT.method_10554("rewards", 10);
                            for (int j = 0; j < rewardList.size(); ++j) {
                                class_2487 rewardNBT = rewardList.method_10602(j);
                                long rewardId = this.readID(rewardNBT.method_10580("id"));
                                Reward reward = RewardType.createReward(rewardId, quest, rewardNBT.method_10558("type"));
                                if (reward == null) {
                                    reward = new CustomReward(rewardId, quest);
                                    reward.rawTitle = "Unknown type: " + rewardNBT.method_10558("type");
                                }
                                this.questObjectMap.put(reward.id, (Object)reward);
                                dataCache.put(reward.id, (Object)rewardNBT);
                                quest.addReward(reward);
                            }
                            questCounter.increment();
                        }
                        class_2499 questLinks = chapterNBT.method_10554("quest_links", 10);
                        for (int i = 0; i < questLinks.size(); ++i) {
                            class_2487 linkNBT = questLinks.method_10602(i);
                            QuestLink link = new QuestLink(this.readID(linkNBT.method_10580("id")), chapter, this.readID(linkNBT.method_10580("linked_quest")));
                            chapter.addQuestLink(link);
                            this.questObjectMap.put(link.id, (Object)link);
                            dataCache.put(link.id, (Object)linkNBT);
                        }
                        chapterCounter.increment();
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (Files.exists(rewardTableFolder = folder.resolve("reward_tables"), new LinkOption[0])) {
            try (Stream<Path> s = Files.list(rewardTableFolder);){
                s.filter(path -> path.toString().endsWith(".snbt")).forEach(path -> {
                    SNBTCompoundTag tableNBT = SNBT.read((Path)path);
                    if (tableNBT != null) {
                        String filename = path.getFileName().toString().replace(".snbt", "");
                        RewardTable table = new RewardTable(this.readID(tableNBT.method_10580("id")), this, filename);
                        objectOrderMap.put(table.id, tableNBT.method_10550("order_index"));
                        this.questObjectMap.put(table.id, (Object)table);
                        dataCache.put(table.id, (Object)tableNBT);
                        this.rewardTables.add(table);
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (QuestObjectBase object : this.questObjectMap.values()) {
            class_2487 data = (class_2487)dataCache.get(object.id);
            if (data == null) continue;
            object.readData(data);
        }
        for (ChapterGroup group : this.chapterGroups) {
            group.sortChapters(Comparator.comparingInt(c -> objectOrderMap.get(c.id)));
            for (Chapter chapter : group.getChapters()) {
                for (Quest quest : chapter.getQuests()) {
                    quest.removeInvalidDependencies();
                }
            }
        }
        this.rewardTables.sort(Comparator.comparingInt(c -> objectOrderMap.get(c.id)));
        this.updateLootCrates();
        for (QuestObjectBase object : this.getAllObjects()) {
            if (!(object instanceof CustomTask)) continue;
            ((EventActor)CustomTaskEvent.EVENT.invoker()).act((Object)new CustomTaskEvent((CustomTask)object));
        }
        if (this.fileVersion != VERSION) {
            this.markDirty();
        }
        FTBQuests.LOGGER.info("Loaded " + this.chapterGroups.size() + " chapter groups, " + chapterCounter + " chapters, " + questCounter + " quests, " + this.rewardTables.size() + " reward tables");
    }

    public void updateLootCrates() {
        HashSet<String> prevCrateNames = new HashSet<String>(LootCrate.LOOT_CRATES.keySet());
        Collection<class_1799> oldStacks = LootCrate.allCrateStacks();
        LootCrate.LOOT_CRATES.clear();
        for (RewardTable table : this.rewardTables) {
            if (table.getLootCrate() == null) continue;
            LootCrate.LOOT_CRATES.put(table.getLootCrate().getStringID(), table.getLootCrate());
        }
        if (!this.isServerSide() && !prevCrateNames.equals(LootCrate.LOOT_CRATES.keySet())) {
            FTBQuestsClient.rebuildCreativeTabs();
            FTBQuests.getRecipeModHelper().updateItemsDynamic(oldStacks, LootCrate.allCrateStacks());
        }
        FTBQuests.LOGGER.debug("Updated loot crates (was {}, now {})", (Object)prevCrateNames.size(), (Object)LootCrate.LOOT_CRATES.size());
    }

    public void markDirty() {
    }

    @Override
    public final void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        NetUtils.write(buffer, this.emergencyItems, FTBQuestsNetHandler::writeItemType);
        buffer.method_10804(this.emergencyItemsCooldown);
        buffer.writeBoolean(this.defaultPerTeamReward);
        buffer.writeBoolean(this.defaultTeamConsumeItems);
        RewardAutoClaim.NAME_MAP_NO_DEFAULT.write(buffer, (Object)this.defaultRewardAutoClaim);
        buffer.method_10788(this.defaultQuestShape, Short.MAX_VALUE);
        buffer.writeBoolean(this.defaultQuestDisableJEI);
        buffer.writeBoolean(this.dropLootCrates);
        this.lootCrateNoDrop.writeNetData(buffer);
        buffer.writeBoolean(this.disableGui);
        buffer.writeDouble(this.gridScale);
        buffer.writeBoolean(this.pauseGame);
        buffer.method_10788(this.lockMessage, Short.MAX_VALUE);
        ProgressionMode.NAME_MAP_NO_DEFAULT.write(buffer, (Object)this.progressionMode);
        buffer.method_10804(this.detectionDelay);
    }

    @Override
    public final void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        NetUtils.read(buffer, this.emergencyItems, FTBQuestsNetHandler::readItemType);
        this.emergencyItemsCooldown = buffer.method_10816();
        this.defaultPerTeamReward = buffer.readBoolean();
        this.defaultTeamConsumeItems = buffer.readBoolean();
        this.defaultRewardAutoClaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP_NO_DEFAULT.read(buffer));
        this.defaultQuestShape = buffer.method_10800(Short.MAX_VALUE);
        this.defaultQuestDisableJEI = buffer.readBoolean();
        this.dropLootCrates = buffer.readBoolean();
        this.lootCrateNoDrop.readNetData(buffer);
        this.disableGui = buffer.readBoolean();
        this.gridScale = buffer.readDouble();
        this.pauseGame = buffer.readBoolean();
        this.lockMessage = buffer.method_10800(Short.MAX_VALUE);
        this.progressionMode = (ProgressionMode)((Object)ProgressionMode.NAME_MAP_NO_DEFAULT.read(buffer));
        this.detectionDelay = buffer.method_10816();
    }

    public final void writeNetDataFull(class_2540 buffer) {
        int pos = buffer.writerIndex();
        buffer.method_10804(TaskTypes.TYPES.size());
        for (TaskType taskType : TaskTypes.TYPES.values()) {
            buffer.method_10812(taskType.getTypeId());
            buffer.method_10804(taskType.internalId);
        }
        buffer.method_10804(RewardTypes.TYPES.size());
        for (RewardType rewardType : RewardTypes.TYPES.values()) {
            buffer.method_10812(rewardType.getTypeId());
            buffer.method_10804(rewardType.intId);
        }
        this.writeNetData(buffer);
        buffer.method_10804(this.rewardTables.size());
        for (RewardTable rewardTable : this.rewardTables) {
            buffer.writeLong(rewardTable.id);
        }
        buffer.method_10804(this.chapterGroups.size() - 1);
        for (ChapterGroup chapterGroup : this.chapterGroups) {
            if (chapterGroup.isDefaultGroup()) continue;
            buffer.writeLong(chapterGroup.id);
        }
        for (ChapterGroup chapterGroup : this.chapterGroups) {
            buffer.method_10804(chapterGroup.getChapters().size());
            for (Chapter chapter : chapterGroup.getChapters()) {
                buffer.writeLong(chapter.id);
                buffer.method_10804(chapter.getQuests().size());
                for (Quest quest2 : chapter.getQuests()) {
                    buffer.writeLong(quest2.id);
                    buffer.method_10804(quest2.getTasks().size());
                    quest2.getTasks().forEach(task -> {
                        buffer.method_10804(task.getType().internalId);
                        buffer.writeLong(task.id);
                    });
                    buffer.method_10804(quest2.getRewards().size());
                    quest2.getRewards().forEach(reward -> {
                        buffer.method_10804(reward.getType().intId);
                        buffer.writeLong(reward.id);
                    });
                }
                buffer.method_10804(chapter.getQuestLinks().size());
                for (QuestLink questLink2 : chapter.getQuestLinks()) {
                    buffer.writeLong(questLink2.id);
                }
            }
        }
        for (RewardTable rewardTable : this.rewardTables) {
            rewardTable.writeNetData(buffer);
        }
        for (ChapterGroup chapterGroup : this.chapterGroups) {
            if (chapterGroup.isDefaultGroup()) continue;
            chapterGroup.writeNetData(buffer);
        }
        for (ChapterGroup chapterGroup : this.chapterGroups) {
            for (Chapter chapter : chapterGroup.getChapters()) {
                chapter.writeNetData(buffer);
                chapter.getQuests().forEach(quest -> {
                    quest.writeNetData(buffer);
                    quest.getTasks().forEach(task -> task.writeNetData(buffer));
                    quest.getRewards().forEach(reward -> reward.writeNetData(buffer));
                });
                chapter.getQuestLinks().forEach(questLink -> questLink.writeNetData(buffer));
            }
        }
        FTBQuests.LOGGER.debug("Wrote " + (buffer.writerIndex() - pos) + " bytes, " + this.questObjectMap.size() + " objects");
    }

    /*
     * WARNING - void declaration
     */
    public final void readNetDataFull(class_2540 buffer) {
        void var4_9;
        int pos = buffer.readerIndex();
        this.taskTypeIds.clear();
        this.rewardTypeIds.clear();
        for (TaskType taskType : TaskTypes.TYPES.values()) {
            taskType.internalId = 0;
        }
        for (RewardType rewardType : RewardTypes.TYPES.values()) {
            rewardType.intId = 0;
        }
        int taskTypesSize = buffer.method_10816();
        boolean bl = false;
        while (var4_9 < taskTypesSize) {
            TaskType type = TaskTypes.TYPES.get(buffer.method_10810());
            int id = buffer.method_10816();
            if (type != null) {
                type.internalId = id;
                this.taskTypeIds.put(type.internalId, (Object)type);
            }
            ++var4_9;
        }
        int n = buffer.method_10816();
        for (int i = 0; i < n; ++i) {
            RewardType type = RewardTypes.TYPES.get(buffer.method_10810());
            int id = buffer.method_10816();
            if (type == null) continue;
            type.intId = id;
            this.rewardTypeIds.put(type.intId, (Object)type);
        }
        this.readNetData(buffer);
        this.rewardTables.clear();
        int rewardTableSize = buffer.method_10816();
        for (int i = 0; i < rewardTableSize; ++i) {
            RewardTable table = new RewardTable(buffer.readLong(), this);
            this.rewardTables.add(table);
        }
        this.chapterGroups.clear();
        this.chapterGroups.add(this.defaultChapterGroup);
        int chapterGroupsSize = buffer.method_10816();
        for (int i = 0; i < chapterGroupsSize; ++i) {
            ChapterGroup group = new ChapterGroup(buffer.readLong(), this);
            this.chapterGroups.add(group);
        }
        for (ChapterGroup group : this.chapterGroups) {
            int chapterCount = buffer.method_10816();
            for (int i = 0; i < chapterCount; ++i) {
                Chapter chapter = new Chapter(buffer.readLong(), this, group);
                group.addChapter(chapter);
                int questCount = buffer.method_10816();
                for (int j = 0; j < questCount; ++j) {
                    Quest quest = new Quest(buffer.readLong(), chapter);
                    chapter.addQuest(quest);
                    int taskCount = buffer.method_10816();
                    for (int k = 0; k < taskCount; ++k) {
                        TaskType type = (TaskType)this.taskTypeIds.get(buffer.method_10816());
                        quest.addTask(type.createTask(buffer.readLong(), quest));
                    }
                    int rewardCount = buffer.method_10816();
                    for (int k = 0; k < rewardCount; ++k) {
                        RewardType type = (RewardType)this.rewardTypeIds.get(buffer.method_10816());
                        quest.addReward(type.createReward(buffer.readLong(), quest));
                    }
                }
                int questLinkCount = buffer.method_10816();
                for (int j = 0; j < questLinkCount; ++j) {
                    QuestLink questLink = new QuestLink(buffer.readLong(), chapter, 0L);
                    chapter.addQuestLink(questLink);
                }
            }
        }
        this.refreshIDMap();
        for (RewardTable table : this.rewardTables) {
            table.readNetData(buffer);
        }
        for (ChapterGroup group : this.chapterGroups) {
            if (group.isDefaultGroup()) continue;
            group.readNetData(buffer);
        }
        for (ChapterGroup group : this.chapterGroups) {
            for (Chapter chapter : group.getChapters()) {
                chapter.readNetData(buffer);
                for (Quest quest : chapter.getQuests()) {
                    quest.readNetData(buffer);
                    quest.getTasks().forEach(task -> task.readNetData(buffer));
                    quest.getRewards().forEach(reward -> reward.readNetData(buffer));
                }
                for (QuestLink questLink : chapter.getQuestLinks()) {
                    questLink.readNetData(buffer);
                }
            }
        }
        FTBQuests.LOGGER.info("Read " + (buffer.readerIndex() - pos) + " bytes, " + this.questObjectMap.size() + " objects");
    }

    @Override
    public long getParentID() {
        return 0L;
    }

    @Override
    @Nullable
    public TeamData getNullableTeamData(UUID id) {
        return this.teamDataMap.get(id);
    }

    @Override
    public TeamData getOrCreateTeamData(UUID teamId) {
        return this.teamDataMap.computeIfAbsent(teamId, k -> new TeamData(teamId, this));
    }

    @Override
    public TeamData getOrCreateTeamData(Team team) {
        return this.getOrCreateTeamData(Objects.requireNonNull(team, "Non-null team required!").getId());
    }

    @Override
    public TeamData getOrCreateTeamData(class_1297 player) {
        return FTBTeamsAPI.api().getManager().getTeamForPlayerID(player.method_5667()).map(this::getOrCreateTeamData).orElse(null);
    }

    @Override
    public Collection<TeamData> getAllTeamData() {
        return Collections.unmodifiableCollection(this.teamDataMap.values());
    }

    public abstract void deleteObject(long var1);

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return class_2561.method_43471((String)"ftbquests.file");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        return (Icon)ThemeProperties.MODPACK_ICON.get(this);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addList("emergency_items", this.emergencyItems, (ConfigValue)new ItemStackConfig(false, false), (Object)class_1799.field_8037);
        config.addInt("emergency_items_cooldown", this.emergencyItemsCooldown, v -> {
            this.emergencyItemsCooldown = v;
        }, 300, 0, Integer.MAX_VALUE);
        config.addBool("drop_loot_crates", this.dropLootCrates, v -> {
            this.dropLootCrates = v;
        }, false);
        config.addBool("disable_gui", this.disableGui, v -> {
            this.disableGui = v;
        }, false);
        config.addDouble("grid_scale", this.gridScale, v -> {
            this.gridScale = v;
        }, 0.5, 0.03125, 8.0);
        config.addString("lock_message", this.lockMessage, v -> {
            this.lockMessage = v;
        }, "");
        config.addEnum("progression_mode", (Object)this.progressionMode, v -> {
            this.progressionMode = v;
        }, ProgressionMode.NAME_MAP_NO_DEFAULT);
        config.addInt("detection_delay", this.detectionDelay, v -> {
            this.detectionDelay = v;
        }, 20, 0, 200);
        config.addBool("pause_game", this.pauseGame, v -> {
            this.pauseGame = v;
        }, false);
        ConfigGroup defaultsGroup = config.getOrCreateSubgroup("defaults");
        defaultsGroup.addBool("reward_team", this.defaultPerTeamReward, v -> {
            this.defaultPerTeamReward = v;
        }, false);
        defaultsGroup.addBool("consume_items", this.defaultTeamConsumeItems, v -> {
            this.defaultTeamConsumeItems = v;
        }, false);
        defaultsGroup.addEnum("autoclaim_rewards", (Object)this.defaultRewardAutoClaim, v -> {
            this.defaultRewardAutoClaim = v;
        }, RewardAutoClaim.NAME_MAP_NO_DEFAULT);
        defaultsGroup.addEnum("quest_shape", (Object)this.defaultQuestShape, v -> {
            this.defaultQuestShape = v;
        }, QuestShape.idMap);
        defaultsGroup.addBool("quest_disable_jei", this.defaultQuestDisableJEI, v -> {
            this.defaultQuestDisableJEI = v;
        }, false);
        ConfigGroup d = config.getOrCreateSubgroup("loot_crate_no_drop");
        d.addInt("passive", this.lootCrateNoDrop.passive, v -> {
            this.lootCrateNoDrop.passive = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.loot.entitytype.passive");
        d.addInt("monster", this.lootCrateNoDrop.monster, v -> {
            this.lootCrateNoDrop.monster = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.loot.entitytype.monster");
        d.addInt("boss", this.lootCrateNoDrop.boss, v -> {
            this.lootCrateNoDrop.boss = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.loot.entitytype.boss");
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.allTasks = null;
        this.submitTasks = null;
        this.craftingTasks = null;
        for (ChapterGroup group : this.chapterGroups) {
            group.clearCachedData();
        }
        this.clearCachedProgress();
        ((Consumer)ClearFileCacheEvent.EVENT.invoker()).accept(this);
    }

    public void clearCachedProgress() {
        this.getAllTeamData().forEach(TeamData::clearCachedProgress);
    }

    public long newID() {
        return this.readID(0L);
    }

    public long readID(long id) {
        while (id == 0L || id == 1L || this.questObjectMap.get(id) != null) {
            id = Math.abs(MathUtils.RAND.nextLong());
            this.markDirty();
        }
        return id;
    }

    public long readID(@Nullable class_2520 tag) {
        if (tag instanceof class_2514) {
            this.markDirty();
            return this.readID(((class_2514)tag).method_10699());
        }
        if (tag instanceof class_2519) {
            try {
                String id = tag.method_10714();
                return this.readID(Long.parseLong(id.charAt(0) == '#' ? id.substring(1) : id, 16));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.newID();
    }

    public long getID(@Nullable Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Number) {
            Number n = (Number)obj;
            return n.longValue();
        }
        if (obj instanceof class_2514) {
            class_2514 nt = (class_2514)obj;
            return nt.method_10699();
        }
        if (obj instanceof class_2519) {
            class_2519 st = (class_2519)obj;
            return this.getID(st.method_10714());
        }
        String idStr = obj.toString();
        long id = BaseQuestFile.parseCodeString(idStr);
        if (id == 0L && idStr.length() >= 2 && idStr.charAt(0) == '#') {
            String tagVal = idStr.substring(1);
            return this.questObjectMap.values().stream().filter(qob -> qob.hasTag(tagVal)).findFirst().map(qob -> qob.id).orElse(id);
        }
        return id;
    }

    public Optional<LootCrate> makeRandomLootCrate(class_1297 entity, class_5819 random) {
        int totalWeight = this.lootCrateNoDrop.getWeight(entity);
        for (RewardTable table : this.rewardTables) {
            if (table.getLootCrate() == null) continue;
            totalWeight += table.getLootCrate().getDrops().getWeight(entity);
        }
        if (totalWeight <= 0) {
            return Optional.empty();
        }
        int number = random.method_43048(totalWeight) + 1;
        int currentWeight = this.lootCrateNoDrop.getWeight(entity);
        if (currentWeight < number) {
            for (RewardTable table : this.rewardTables) {
                if (table.getLootCrate() == null || (currentWeight += table.getLootCrate().getDrops().getWeight(entity)) < number) continue;
                return Optional.ofNullable(table.getLootCrate());
            }
        }
        return Optional.empty();
    }

    @Override
    public Set<RecipeModHelper.Components> componentsToRefresh() {
        return EnumSet.allOf(RecipeModHelper.Components.class);
    }

    public final Collection<QuestObjectBase> getAllObjects() {
        return Collections.unmodifiableCollection(this.questObjectMap.values());
    }

    @Override
    public boolean isVisible(TeamData data) {
        return this.chapterGroups.stream().anyMatch(group -> group.isVisible(data));
    }

    public List<Chapter> getAllChapters() {
        ArrayList<Chapter> list = new ArrayList<Chapter>();
        for (ChapterGroup g : this.chapterGroups) {
            list.addAll(g.getChapters());
        }
        return list;
    }

    public List<Task> getAllTasks() {
        if (this.allTasks == null) {
            this.allTasks = new ArrayList<Task>();
            this.forAllQuests(q -> this.allTasks.addAll(q.getTasks()));
        }
        return this.allTasks;
    }

    public List<Task> getSubmitTasks() {
        if (this.submitTasks == null) {
            this.submitTasks = this.getAllTasks().stream().filter(Task::submitItemsOnInventoryChange).toList();
        }
        return this.submitTasks;
    }

    public List<Task> getCraftingTasks() {
        if (this.craftingTasks == null) {
            this.craftingTasks = this.getAllTasks().stream().filter(task -> {
                ItemTask i;
                return task instanceof ItemTask && (i = (ItemTask)task).isOnlyFromCrafting();
            }).toList();
        }
        return this.craftingTasks;
    }

    public List<Chapter> getVisibleChapters(TeamData data) {
        ArrayList<Chapter> list = new ArrayList<Chapter>();
        for (ChapterGroup group : this.chapterGroups) {
            list.addAll(group.getVisibleChapters(data));
        }
        return list;
    }

    @Nullable
    public Chapter getFirstVisibleChapter(TeamData data) {
        for (ChapterGroup group : this.chapterGroups) {
            Chapter c = group.getFirstVisibleChapter(data);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public <T extends QuestObjectBase> List<T> collect(Predicate<QuestObjectBase> filter) {
        ArrayList<QuestObjectBase> list = new ArrayList<QuestObjectBase>();
        for (QuestObjectBase base : this.getAllObjects()) {
            if (!filter.test(base)) continue;
            list.add(base);
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList((QuestObjectBase)list.get(0));
        }
        return list;
    }

    public <T extends QuestObjectBase> List<T> collect(Class<T> clazz) {
        return this.collect((QuestObjectBase o) -> clazz.isAssignableFrom(o.getClass()));
    }

    public String getDefaultQuestShape() {
        return this.defaultQuestShape;
    }

    public void addData(TeamData data, boolean override) {
        if (override || !this.teamDataMap.containsKey(data.getTeamId())) {
            this.teamDataMap.put(data.getTeamId(), data);
        }
    }

    public void refreshGui() {
        this.clearCachedData();
    }

    @Override
    public Collection<? extends QuestObject> getChildren() {
        return this.chapterGroups;
    }

    @Override
    public boolean hasUnclaimedRewardsRaw(TeamData teamData, UUID player) {
        for (ChapterGroup group : this.chapterGroups) {
            if (!teamData.hasUnclaimedRewards(player, group)) continue;
            return true;
        }
        return false;
    }

    public ProgressionMode getProgressionMode() {
        return this.progressionMode;
    }

    public int getDetectionDelay() {
        return this.detectionDelay;
    }

    public boolean isPauseGame() {
        return this.pauseGame;
    }

    public boolean isDisableGui() {
        return this.disableGui;
    }

    public double getGridScale() {
        return this.gridScale;
    }

    public boolean isDropLootCrates() {
        return this.dropLootCrates;
    }

    public boolean isDefaultPerTeamReward() {
        return this.defaultPerTeamReward;
    }

    public boolean isDefaultTeamConsumeItems() {
        return this.defaultTeamConsumeItems;
    }

    public RewardAutoClaim getDefaultRewardAutoClaim() {
        return this.defaultRewardAutoClaim;
    }

    public List<class_1799> getEmergencyItems() {
        return Collections.unmodifiableList(this.emergencyItems);
    }

    public int getEmergencyItemsCooldown() {
        return this.emergencyItemsCooldown;
    }

    public boolean isDefaultQuestDisableJEI() {
        return this.defaultQuestDisableJEI;
    }

    public abstract boolean isPlayerOnTeam(class_1657 var1, TeamData var2);

    public TaskType getTaskType(int typeId) {
        return (TaskType)this.taskTypeIds.get(typeId);
    }

    public RewardType getRewardType(int typeId) {
        return (RewardType)this.rewardTypeIds.get(typeId);
    }

    public DefaultChapterGroup getDefaultChapterGroup() {
        return this.defaultChapterGroup;
    }

    public List<RewardTable> getRewardTables() {
        return Collections.unmodifiableList(this.rewardTables);
    }

    public void addRewardTable(RewardTable rewardTable) {
        this.rewardTables.add(rewardTable);
    }

    public void removeRewardTable(RewardTable rewardTable) {
        this.rewardTables.remove(rewardTable);
    }

    public int removeEmptyRewardTables(class_2168 source) {
        MutableInt del = new MutableInt(0);
        for (RewardTable table : this.rewardTables) {
            if (!table.getWeightedRewards().isEmpty()) continue;
            del.increment();
            table.invalid = true;
            FileUtils.delete(ServerQuestFile.INSTANCE.getFolder().resolve(table.getPath().orElseThrow()).toFile());
            new DeleteObjectResponseMessage(table.id).sendToAll(source.method_9211());
        }
        if (this.rewardTables.removeIf(rewardTable -> rewardTable.invalid)) {
            this.refreshIDMap();
            this.markDirty();
        }
        return del.intValue();
    }

    public String generateRewardTableName(String basename) {
        String s = BaseQuestFile.titleToID(basename).orElse(this.toString());
        Object filename = s;
        Set existingNames = this.rewardTables.stream().map(RewardTable::getFilename).collect(Collectors.toSet());
        int i = 2;
        while (existingNames.contains(filename)) {
            filename = s + "_" + i;
            ++i;
        }
        return filename;
    }

    public void forAllChapterGroups(Consumer<ChapterGroup> consumer) {
        this.chapterGroups.forEach(consumer);
    }

    @Override
    public void forAllChapters(Consumer<Chapter> consumer) {
        this.forAllChapterGroups(g -> g.getChapters().forEach(consumer));
    }

    @Override
    public void forAllQuests(Consumer<Quest> consumer) {
        this.forAllChapters(c -> c.getQuests().forEach(consumer));
    }

    @Override
    public void forAllQuestLinks(Consumer<QuestLink> consumer) {
        this.forAllChapters(c -> c.getQuestLinks().forEach(consumer));
    }

    public boolean moveChapterGroup(long id, boolean movingUp) {
        int index;
        ChapterGroup group = this.getChapterGroup(id);
        if (!group.isDefaultGroup() && ((index = this.chapterGroups.indexOf(group)) != -1 && movingUp ? index > 1 : index < this.chapterGroups.size() - 1)) {
            this.chapterGroups.remove(index);
            this.chapterGroups.add(movingUp ? index - 1 : index + 1, group);
            return true;
        }
        return false;
    }

    public EntityWeight getLootCrateNoDrop() {
        return this.lootCrateNoDrop;
    }
}

