/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.config.IntConfig;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.config.ui.SelectItemStackScreen;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.FTBQuestsCommon;
import dev.ftb.mods.ftbquests.block.FTBQuestsBlocks;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientEventHandler;
import dev.ftb.mods.ftbquests.client.QuestFileCacheReloader;
import dev.ftb.mods.ftbquests.net.SetCustomImageMessage;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.reward.XPLevelsReward;
import dev.ftb.mods.ftbquests.quest.reward.XPReward;
import dev.ftb.mods.ftbquests.quest.task.CheckmarkTask;
import dev.ftb.mods.ftbquests.quest.task.DimensionTask;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.LocationTask;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.quest.theme.ThemeLoader;
import me.shedaniel.architectury.event.events.client.ClientLifecycleEvent;
import me.shedaniel.architectury.registry.KeyBindings;
import me.shedaniel.architectury.registry.ReloadListeners;
import me.shedaniel.architectury.registry.RenderTypes;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsClient
extends FTBQuestsCommon {
    public static KeyBinding KEY_QUESTS;

    @Override
    public void init() {
        ClientLifecycleEvent.CLIENT_SETUP.register(this::setup);
        ReloadListeners.registerReloadListener((ResourcePackType)ResourcePackType.CLIENT_RESOURCES, (IFutureReloadListener)new QuestFileCacheReloader());
        ReloadListeners.registerReloadListener((ResourcePackType)ResourcePackType.CLIENT_RESOURCES, (IFutureReloadListener)new ThemeLoader());
        new FTBQuestsClientEventHandler().init();
    }

    private void setup(Minecraft minecraft) {
        KEY_QUESTS = new KeyBinding("key.ftbquests.quests", InputMappings.Type.KEYSYM, -1, "key.categories.ftbquests");
        KeyBindings.registerKeyBinding((KeyBinding)KEY_QUESTS);
        RenderTypes.register((RenderType)RenderType.func_228645_f_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.BARRIER.get()});
        RenderTypes.register((RenderType)RenderType.func_228645_f_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.STAGE_BARRIER.get()});
        this.setTaskGuiProviders();
        this.setRewardGuiProviders();
    }

    @Override
    @Nullable
    public QuestFile getClientQuestFile() {
        return ClientQuestFile.INSTANCE;
    }

    @Override
    public QuestFile getQuestFile(boolean isClient) {
        if (isClient) {
            QuestFile f = this.getClientQuestFile();
            if (f == null) {
                throw new NullPointerException("Client quest file not loaded!");
            }
            return f;
        }
        return ServerQuestFile.INSTANCE;
    }

    @Override
    public void setTaskGuiProviders() {
        TaskTypes.ITEM.setGuiProvider((gui, quest, callback) -> {
            ItemStackConfig c = new ItemStackConfig(false, false);
            c.defaultValue = ItemStack.field_190927_a;
            c.value = ItemStack.field_190927_a;
            new SelectItemStackScreen(c, accepted -> {
                gui.run();
                if (accepted) {
                    ItemTask itemTask = new ItemTask(quest);
                    itemTask.item = ((ItemStack)c.value).func_77946_l();
                    itemTask.item.func_190920_e(1);
                    itemTask.count = ((ItemStack)c.value).func_190916_E();
                    callback.accept(itemTask);
                }
            }).openGui();
        });
        TaskTypes.CHECKMARK.setGuiProvider((gui, quest, callback) -> {
            StringConfig c = new StringConfig(null);
            EditConfigFromStringScreen.open((ConfigFromString)c, (Object)"", (Object)"", accepted -> {
                if (accepted) {
                    CheckmarkTask checkmarkTask = new CheckmarkTask(quest);
                    checkmarkTask.title = (String)c.value;
                    callback.accept(checkmarkTask);
                }
                gui.run();
            });
        });
        TaskTypes.DIMENSION.setGuiProvider((gui, quest, callback) -> {
            DimensionTask task = new DimensionTask(quest);
            task.dimension = Minecraft.func_71410_x().field_71441_e.func_234923_W_();
            callback.accept(task);
        });
        TaskTypes.LOCATION.setGuiProvider((gui, quest, callback) -> {
            TileEntity tileEntity;
            LocationTask task = new LocationTask(quest);
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71476_x instanceof BlockRayTraceResult && (tileEntity = mc.field_71441_e.func_175625_s(((BlockRayTraceResult)mc.field_71476_x).func_216350_a())) instanceof StructureBlockTileEntity) {
                BlockPos pos = ((StructureBlockTileEntity)tileEntity).func_189711_e();
                BlockPos size = ((StructureBlockTileEntity)tileEntity).func_189717_g();
                task.dimension = mc.field_71441_e.func_234923_W_();
                task.x = pos.func_177958_n() + tileEntity.func_174877_v().func_177958_n();
                task.y = pos.func_177956_o() + tileEntity.func_174877_v().func_177956_o();
                task.z = pos.func_177952_p() + tileEntity.func_174877_v().func_177952_p();
                task.w = Math.max(1, size.func_177958_n());
                task.h = Math.max(1, size.func_177956_o());
                task.d = Math.max(1, size.func_177952_p());
                callback.accept(task);
                return;
            }
            ConfigGroup group = new ConfigGroup("ftbquests");
            task.getConfig(task.createSubGroup(group));
            group.savedCallback = accepted -> {
                gui.run();
                if (accepted) {
                    callback.accept(task);
                }
            };
            new EditConfigScreen(group).openGui();
        });
    }

    @Override
    public void setRewardGuiProviders() {
        RewardTypes.ITEM.setGuiProvider((gui, quest, callback) -> {
            ItemStackConfig c = new ItemStackConfig(false, false);
            c.defaultValue = ItemStack.field_190927_a;
            c.value = ItemStack.field_190927_a;
            new SelectItemStackScreen(c, accepted -> {
                if (accepted) {
                    ItemStack copy = ((ItemStack)c.value).func_77946_l();
                    copy.func_190920_e(1);
                    ItemReward reward = new ItemReward(quest, copy);
                    reward.count = ((ItemStack)c.value).func_190916_E();
                    callback.accept(reward);
                }
                gui.run();
            }).openGui();
        });
        RewardTypes.XP.setGuiProvider((gui, quest, callback) -> {
            IntConfig c = new IntConfig(1, Integer.MAX_VALUE);
            EditConfigFromStringScreen.open((ConfigFromString)c, (Object)100, (Object)100, accepted -> {
                if (accepted) {
                    callback.accept(new XPReward(quest, (Integer)c.value));
                }
                gui.run();
            });
        });
        RewardTypes.XP_LEVELS.setGuiProvider((gui, quest, callback) -> {
            IntConfig c = new IntConfig(1, Integer.MAX_VALUE);
            EditConfigFromStringScreen.open((ConfigFromString)c, (Object)5, (Object)5, accepted -> {
                if (accepted) {
                    callback.accept(new XPLevelsReward(quest, (Integer)c.value));
                }
                gui.run();
            });
        });
    }

    @Override
    public PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public boolean isClientDataLoaded() {
        return ClientQuestFile.INSTANCE != null;
    }

    @Override
    public TeamData getClientPlayerData() {
        return ClientQuestFile.INSTANCE.self;
    }

    @Override
    public QuestFile createClientQuestFile() {
        return new ClientQuestFile();
    }

    @Override
    public void openGui() {
        ClientQuestFile.INSTANCE.openQuestGui();
    }

    @Override
    public void openCustomIconGui(PlayerEntity player, Hand hand) {
        ImageConfig config = new ImageConfig();
        config.onClicked(MouseButton.LEFT, b -> {
            if (b) {
                if (((String)config.value).isEmpty()) {
                    player.func_184586_b(hand).func_196083_e("Icon");
                } else {
                    player.func_184586_b(hand).func_77983_a("Icon", (INBT)StringNBT.func_229705_a_((String)((String)config.value)));
                }
                new SetCustomImageMessage(hand, (String)config.value).sendToServer();
            }
            Minecraft.func_71410_x().func_147108_a(null);
        });
    }
}

