/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonCreatedEvent;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.events.ClearFileCacheEvent;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.item.LootCrateItem;
import dev.ftb.mods.ftbquests.net.SubmitTaskMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.task.ObservationTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.architectury.event.events.GuiEvent;
import me.shedaniel.architectury.event.events.client.ClientLifecycleEvent;
import me.shedaniel.architectury.event.events.client.ClientTickEvent;
import me.shedaniel.architectury.registry.ColorHandlers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class FTBQuestsClientEventHandler {
    private static final ResourceLocation QUESTS_BUTTON = new ResourceLocation("ftbquests", "quests");
    private List<ObservationTask> observationTasks = null;
    private ObservationTask currentlyObserving = null;
    private long currentlyObservingTicks = 0L;

    public void init() {
        ClientLifecycleEvent.CLIENT_SETUP.register(this::registerItemColors);
        SidebarButtonCreatedEvent.EVENT.register(this::onSidebarButtonCreated);
        ClearFileCacheEvent.EVENT.register(this::onFileCacheClear);
        ClientTickEvent.CLIENT_PRE.register(this::onKeyEvent);
        CustomClickEvent.EVENT.register(this::onCustomClick);
        ClientTickEvent.CLIENT_PRE.register(this::onClientTick);
        GuiEvent.RENDER_HUD.register(this::onScreenRender);
    }

    private void registerItemColors(Minecraft minecraft) {
        ColorHandlers.registerItemColors((stack, tintIndex) -> {
            LootCrate crate = LootCrateItem.getCrate(stack);
            return crate == null ? -1 : 0xFF000000 | crate.color.rgb();
        }, (IItemProvider[])new IItemProvider[]{(IItemProvider)FTBQuestsItems.LOOTCRATE.get()});
    }

    private void onSidebarButtonCreated(SidebarButtonCreatedEvent event) {
        if (event.getButton().id.equals((Object)QUESTS_BUTTON)) {
            event.getButton().setCustomTextHandler(() -> {
                if (ClientQuestFile.exists()) {
                    if (ClientQuestFile.INSTANCE.disableGui && !ClientQuestFile.INSTANCE.canEdit()) {
                        return "[X]";
                    }
                    if (ClientQuestFile.INSTANCE.self.isLocked()) {
                        return "[X]";
                    }
                    if (ClientQuestFile.INSTANCE.self.hasUnclaimedRewards(Minecraft.func_71410_x().field_71439_g.func_110124_au(), ClientQuestFile.INSTANCE)) {
                        return "[!]";
                    }
                }
                return "";
            });
        }
    }

    private void onFileCacheClear(ClearFileCacheEvent event) {
        this.observationTasks = null;
    }

    private void onKeyEvent(Minecraft mc) {
        if (FTBQuestsClient.KEY_QUESTS.func_151468_f()) {
            ClientQuestFile.INSTANCE.openQuestGui();
        }
    }

    private ActionResultType onCustomClick(CustomClickEvent event) {
        if (event.getId().func_110624_b().equals("ftbquests") && "open_gui".equals(event.getId().func_110623_a())) {
            if (!ClientQuestFile.exists()) {
                Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new SystemToast(SystemToast.Type.TUTORIAL_HINT, (ITextComponent)new StringTextComponent("Error?! Server doesn't have FTB Quests!"), null));
            } else {
                ClientQuestFile.INSTANCE.openQuestGui();
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    private void onClientTick(Minecraft mc) {
        if (mc.field_71441_e != null && ClientQuestFile.exists() && mc.field_71439_g != null) {
            if (this.observationTasks == null) {
                this.observationTasks = ClientQuestFile.INSTANCE.collect(ObservationTask.class);
            }
            if (this.observationTasks.isEmpty()) {
                return;
            }
            this.currentlyObserving = null;
            if (mc.field_71476_x != null && mc.field_71476_x.func_216346_c() != RayTraceResult.Type.MISS) {
                for (ObservationTask task : this.observationTasks) {
                    if (ClientQuestFile.INSTANCE.self.isCompleted(task) || !task.observe((PlayerEntity)mc.field_71439_g, mc.field_71476_x) || !ClientQuestFile.INSTANCE.self.canStartTasks(task.quest)) continue;
                    this.currentlyObserving = task;
                    break;
                }
            }
            if (this.currentlyObserving != null) {
                if (!mc.func_147113_T()) {
                    ++this.currentlyObservingTicks;
                }
                if (this.currentlyObservingTicks >= this.currentlyObserving.timer) {
                    new SubmitTaskMessage(this.currentlyObserving.id).sendToServer();
                    ClientQuestFile.INSTANCE.self.addProgress(this.currentlyObserving, 1L);
                    this.currentlyObserving = null;
                    this.currentlyObservingTicks = 0L;
                }
            } else {
                this.currentlyObservingTicks = 0L;
            }
        }
    }

    private void onScreenRender(MatrixStack matrixStack, float tickDelta) {
        if (!ClientQuestFile.exists()) {
            return;
        }
        ClientQuestFile file = ClientQuestFile.INSTANCE;
        TeamData data = file.self;
        GlStateManager.func_227740_m_();
        Minecraft mc = Minecraft.func_71410_x();
        int cy = mc.func_228018_at_().func_198087_p() / 2;
        if (this.currentlyObserving != null) {
            int cx = mc.func_228018_at_().func_198107_o() / 2;
            IFormattableTextComponent cot = this.currentlyObserving.getMutableTitle().func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.UNDERLINE});
            int sw = mc.field_71466_p.func_238414_a_((ITextProperties)cot);
            int bw = Math.max(sw, 100);
            Color4I.DARK_GRAY.withAlpha(130).draw(matrixStack, cx - bw / 2 - 3, cy - 63, bw + 6, 29);
            GuiHelper.drawHollowRect((MatrixStack)matrixStack, (int)(cx - bw / 2 - 3), (int)(cy - 63), (int)(bw + 6), (int)29, (Color4I)Color4I.DARK_GRAY, (boolean)false);
            mc.field_71466_p.func_243246_a(matrixStack, (ITextComponent)cot, (float)cx - (float)sw / 2.0f, (float)(cy - 60), 0xFFFFFF);
            double completed = (double)((float)this.currentlyObservingTicks + tickDelta) / (double)this.currentlyObserving.timer;
            GuiHelper.drawHollowRect((MatrixStack)matrixStack, (int)(cx - bw / 2), (int)(cy - 49), (int)bw, (int)12, (Color4I)Color4I.DARK_GRAY, (boolean)false);
            Color4I.LIGHT_BLUE.withAlpha(130).draw(matrixStack, cx - bw / 2 + 1, cy - 48, (int)(((double)bw - 2.0) * completed), 10);
            String cop = this.currentlyObservingTicks * 100L / this.currentlyObserving.timer + "%";
            mc.field_71466_p.func_238405_a_(matrixStack, cop, (float)cx - (float)mc.field_71466_p.func_78256_a(cop) / 2.0f, (float)(cy - 47), 0xFFFFFF);
        }
        if (!data.pinnedQuests.isEmpty()) {
            ArrayList<IReorderingProcessor> list = new ArrayList<IReorderingProcessor>();
            boolean first = true;
            if (data.pinnedQuests.contains(1L)) {
                for (ChapterGroup group : file.chapterGroups) {
                    for (Chapter chapter : group.chapters) {
                        for (Quest quest : chapter.quests) {
                            if (data.isCompleted(quest) || !data.canStartTasks(quest)) continue;
                            if (first) {
                                first = false;
                                continue;
                            }
                            list.add(IReorderingProcessor.field_242232_a);
                        }
                    }
                }
            } else {
                LongIterator sw = data.pinnedQuests.iterator();
                while (sw.hasNext()) {
                    long q = (Long)sw.next();
                    Quest quest = file.getQuest(q);
                    if (quest == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        list.add(IReorderingProcessor.field_242232_a);
                    }
                    if (data.isCompleted(quest)) {
                        StringTextComponent component = new StringTextComponent("");
                        component.func_230529_a_((ITextComponent)quest.getMutableTitle().func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, TextFormatting.GREEN}));
                        component.func_230529_a_((ITextComponent)new StringTextComponent(" 100%").func_240699_a_(TextFormatting.DARK_GREEN));
                        list.addAll(mc.field_71466_p.func_238425_b_((ITextProperties)component, 160));
                        continue;
                    }
                    list.addAll(mc.field_71466_p.func_238425_b_(ITextProperties.func_240655_a_((ITextProperties[])new ITextProperties[]{mc.field_71466_p.func_238420_b_().func_238358_a_((ITextProperties)quest.getTitle(), 160, Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true))), new StringTextComponent(" ").func_240699_a_(TextFormatting.DARK_AQUA).func_240702_b_(data.getRelativeProgress(quest) + "%")}), 500));
                    for (Task task : quest.tasks) {
                        if (data.isCompleted(task)) continue;
                        list.addAll(mc.field_71466_p.func_238425_b_(ITextProperties.func_240655_a_((ITextProperties[])new ITextProperties[]{mc.field_71466_p.func_238420_b_().func_238358_a_((ITextProperties)task.getTitle(), 160, Style.field_240709_b_.func_240721_b_(TextFormatting.GRAY)), new StringTextComponent(" ").func_240699_a_(TextFormatting.GREEN).func_240702_b_(task.formatProgress(data, data.getProgress(task))).func_240702_b_("/").func_240702_b_(task.formatMaxProgress())}), 500));
                    }
                }
            }
            if (!list.isEmpty()) {
                int mw = 0;
                for (IReorderingProcessor s : list) {
                    mw = Math.max(mw, (int)mc.field_71466_p.func_238420_b_().func_243238_a(s));
                }
                float scale = ((Double)ThemeProperties.PINNED_QUEST_SIZE.get(file)).floatValue();
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)((float)mc.func_228018_at_().func_198107_o() - (float)mw * scale) - 8.0, (double)cy - (double)list.size() * 4.5 * (double)scale, 100.0);
                matrixStack.func_227862_a_(scale, scale, 1.0f);
                Color4I.BLACK.withAlpha(100).draw(matrixStack, 0, 0, mw + 8, list.size() * 9 + 8);
                for (int i = 0; i < list.size(); ++i) {
                    mc.field_71466_p.func_238407_a_(matrixStack, (IReorderingProcessor)list.get(i), 4.0f, (float)(i * 9 + 4), -1);
                }
                matrixStack.func_227865_b_();
            }
        }
    }
}

