/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.latvian.mods.itemfilters.api.IStringValueFilter;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import dev.latvian.mods.itemfilters.api.ItemFiltersItems;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public class TaskButton
extends Button {
    public final QuestScreen questScreen;
    public Task task;

    public TaskButton(Panel panel, Task t) {
        super(panel, t.getTitle(), Icons.ACCEPT);
        this.questScreen = (QuestScreen)panel.getGui();
        this.task = t;
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (button.isRight() || this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            this.task.onButtonClicked(this, !this.task.invalid && this.questScreen.file.self.canStartTasks(this.task.quest) && !this.questScreen.file.self.isCompleted(this.task));
        } else if (button.isRight() && this.questScreen.file.canEdit()) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            if (this.task instanceof ItemTask) {
                final ItemTask i = (ItemTask)this.task;
                final Collection tags = TagCollectionManager.func_242178_a().func_241836_b().func_199913_a((Object)i.item.func_77973_b());
                if (!tags.isEmpty() && !ItemFiltersAPI.isFilter((ItemStack)i.item)) {
                    contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.task.ftbquests.item.convert_tag"), (Icon)ThemeProperties.RELOAD_ICON.get(), () -> {
                        final ItemStack tagFilter = new ItemStack((IItemProvider)ItemFiltersItems.TAG.get());
                        if (tags.size() == 1) {
                            String tag = ((ResourceLocation)tags.iterator().next()).toString();
                            ((IStringValueFilter)tagFilter.func_77973_b()).setValue(tagFilter, tag);
                            i.item = tagFilter;
                            if (i.title.isEmpty()) {
                                i.title = "Any #" + tag;
                            }
                            new EditObjectMessage(i).sendToServer();
                        } else {
                            new ButtonListBaseScreen(){

                                public void addButtons(Panel panel) {
                                    for (final ResourceLocation s : tags) {
                                        panel.add((Widget)new SimpleTextButton(panel, (ITextComponent)new StringTextComponent(s.toString()), (Icon)Icon.EMPTY){

                                            public void onClicked(MouseButton button) {
                                                TaskButton.this.questScreen.openGui();
                                                ((IStringValueFilter)tagFilter.func_77973_b()).setValue(tagFilter, s.toString());
                                                i.item = tagFilter;
                                                if (i.title.isEmpty()) {
                                                    i.title = "Any #" + s;
                                                }
                                                new EditObjectMessage(i).sendToServer();
                                            }
                                        });
                                    }
                                }
                            }.openGui();
                        }
                    }));
                    contextMenu.add(ContextMenuItem.SEPARATOR);
                }
            }
            this.questScreen.addObjectMenuItems(contextMenu, (Runnable)this.getGui(), this.task);
            this.getGui().openContextMenu(contextMenu);
        }
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return this.task.getIngredient();
    }

    public void addMouseOverText(TooltipList list) {
        this.questScreen.addInfoTooltip(list, this.task);
        if (this.task.addTitleInMouseOverText()) {
            list.add(this.getTitle());
        }
        if (this.questScreen.file.self.canStartTasks(this.task.quest)) {
            long maxp = this.task.getMaxProgress();
            long progress = this.questScreen.file.self.getProgress(this.task);
            if (maxp > 1L) {
                if (this.task.hideProgressNumbers()) {
                    list.add((ITextComponent)new StringTextComponent("[" + this.task.getRelativeProgressFromChildren(this.questScreen.file.self) + "%]").func_240699_a_(TextFormatting.DARK_GREEN));
                } else {
                    String prog;
                    String max = TaskButton.isShiftKeyDown() ? Long.toUnsignedString(maxp) : this.task.formatMaxProgress();
                    String string = prog = TaskButton.isShiftKeyDown() ? Long.toUnsignedString(progress) : this.task.formatProgress(this.questScreen.file.self, progress);
                    if (maxp < 100L) {
                        list.add((ITextComponent)new StringTextComponent((progress > maxp ? max : prog) + " / " + max).func_240699_a_(TextFormatting.DARK_GREEN));
                    } else {
                        list.add((ITextComponent)new StringTextComponent((progress > maxp ? max : prog) + " / " + max).func_240699_a_(TextFormatting.DARK_GREEN).func_230529_a_((ITextComponent)new StringTextComponent(" [" + this.task.getRelativeProgressFromChildren(this.questScreen.file.self) + "%]").func_240699_a_(TextFormatting.DARK_GRAY)));
                    }
                }
            }
        }
        this.task.addMouseOverText(list, this.questScreen.file.self);
    }

    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(matrixStack, theme, x, y, w, h);
        }
    }

    public void drawIcon(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        this.task.drawGUI(this.questScreen.file.self, matrixStack, x, y, w, h);
    }

    public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        int bs = h >= 32 ? 32 : 16;
        GuiHelper.setupDrawing();
        this.drawBackground(matrixStack, theme, x, y, w, h);
        this.drawIcon(matrixStack, theme, x + (w - bs) / 2, y + (h - bs) / 2, bs, bs);
        if (this.questScreen.file.self == null) {
            return;
        }
        if (this.questScreen.contextMenu != null) {
            // empty if block
        }
        if (this.questScreen.file.self.isCompleted(this.task)) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 200.0);
            RenderSystem.enableBlend();
            ((Icon)ThemeProperties.CHECK_ICON.get()).draw(matrixStack, x + w - 9, y + 1, 8, 8);
            matrixStack.func_227865_b_();
        } else {
            IFormattableTextComponent s = this.task.getButtonText();
            if (s != StringTextComponent.field_240750_d_) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)((float)x + 19.0f - (float)theme.getStringWidth((ITextProperties)s) / 2.0f), (double)((float)y + 15.0f), 200.0);
                matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
                RenderSystem.enableBlend();
                theme.drawString(matrixStack, (Object)s, 0.0f, 0.0f, Color4I.WHITE, 2);
                matrixStack.func_227865_b_();
            }
        }
    }
}

