/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.integration.kubejs;

import dev.ftb.mods.ftbquests.events.CustomRewardEvent;
import dev.ftb.mods.ftbquests.events.CustomTaskEvent;
import dev.ftb.mods.ftbquests.events.ObjectCompletedEvent;
import dev.ftb.mods.ftbquests.events.ObjectStartedEvent;
import dev.ftb.mods.ftbquests.integration.kubejs.CustomRewardEventJS;
import dev.ftb.mods.ftbquests.integration.kubejs.CustomTaskEventJS;
import dev.ftb.mods.ftbquests.integration.kubejs.FTBQuestsKubeJSPlayerData;
import dev.ftb.mods.ftbquests.integration.kubejs.FTBQuestsKubeJSWrapper;
import dev.ftb.mods.ftbquests.integration.kubejs.QuestObjectCompletedEventJS;
import dev.ftb.mods.ftbquests.integration.kubejs.QuestObjectStartedEventJS;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.latvian.kubejs.player.AttachPlayerDataEvent;
import dev.latvian.kubejs.player.PlayerDataJS;
import dev.latvian.kubejs.script.BindingsEvent;
import dev.latvian.kubejs.script.ScriptType;
import me.shedaniel.architectury.event.EventResult;

public class KubeJSIntegration {
    public static void init() {
        BindingsEvent.EVENT.register(KubeJSIntegration::registerBindings);
        AttachPlayerDataEvent.EVENT.register(KubeJSIntegration::attachPlayerData);
        CustomTaskEvent.EVENT.register(KubeJSIntegration::onCustomTask);
        CustomRewardEvent.EVENT.register(KubeJSIntegration::onCustomReward);
        ObjectCompletedEvent.GENERIC.register(KubeJSIntegration::onCompleted);
        ObjectStartedEvent.GENERIC.register(KubeJSIntegration::onStarted);
    }

    public static void registerBindings(BindingsEvent event) {
        event.add("FTBQuests", (Object)FTBQuestsKubeJSWrapper.INSTANCE);
    }

    public static void attachPlayerData(AttachPlayerDataEvent event) {
        event.add("ftbquests", (Object)new FTBQuestsKubeJSPlayerData((PlayerDataJS)event.getParent()));
    }

    public static EventResult onCustomTask(CustomTaskEvent event) {
        if (new CustomTaskEventJS(event).post(ScriptType.SERVER, "ftbquests.custom_task", event.getTask().toString())) {
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    public static EventResult onCustomReward(CustomRewardEvent event) {
        if (new CustomRewardEventJS(event).post(ScriptType.SERVER, "ftbquests.custom_reward", event.getReward().toString())) {
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    public static EventResult onCompleted(ObjectCompletedEvent<?> event) {
        if (event.getData().file.isServerSide()) {
            QuestObjectCompletedEventJS e = new QuestObjectCompletedEventJS(event);
            e.post(ScriptType.SERVER, "ftbquests.completed", ((QuestObjectBase)event.getObject()).getCodeString());
            for (String tag : ((QuestObjectBase)event.getObject()).getTags()) {
                e.post(ScriptType.SERVER, "ftbquests.completed." + tag);
            }
        }
        return EventResult.pass();
    }

    public static EventResult onStarted(ObjectStartedEvent<?> event) {
        if (event.getData().file.isServerSide()) {
            QuestObjectStartedEventJS e = new QuestObjectStartedEventJS(event);
            e.post(ScriptType.SERVER, "ftbquests.started", ((QuestObjectBase)event.getObject()).getCodeString());
            for (String tag : ((QuestObjectBase)event.getObject()).getTags()) {
                e.post(ScriptType.SERVER, "ftbquests.started." + tag);
            }
        }
        return EventResult.pass();
    }
}

