/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.integration.jei.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.EditObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.util.NetUtils;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.simple.BaseC2SMessage;
import me.shedaniel.architectury.networking.simple.MessageType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class EditObjectMessage
extends BaseC2SMessage {
    private final long id;
    private final CompoundNBT nbt;

    EditObjectMessage(PacketBuffer buffer) {
        this.id = buffer.readLong();
        this.nbt = buffer.func_150793_b();
    }

    public EditObjectMessage(QuestObjectBase o) {
        this.id = o.id;
        this.nbt = new CompoundNBT();
        o.writeData(this.nbt);
        FTBQuestsJEIHelper.refresh(o);
        ClientQuestFile.INSTANCE.clearCachedData();
        o.editedFromGUI();
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.EDIT_OBJECT;
    }

    public void write(PacketBuffer buffer) {
        buffer.writeLong(this.id);
        buffer.func_150786_a(this.nbt);
    }

    public void handle(NetworkManager.PacketContext context) {
        QuestObjectBase object;
        if (NetUtils.canEdit(context) && (object = ServerQuestFile.INSTANCE.getBase(this.id)) != null) {
            object.readData(this.nbt);
            object.editedFromGUIOnServer();
            ServerQuestFile.INSTANCE.clearCachedData();
            ServerQuestFile.INSTANCE.save();
            new EditObjectResponseMessage(object).sendToAll(context.getPlayer().func_184102_h());
        }
    }
}

