/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.jei.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.ClaimRewardMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class Reward
extends QuestObjectBase {
    public Quest quest;
    public Tristate team;
    public RewardAutoClaim autoclaim;

    public Reward(Quest q) {
        this.quest = q;
        this.team = Tristate.DEFAULT;
        this.autoclaim = RewardAutoClaim.DEFAULT;
    }

    @Override
    public final QuestObjectType getObjectType() {
        return QuestObjectType.REWARD;
    }

    @Override
    public final QuestFile getQuestFile() {
        return this.quest.chapter.file;
    }

    @Override
    @Nullable
    public final Chapter getQuestChapter() {
        return this.quest.chapter;
    }

    @Override
    public final long getParentID() {
        return this.quest.id;
    }

    public abstract RewardType getType();

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        if (this.team != Tristate.DEFAULT) {
            this.team.write(nbt, "team_reward");
        }
        if (this.autoclaim != RewardAutoClaim.DEFAULT) {
            nbt.func_74778_a("auto", this.autoclaim.id);
        }
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.team = Tristate.read((CompoundNBT)nbt, (String)"team_reward");
        this.autoclaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP.get(nbt.func_74779_i("auto")));
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        Tristate.NAME_MAP.write(buffer, (Object)this.team);
        RewardAutoClaim.NAME_MAP.write(buffer, (Object)this.autoclaim);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.team = (Tristate)Tristate.NAME_MAP.read(buffer);
        this.autoclaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP.read(buffer));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("team", (Object)this.team, v -> {
            this.team = v;
        }, Tristate.NAME_MAP).setNameKey("ftbquests.reward.team_reward");
        config.addEnum("autoclaim", (Object)this.autoclaim, v -> {
            this.autoclaim = v;
        }, RewardAutoClaim.NAME_MAP).setNameKey("ftbquests.reward.autoclaim");
    }

    public abstract void claim(ServerPlayerEntity var1, boolean var2);

    public Optional<ItemStack> claimAutomated(TileEntity tileEntity, UUID playerId, @Nullable ServerPlayerEntity player, boolean simulate) {
        if (player != null) {
            if (!simulate) {
                this.claim(player, false);
            }
            return Optional.of(ItemStack.field_190927_a);
        }
        return Optional.empty();
    }

    public boolean automatedClaimPre(TileEntity tileEntity, List<ItemStack> items, Random random, UUID playerId, @Nullable ServerPlayerEntity player) {
        return player != null;
    }

    public void automatedClaimPost(TileEntity tileEntity, UUID playerId, @Nullable ServerPlayerEntity player) {
        if (player != null) {
            this.claim(player, false);
        }
    }

    @Override
    public final void deleteSelf() {
        this.quest.rewards.remove(this);
        for (TeamData data : this.getQuestFile().getAllData()) {
            data.deleteReward(this);
        }
        super.deleteSelf();
    }

    @Override
    public final void deleteChildren() {
        for (TeamData data : this.getQuestFile().getAllData()) {
            data.deleteReward(this);
        }
        super.deleteChildren();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void editedFromGUI() {
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null && gui.isViewingQuest()) {
            gui.viewQuestPanel.refreshWidgets();
        }
        if (gui != null) {
            gui.questPanel.refreshWidgets();
        }
    }

    @Override
    public void onCreated() {
        this.quest.rewards.add(this);
    }

    public final boolean isTeamReward() {
        return this.team.get(this.quest.chapter.file.defaultRewardTeam);
    }

    public final RewardAutoClaim getAutoClaimType() {
        if (this.quest.chapter.alwaysInvisible && (this.autoclaim == RewardAutoClaim.DEFAULT || this.autoclaim == RewardAutoClaim.DISABLED)) {
            return RewardAutoClaim.ENABLED;
        }
        if (this.autoclaim == RewardAutoClaim.DEFAULT) {
            return this.quest.chapter.file.defaultRewardAutoClaim;
        }
        return this.autoclaim;
    }

    @Override
    public final void forceProgress(TeamData teamData, ProgressChange progressChange) {
        if (progressChange.reset) {
            teamData.resetReward(progressChange.player, this);
        } else {
            teamData.claimReward(progressChange.player, this, progressChange.time.getTime());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        return this.getType().getIcon();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent getAltTitle() {
        return this.getType().getDisplayName();
    }

    @Override
    public final ConfigGroup createSubGroup(ConfigGroup group) {
        RewardType type = this.getType();
        return group.getGroup(this.getObjectType().id).getGroup(type.id.func_110624_b()).getGroup(type.id.func_110623_a());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(TooltipList list) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addTitleInMouseOverText() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        if (canClick) {
            button.playClickSound();
            new ClaimRewardMessage(this.id, true).sendToServer();
        }
    }

    public boolean getExcludeFromClaimAll() {
        return this.getType().getExcludeFromListRewards();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Object getIngredient() {
        return this.getIcon().getIngredient();
    }

    @Override
    public final int refreshJEI() {
        return FTBQuestsJEIHelper.QUESTS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getButtonText() {
        return "";
    }
}

