/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.integration.StageHelper;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.BooleanTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import me.shedaniel.architectury.hooks.PlayerHooks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StageTask
extends BooleanTask {
    public String stage = "";

    public StageTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.STAGE;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("stage", this.stage);
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.stage = nbt.func_74779_i("stage");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_211400_a(this.stage, Short.MAX_VALUE);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.stage = buffer.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("stage", this.stage, v -> {
            this.stage = v;
        }, "").setNameKey("ftbquests.task.ftbquests.gamestage");
    }

    @OnlyIn(value=Dist.CLIENT)
    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent("ftbquests.task.ftbquests.gamestage").func_240702_b_(": ").func_230529_a_((ITextComponent)new StringTextComponent(this.stage).func_240699_a_(TextFormatting.YELLOW));
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    @Override
    public boolean canSubmit(TeamData teamData, ServerPlayerEntity player) {
        return ((StageHelper)StageHelper.instance.func_179281_c()).has((PlayerEntity)player, this.stage);
    }

    public static void checkStages(ServerPlayerEntity player) {
        TeamData data;
        TeamData teamData = data = ServerQuestFile.INSTANCE == null || PlayerHooks.isFake((PlayerEntity)player) ? null : ServerQuestFile.INSTANCE.getData((Entity)player);
        if (data == null || data.isLocked()) {
            return;
        }
        ServerQuestFile.INSTANCE.currentPlayer = player;
        for (Task task : ServerQuestFile.INSTANCE.getAllTasks()) {
            if (!(task instanceof StageTask) || !data.canStartTasks(task.quest)) continue;
            task.submitTask(data, player);
        }
        ServerQuestFile.INSTANCE.currentPlayer = null;
    }
}

