/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.net;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.net.FTBTeamsNet;
import java.util.HashSet;
import java.util.Set;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.simple.BaseC2SMessage;
import me.shedaniel.architectury.networking.simple.MessageType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;

public class CreatePartyMessage
extends BaseC2SMessage {
    private final String name;
    private final String description;
    private final int color;
    private final Set<GameProfile> invited;

    CreatePartyMessage(PacketBuffer buffer) {
        this.name = buffer.func_150789_c(Short.MAX_VALUE);
        this.description = buffer.func_150789_c(Short.MAX_VALUE);
        this.color = buffer.readInt();
        int s = buffer.func_150792_a();
        this.invited = new HashSet<GameProfile>(s);
        for (int i = 0; i < s; ++i) {
            this.invited.add(new GameProfile(buffer.func_179253_g(), buffer.func_150789_c(Short.MAX_VALUE)));
        }
    }

    public CreatePartyMessage(String n, String d, int c, Set<GameProfile> i) {
        this.name = n;
        this.description = d;
        this.color = c;
        this.invited = i;
    }

    public MessageType getType() {
        return FTBTeamsNet.CREATE_PARTY;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_211400_a(this.name, Short.MAX_VALUE);
        buffer.func_211400_a(this.description, Short.MAX_VALUE);
        buffer.writeInt(this.color);
        buffer.func_150787_b(this.invited.size());
        for (GameProfile p : this.invited) {
            buffer.func_179252_a(p.getId());
            buffer.func_211400_a(p.getName(), Short.MAX_VALUE);
        }
    }

    public void handle(NetworkManager.PacketContext context) {
        ServerPlayerEntity player = (ServerPlayerEntity)context.getPlayer();
        Team team = FTBTeamsAPI.getPlayerTeam(player);
        if (team instanceof PlayerTeam) {
            ((PlayerTeam)team).createParty(player, this.name, this.description, this.color, this.invited);
        }
    }
}

