/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.net;

import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.event.TeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.net.FTBTeamsNet;
import dev.ftb.mods.ftbteams.net.UpdateSettingsResponseMessage;
import dev.ftb.mods.ftbteams.property.TeamProperties;
import java.util.function.Consumer;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.simple.BaseC2SMessage;
import me.shedaniel.architectury.networking.simple.MessageType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;

public class UpdateSettingsMessage
extends BaseC2SMessage {
    public final TeamProperties properties;

    UpdateSettingsMessage(PacketBuffer buffer) {
        this.properties = new TeamProperties();
        this.properties.read(buffer);
    }

    public UpdateSettingsMessage(TeamProperties p) {
        this.properties = p;
    }

    public MessageType getType() {
        return FTBTeamsNet.UPDATE_SETTINGS;
    }

    public void write(PacketBuffer buffer) {
        this.properties.write(buffer);
    }

    public void handle(NetworkManager.PacketContext context) {
        ServerPlayerEntity player = (ServerPlayerEntity)context.getPlayer();
        Team team = FTBTeamsAPI.getPlayerTeam(player);
        if (!team.isOfficer(player.func_110124_au())) {
            return;
        }
        TeamProperties old = team.properties.copy();
        team.properties.updateFrom(this.properties);
        ((Consumer)TeamEvent.PROPERTIES_CHANGED.invoker()).accept(new TeamPropertiesChangedEvent(team, old));
        team.save();
        new UpdateSettingsResponseMessage(team.getId(), team.properties).sendToAll(player.field_71133_b);
    }
}

