/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.latvian.mods.itemfilters.api.IStringValueFilter;
import dev.latvian.mods.itemfilters.api.StringValueFilterVariant;
import dev.latvian.mods.itemfilters.net.MessageUpdateFilterItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class StringValueFilterScreen
extends Screen {
    public final IStringValueFilter filter;
    public final ItemStack stack;
    public final Hand hand;
    private final Map<String, StringValueFilterVariant> variants;
    private final ArrayList<StringValueFilterVariant> visibleVariants;
    private TextFieldWidget nameField;
    private int selectedVariant = -1;

    public StringValueFilterScreen(IStringValueFilter f, ItemStack is, Hand h) {
        super(is.func_151000_E());
        this.filter = f;
        this.stack = is;
        this.hand = h;
        this.variants = new HashMap<String, StringValueFilterVariant>();
        for (StringValueFilterVariant variant : this.filter.getValueVariants(this.stack)) {
            this.variants.put(variant.id, variant);
        }
        this.visibleVariants = new ArrayList<StringValueFilterVariant>(this.variants.values());
        this.visibleVariants.sort(null);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        int i = this.field_230708_k_ / 2;
        int j = this.field_230709_l_ / 2;
        this.nameField = new TextFieldWidget(this.field_230712_o_, i - 52, j - 6, 104, 12, StringTextComponent.field_240750_d_);
        this.nameField.func_146193_g(-1);
        this.nameField.func_146204_h(-1);
        this.nameField.func_146185_a(false);
        this.nameField.func_212954_a(this::updateVariants);
        this.nameField.func_146180_a(this.filter.getValue(this.stack));
        this.nameField.func_146195_b(true);
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
    }

    private void updateVariants(String txt) {
        if (!this.variants.isEmpty()) {
            this.visibleVariants.clear();
            txt = this.nameField.func_146179_b().toLowerCase();
            if (txt.isEmpty()) {
                this.visibleVariants.addAll(this.variants.values());
            } else {
                for (StringValueFilterVariant variant : this.variants.values()) {
                    if (!variant.id.toLowerCase().contains(txt) && !variant.title.getString().toLowerCase().contains(txt)) continue;
                    this.visibleVariants.add(variant);
                }
            }
            this.visibleVariants.sort(null);
            this.selectedVariant = -1;
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            String text;
            String string = this.visibleVariants.size() == 1 ? this.visibleVariants.get((int)0).id : (text = this.selectedVariant == -1 ? this.nameField.func_146179_b() : this.visibleVariants.get((int)this.selectedVariant).id);
            if (this.variants.isEmpty() || text.isEmpty() || this.variants.containsKey(text)) {
                this.filter.setValue(this.stack, text);
                this.field_230706_i_.func_147108_a(null);
                StringValueFilterVariant variant = this.variants.get(text);
                this.field_230706_i_.func_193033_an().func_192988_a((IToast)new SystemToast(SystemToast.Type.TUTORIAL_HINT, (ITextComponent)new StringTextComponent("Value changed!"), text.isEmpty() ? null : (variant == null ? new StringTextComponent(text) : variant.title.func_230532_e_())));
                this.field_230706_i_.field_71439_g.func_184611_a(this.hand, this.stack);
                new MessageUpdateFilterItem(this.hand, this.stack).send();
            } else {
                this.field_230706_i_.func_193033_an().func_192988_a((IToast)new SystemToast(SystemToast.Type.TUTORIAL_HINT, (ITextComponent)new StringTextComponent("Invalid string!"), null));
            }
            return true;
        }
        if (keyCode == 258) {
            ++this.selectedVariant;
            if (this.selectedVariant == this.visibleVariants.size() || 14 + this.selectedVariant * 10 >= this.field_230709_l_) {
                this.selectedVariant = 0;
            }
            return true;
        }
        if (this.nameField.func_231046_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (this.nameField.func_231042_a_(typedChar, keyCode)) {
            return true;
        }
        return super.func_231042_a_(typedChar, keyCode);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (super.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 1) {
            this.nameField.func_146180_a("");
            return true;
        }
        this.nameField.func_231044_a_(mouseX, mouseY, mouseButton);
        this.nameField.func_146195_b(true);
        return true;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.disableLighting();
        RenderSystem.disableBlend();
        if (!this.variants.isEmpty()) {
            StringValueFilterScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)("Variants [" + this.visibleVariants.size() + "] [Press Tab]"), (int)4, (int)4, (int)-1);
            for (int i = 0; i < this.visibleVariants.size(); ++i) {
                StringValueFilterVariant variant = this.visibleVariants.get(i);
                StringValueFilterScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)variant.title.getString(), (int)(variant.icon.func_190926_b() ? 4 : 14), (int)(14 + i * 10), (int)(i == this.selectedVariant ? -256 : -1));
                if (!variant.icon.func_190926_b()) {
                    RenderSystem.pushMatrix();
                    RenderSystem.translated((double)4.0, (double)(14 + i * 10), (double)0.0);
                    RenderSystem.scaled((double)0.5, (double)0.5, (double)1.0);
                    this.field_230707_j_.field_77023_b = 100.0f;
                    RenderSystem.enableDepthTest();
                    RenderHelper.func_227784_d_();
                    this.field_230707_j_.func_184391_a((LivingEntity)this.field_230706_i_.field_71439_g, variant.icon, 0, 0);
                    this.field_230707_j_.func_180453_a(this.field_230712_o_, variant.icon, 0, 0, "");
                    this.field_230707_j_.field_77023_b = 0.0f;
                    RenderSystem.popMatrix();
                }
                if (14 + i * 10 >= this.field_230709_l_) break;
            }
        }
        this.nameField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }
}

