/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block.entity;

import dev.ftb.mods.ftbquests.block.entity.FTBQuestsBlockEntities;
import dev.ftb.mods.ftbquests.item.LootCrateItem;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class LootCrateOpenerBlockEntity
extends BlockEntity {
    private static final ItemEntry EMPTY_ENTRY = new ItemEntry(ItemStack.f_41583_);
    private static final int MAX_ITEM_TYPES = 64;
    private UUID owner = null;
    private final Map<ItemEntry, Integer> outputs = new LinkedHashMap<ItemEntry, Integer>();

    public LootCrateOpenerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)FTBQuestsBlockEntities.LOOT_CRATE_OPENER.get(), blockPos, blockState);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.outputs.clear();
        ListTag itemTag = compoundTag.m_128437_("Items", 10);
        itemTag.forEach(el -> {
            if (el instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)el;
                ItemStack stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("item"));
                int amount = tag.m_128451_("amount");
                this.outputs.put(new ItemEntry(stack), amount);
            }
        });
        this.owner = compoundTag.m_128403_("Owner") ? compoundTag.m_128342_("Owner") : null;
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        ListTag itemTag = new ListTag();
        this.outputs.forEach((item, amount) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("item", (Tag)item.stack.m_41739_(new CompoundTag()));
            tag.m_128405_("amount", amount.intValue());
            itemTag.add((Object)tag);
        });
        if (!itemTag.isEmpty()) {
            compoundTag.m_128365_("Items", (Tag)itemTag);
        }
        if (this.owner != null) {
            compoundTag.m_128362_("Owner", this.owner);
        }
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public int getOutputCount() {
        return this.outputs.values().stream().mapToInt(v -> v).sum();
    }

    protected int _getSlots() {
        return 2;
    }

    protected ItemStack _getStackInSlot(int slot) {
        return slot == 0 ? ItemStack.f_41583_ : this.outputs.keySet().stream().findFirst().orElse(LootCrateOpenerBlockEntity.EMPTY_ENTRY).stack;
    }

    protected ItemStack _insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot != 0 || this.f_58857_ == null || this.f_58857_.m_142572_() == null || this.f_58857_.f_46443_ || this.outputs.size() >= 64) {
            return stack;
        }
        LootCrate crate = LootCrateItem.getCrate(stack);
        if (crate == null) {
            return stack;
        }
        int totalWeight = crate.table.getTotalWeight(true);
        ServerPlayer player = this.owner == null ? null : this.f_58857_.m_142572_().m_6846_().m_11259_(this.owner);
        boolean update = false;
        if (totalWeight > 0) {
            block0: for (int j = 0; j < stack.m_41613_() * crate.table.lootSize; ++j) {
                int currentWeight = crate.table.emptyWeight;
                int number = this.f_58857_.f_46441_.nextInt(totalWeight) + 1;
                if (currentWeight >= number) continue;
                for (WeightedReward reward : crate.table.rewards) {
                    if ((currentWeight += reward.weight) < number) continue;
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    if (!reward.reward.automatedClaimPre(this, stacks, this.f_58857_.f_46441_, this.owner, player)) continue block0;
                    update = true;
                    if (simulate) continue block0;
                    for (ItemStack stack1 : stacks) {
                        ItemEntry entry = new ItemEntry(stack1);
                        int newAmount = this.outputs.getOrDefault(entry, 0) + stack1.m_41613_();
                        this.outputs.put(entry, newAmount);
                    }
                    reward.reward.automatedClaimPost(this, this.owner, player);
                    continue block0;
                }
            }
        }
        if (update && !simulate) {
            this.m_6596_();
        }
        return ItemStack.f_41583_;
    }

    protected boolean _isItemValid(int slot, ItemStack stack) {
        return slot == 0 && LootCrateItem.getCrate(stack) != null;
    }

    protected ItemStack _extractItem(int slot, int amount, boolean simulate) {
        if (this.f_58857_ == null || slot == 0 || amount <= 0 || this.outputs.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemEntry entry = (ItemEntry)this.outputs.keySet().stream().findFirst().orElseThrow();
        ItemStack stack1 = entry.stack().m_41777_();
        int count = this.outputs.get(entry);
        int toExtract = Math.min(count, Math.min(amount, stack1.m_41741_()));
        stack1.m_41764_(toExtract);
        if (!simulate && !this.f_58857_.f_46443_) {
            if ((count -= toExtract) <= 0) {
                this.outputs.remove(entry);
            } else {
                this.outputs.put(entry, count);
            }
            this.m_6596_();
        }
        return stack1;
    }

    private record ItemEntry(ItemStack stack) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemEntry itemEntry = (ItemEntry)o;
            return this.stack.m_41720_() == itemEntry.stack.m_41720_() && (this.stack.m_41783_() == null || this.stack.m_41783_().equals((Object)itemEntry.stack.m_41783_()));
        }

        @Override
        public int hashCode() {
            return this.stack.m_41783_() != null ? Objects.hash(this.stack.m_41720_(), this.stack.m_41783_().hashCode()) : Objects.hash(this.stack.m_41720_());
        }
    }
}

