/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import dev.architectury.event.EventActor;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ListConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.events.ObjectCompletedEvent;
import dev.ftb.mods.ftbquests.events.ObjectStartedEvent;
import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.gui.MultilineTextEditorScreen;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.DisplayCompletionToastMessage;
import dev.ftb.mods.ftbquests.net.MoveQuestMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.DependencyDepthException;
import dev.ftb.mods.ftbquests.quest.DependencyLoopException;
import dev.ftb.mods.ftbquests.quest.DependencyRequirement;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardClaimType;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import dev.ftb.mods.ftbquests.util.NetUtils;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import dev.ftb.mods.ftbquests.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class Quest
extends QuestObject
implements Movable {
    public Chapter chapter;
    public String subtitle;
    public double x;
    public double y;
    public Tristate hide;
    public String shape;
    public final List<String> description;
    public final List<QuestObject> dependencies;
    public final List<Task> tasks;
    public final List<Reward> rewards;
    public DependencyRequirement dependencyRequirement;
    public String guidePage;
    public Tristate hideDependencyLines;
    public int minRequiredDependencies;
    public Tristate hideTextUntilComplete;
    public Tristate disableJEI;
    public double size;
    public boolean optional;
    public int minWidth;
    public boolean canRepeat;
    public boolean invisible;
    public int invisibleUntilTasks;
    private Component cachedSubtitle = null;
    private Component[] cachedDescription = null;
    private boolean ignoreRewardBlocking;

    public Quest(Chapter c) {
        this.chapter = c;
        this.subtitle = "";
        this.x = 0.0;
        this.y = 0.0;
        this.shape = "";
        this.description = new ArrayList<String>(0);
        this.dependencies = new ArrayList<QuestObject>(0);
        this.tasks = new ArrayList<Task>(1);
        this.rewards = new ArrayList<Reward>(1);
        this.guidePage = "";
        this.hideDependencyLines = Tristate.DEFAULT;
        this.hide = Tristate.DEFAULT;
        this.dependencyRequirement = DependencyRequirement.ALL_COMPLETED;
        this.minRequiredDependencies = 0;
        this.hideTextUntilComplete = Tristate.DEFAULT;
        this.disableJEI = Tristate.DEFAULT;
        this.size = 1.0;
        this.optional = false;
        this.minWidth = 0;
        this.canRepeat = false;
        this.invisible = false;
        this.invisibleUntilTasks = 0;
        this.ignoreRewardBlocking = false;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.QUEST;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.chapter.file;
    }

    @Override
    public Chapter getQuestChapter() {
        return this.chapter;
    }

    @Override
    public long getParentID() {
        return this.chapter.id;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128347_("x", this.x);
        nbt.m_128347_("y", this.y);
        if (!this.shape.isEmpty()) {
            nbt.m_128359_("shape", this.shape);
        }
        if (!this.subtitle.isEmpty()) {
            nbt.m_128359_("subtitle", this.subtitle);
        }
        if (!this.description.isEmpty()) {
            ListTag array = new ListTag();
            for (String value : this.description) {
                array.add((Object)StringTag.m_129297_((String)value));
            }
            nbt.m_128365_("description", (Tag)array);
        }
        if (!this.guidePage.isEmpty()) {
            nbt.m_128359_("guide_page", this.guidePage);
        }
        if (this.hideDependencyLines != Tristate.DEFAULT) {
            nbt.m_128379_("hide_dependency_lines", this.hideDependencyLines.isTrue());
        }
        if (this.minRequiredDependencies > 0) {
            nbt.m_128405_("min_required_dependencies", (int)((byte)this.minRequiredDependencies));
        }
        this.removeInvalidDependencies();
        if (!this.dependencies.isEmpty()) {
            ListTag deps = new ListTag();
            for (QuestObject dep : this.dependencies) {
                deps.add((Object)StringTag.m_129297_((String)dep.getCodeString()));
            }
            nbt.m_128365_("dependencies", (Tag)deps);
        }
        if (this.hide != Tristate.DEFAULT) {
            nbt.m_128379_("hide", this.hide.isTrue());
        }
        if (this.dependencyRequirement != DependencyRequirement.ALL_COMPLETED) {
            nbt.m_128359_("dependency_requirement", this.dependencyRequirement.id);
        }
        if (this.hideTextUntilComplete != Tristate.DEFAULT) {
            nbt.m_128379_("hide_text_until_complete", this.hideTextUntilComplete.isTrue());
        }
        if (this.size != 1.0) {
            nbt.m_128347_("size", this.size);
        }
        if (this.optional) {
            nbt.m_128379_("optional", true);
        }
        if (this.minWidth > 0) {
            nbt.m_128405_("min_width", this.minWidth);
        }
        if (this.canRepeat) {
            nbt.m_128379_("can_repeat", true);
        }
        if (this.invisible) {
            nbt.m_128379_("invisible", true);
        }
        if (this.invisibleUntilTasks > 0) {
            nbt.m_128405_("invisible_until_tasks", this.invisibleUntilTasks);
        }
        if (this.ignoreRewardBlocking) {
            nbt.m_128379_("ignore_reward_blocking", true);
        }
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.subtitle = nbt.m_128461_("subtitle");
        this.x = nbt.m_128459_("x");
        this.y = nbt.m_128459_("y");
        this.shape = nbt.m_128461_("shape");
        if (this.shape.equals("default")) {
            this.shape = "";
        }
        this.description.clear();
        ListTag list = nbt.m_128437_("description", 8);
        for (int k = 0; k < list.size(); ++k) {
            this.description.add(list.m_128778_(k));
        }
        this.guidePage = nbt.m_128461_("guide_page");
        this.hideDependencyLines = Tristate.read((CompoundTag)nbt, (String)"hide_dependency_lines");
        this.minRequiredDependencies = nbt.m_128451_("min_required_dependencies");
        this.dependencies.clear();
        if (nbt.m_128425_("dependencies", 11)) {
            for (int i : nbt.m_128465_("dependencies")) {
                QuestObject object = this.chapter.file.get(i);
                if (object == null) continue;
                this.dependencies.add(object);
            }
        } else {
            ListTag deps = nbt.m_128437_("dependencies", 8);
            for (int i = 0; i < deps.size(); ++i) {
                QuestObject object = this.chapter.file.get(this.chapter.file.getID(deps.m_128778_(i)));
                if (object == null) continue;
                this.dependencies.add(object);
            }
        }
        this.hide = Tristate.read((CompoundTag)nbt, (String)"hide");
        this.dependencyRequirement = (DependencyRequirement)((Object)DependencyRequirement.NAME_MAP.get(nbt.m_128461_("dependency_requirement")));
        this.hideTextUntilComplete = Tristate.read((CompoundTag)nbt, (String)"hide_text_until_complete");
        this.size = nbt.m_128441_("size") ? nbt.m_128459_("size") : 1.0;
        this.optional = nbt.m_128471_("optional");
        this.minWidth = nbt.m_128451_("min_width");
        this.canRepeat = nbt.m_128471_("can_repeat");
        this.invisible = nbt.m_128471_("invisible");
        this.invisibleUntilTasks = nbt.m_128451_("invisible_until_tasks");
        this.ignoreRewardBlocking = nbt.m_128471_("ignore_reward_blocking");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (!this.subtitle.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)2, (!this.description.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)4, (this.size != 1.0 ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8, (!this.guidePage.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)64, (boolean)this.canRepeat);
        flags = Bits.setFlag((int)flags, (int)128, (boolean)this.invisible);
        flags = Bits.setFlag((int)flags, (int)256, (boolean)this.optional);
        flags = Bits.setFlag((int)flags, (int)512, (this.minWidth > 0 ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)1024, (this.invisibleUntilTasks > 0 ? 1 : 0) != 0);
        buffer.m_130130_(flags);
        this.hide.write(buffer);
        this.hideDependencyLines.write(buffer);
        this.hideTextUntilComplete.write(buffer);
        if (!this.subtitle.isEmpty()) {
            buffer.m_130072_(this.subtitle, Short.MAX_VALUE);
        }
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.m_130072_(this.shape, Short.MAX_VALUE);
        if (!this.description.isEmpty()) {
            NetUtils.writeStrings(buffer, this.description);
        }
        if (!this.guidePage.isEmpty()) {
            buffer.m_130072_(this.guidePage, Short.MAX_VALUE);
        }
        buffer.m_130130_(this.minRequiredDependencies);
        DependencyRequirement.NAME_MAP.write(buffer, (Object)this.dependencyRequirement);
        buffer.m_130130_(this.dependencies.size());
        for (QuestObject d : this.dependencies) {
            if (d.invalid) {
                buffer.writeLong(0L);
                continue;
            }
            buffer.writeLong(d.id);
        }
        if (this.size != 1.0) {
            buffer.writeDouble(this.size);
        }
        if (this.minWidth > 0) {
            buffer.m_130130_(this.minWidth);
        }
        buffer.writeBoolean(this.canRepeat);
        if (this.invisibleUntilTasks > 0) {
            buffer.m_130130_(this.invisibleUntilTasks);
        }
        buffer.writeBoolean(this.ignoreRewardBlocking);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        int flags = buffer.m_130242_();
        this.hide = Tristate.read((FriendlyByteBuf)buffer);
        this.hideDependencyLines = Tristate.read((FriendlyByteBuf)buffer);
        this.hideTextUntilComplete = Tristate.read((FriendlyByteBuf)buffer);
        this.subtitle = Bits.getFlag((int)flags, (int)1) ? buffer.m_130136_(Short.MAX_VALUE) : "";
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.shape = buffer.m_130136_(Short.MAX_VALUE);
        if (Bits.getFlag((int)flags, (int)2)) {
            NetUtils.readStrings(buffer, this.description);
        } else {
            this.description.clear();
        }
        this.guidePage = Bits.getFlag((int)flags, (int)8) ? buffer.m_130136_(Short.MAX_VALUE) : "";
        this.optional = Bits.getFlag((int)flags, (int)64);
        this.minRequiredDependencies = buffer.m_130242_();
        this.dependencyRequirement = (DependencyRequirement)((Object)DependencyRequirement.NAME_MAP.read(buffer));
        this.dependencies.clear();
        int d = buffer.m_130242_();
        for (int i = 0; i < d; ++i) {
            QuestObject object = this.chapter.file.get(buffer.readLong());
            if (object == null) continue;
            this.dependencies.add(object);
        }
        this.size = Bits.getFlag((int)flags, (int)4) ? buffer.readDouble() : 1.0;
        this.minWidth = Bits.getFlag((int)flags, (int)512) ? buffer.m_130242_() : 0;
        this.canRepeat = buffer.readBoolean();
        this.invisible = Bits.getFlag((int)flags, (int)128);
        this.invisibleUntilTasks = Bits.getFlag((int)flags, (int)1024) ? buffer.m_130242_() : 0;
        this.ignoreRewardBlocking = buffer.readBoolean();
    }

    @Override
    public int getRelativeProgressFromChildren(TeamData data) {
        if (this.tasks.isEmpty()) {
            return data.areDependenciesComplete(this) ? 100 : 0;
        }
        int progress = 0;
        for (Task task : this.tasks) {
            progress += data.getRelativeProgress(task);
        }
        if (progress > 0 && !data.areDependenciesComplete(this)) {
            return 0;
        }
        return Quest.getRelativeProgressFromChildren(progress, this.tasks.size());
    }

    @Override
    public void onStarted(QuestProgressEventData<?> data) {
        data.teamData.setStarted(this.id, data.time);
        ((EventActor)ObjectStartedEvent.QUEST.invoker()).act((Object)new ObjectStartedEvent.QuestEvent(data.withObject(this)));
        if (!data.teamData.isStarted(this.chapter)) {
            this.chapter.onStarted(data.withObject(this.chapter));
        }
    }

    @Override
    public void onCompleted(QuestProgressEventData<?> data) {
        data.teamData.setCompleted(this.id, data.time);
        ((EventActor)ObjectCompletedEvent.QUEST.invoker()).act((Object)new ObjectCompletedEvent.QuestEvent(data.withObject(this)));
        if (!this.disableToast) {
            for (ServerPlayer player : data.notifiedPlayers) {
                new DisplayCompletionToastMessage(this.id).sendTo(player);
            }
        }
        if (this.chapter.isCompletedRaw(data.teamData)) {
            this.chapter.onCompleted(data.withObject(this.chapter));
        }
        data.teamData.checkAutoCompletion(this);
        for (ChapterGroup group : this.chapter.file.chapterGroups) {
            for (Chapter chapter : group.chapters) {
                for (Quest quest : chapter.quests) {
                    if (!quest.dependencies.contains(this)) continue;
                    data.teamData.checkAutoCompletion(quest);
                }
            }
        }
    }

    @Override
    public void forceProgress(TeamData teamData, ProgressChange progressChange) {
        super.forceProgress(teamData, progressChange);
        for (Reward r : this.rewards) {
            r.forceProgress(teamData, progressChange);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        if (!this.tasks.isEmpty()) {
            return this.tasks.get(0).getTitle();
        }
        return new TranslatableComponent("ftbquests.unnamed");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (Task task : this.tasks) {
            list.add(task.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.chapter.quests.remove(this);
    }

    @Override
    public void deleteChildren() {
        for (Task task : this.tasks) {
            task.deleteChildren();
            task.invalid = true;
        }
        for (Reward reward : this.rewards) {
            reward.deleteChildren();
            reward.invalid = true;
        }
        this.tasks.clear();
        this.rewards.clear();
    }

    @Override
    public void onCreated() {
        this.chapter.quests.add(this);
        if (!this.tasks.isEmpty()) {
            ArrayList<Task> l = new ArrayList<Task>(this.tasks);
            this.tasks.clear();
            for (Task task : l) {
                task.onCreated();
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("subtitle", this.subtitle, v -> {
            this.subtitle = v;
        }, "");
        StringConfig descType = new StringConfig();
        descType.defaultValue = "";
        config.add("description", (ConfigValue)new ListConfig<String, StringConfig>(descType){

            public void onClicked(MouseButton button, ConfigCallback callback) {
                new MultilineTextEditorScreen(this, callback).openGui();
            }
        }, this.description, t -> {
            this.description.clear();
            this.description.addAll((Collection<String>)t);
        }, Collections.emptyList());
        config.addEnum("shape", (Object)(this.shape.isEmpty() ? "default" : this.shape), v -> {
            this.shape = v.equals("default") ? "" : v;
        }, QuestShape.idMapWithDefault);
        config.addTristate("hide", this.hide, v -> {
            this.hide = v;
        });
        config.addDouble("size", this.size, v -> {
            this.size = v;
        }, 1.0, 0.0625, 8.0);
        config.addDouble("x", this.x, v -> {
            this.x = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addDouble("y", this.y, v -> {
            this.y = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        Predicate<QuestObjectBase> depTypes = object -> object != this.chapter.file && object != this.chapter && object instanceof QuestObject;
        this.dependencies.removeIf(Objects::isNull);
        config.addBool("can_repeat", this.canRepeat, v -> {
            this.canRepeat = v;
        }, false);
        config.addList("dependencies", this.dependencies, new ConfigQuestObject(depTypes), null).setNameKey("ftbquests.dependencies");
        config.addEnum("dependency_requirement", (Object)this.dependencyRequirement, v -> {
            this.dependencyRequirement = v;
        }, DependencyRequirement.NAME_MAP);
        config.addInt("min_required_dependencies", this.minRequiredDependencies, v -> {
            this.minRequiredDependencies = v;
        }, 0, 0, Integer.MAX_VALUE);
        config.addTristate("hide_dependency_lines", this.hideDependencyLines, v -> {
            this.hideDependencyLines = v;
        });
        config.addString("guide_page", this.guidePage, v -> {
            this.guidePage = v;
        }, "");
        config.addTristate("hide_text_until_complete", this.hideTextUntilComplete, v -> {
            this.hideTextUntilComplete = v;
        });
        config.addEnum("disable_jei", (Object)this.disableJEI, v -> {
            this.disableJEI = v;
        }, Tristate.NAME_MAP);
        config.addBool("optional", this.optional, v -> {
            this.optional = v;
        }, false);
        config.addInt("min_width", this.minWidth, v -> {
            this.minWidth = v;
        }, 0, 0, 3000);
        config.addBool("invisible", this.invisible, v -> {
            this.invisible = v;
        }, false);
        config.addInt("invisible_until_tasks", this.invisibleUntilTasks, v -> {
            this.invisibleUntilTasks = v;
        }, 0, 0, Integer.MAX_VALUE);
        config.addBool("ignore_reward_blocking", this.ignoreRewardBlocking, v -> {
            this.ignoreRewardBlocking = v;
        }, false);
    }

    public boolean getHideDependencyLines() {
        return this.hideDependencyLines.get(this.chapter.defaultHideDependencyLines);
    }

    @Override
    public Chapter getChapter() {
        return this.chapter;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getWidth() {
        return this.size;
    }

    @Override
    public double getHeight() {
        return this.size;
    }

    @Override
    public String getShape() {
        return this.shape.isEmpty() ? this.chapter.getDefaultQuestShape() : this.shape;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void move(Chapter to, double x, double y) {
        new MoveQuestMessage(this.id, to.id, x, y).sendToServer();
    }

    @Override
    public boolean isVisible(TeamData data) {
        block6: {
            block7: {
                if (!this.invisible || data.isCompleted(this)) break block6;
                if (this.invisibleUntilTasks == 0) break block7;
                if (this.tasks.stream().filter(data::isCompleted).limit(this.invisibleUntilTasks).count() >= (long)this.invisibleUntilTasks) break block6;
            }
            return false;
        }
        if (this.dependencies.isEmpty()) {
            return true;
        }
        if (this.hide.get(false)) {
            return data.areDependenciesComplete(this);
        }
        for (QuestObject object : this.dependencies) {
            if (!object.isVisible(data)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.cachedSubtitle = null;
        this.cachedDescription = null;
        for (Task task : this.tasks) {
            task.clearCachedData();
        }
        for (Reward reward : this.rewards) {
            reward.clearCachedData();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getSubtitle() {
        if (this.cachedSubtitle != null) {
            return this.cachedSubtitle;
        }
        this.cachedSubtitle = TextUtils.parseRawText(this.subtitle);
        return this.cachedSubtitle;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component[] getDescription() {
        if (this.cachedDescription != null) {
            return this.cachedDescription;
        }
        this.cachedDescription = new Component[this.description.size()];
        for (int i = 0; i < this.cachedDescription.length; ++i) {
            this.cachedDescription[i] = TextUtils.parseRawText(this.description.get(i));
        }
        return this.cachedDescription;
    }

    public boolean hasDependency(QuestObject object) {
        if (object.invalid) {
            return false;
        }
        for (QuestObject dependency : this.dependencies) {
            if (dependency != object) continue;
            return true;
        }
        return false;
    }

    public void removeInvalidDependencies() {
        if (!this.dependencies.isEmpty()) {
            this.dependencies.removeIf(o -> o == null || o.invalid || o == this);
        }
    }

    public boolean verifyDependencies(boolean autofix) {
        try {
            this.verifyDependenciesInternal(this.id, 0);
            return true;
        }
        catch (DependencyDepthException ex) {
            if (autofix) {
                FTBQuests.LOGGER.error("Too deep dependencies found in " + this + " (referenced in " + ex.object + ")! Deleting all dependencies...");
                this.dependencies.clear();
                this.chapter.file.save();
            } else {
                FTBQuests.LOGGER.error("Too deep dependencies found in " + this + " (referenced in " + ex.object + ")!");
            }
            return false;
        }
        catch (DependencyLoopException ex) {
            if (autofix) {
                FTBQuests.LOGGER.error("Looping dependencies found in " + this + " (referenced in " + ex.object + ")! Deleting all dependencies...");
                this.dependencies.clear();
                this.chapter.file.save();
            } else {
                FTBQuests.LOGGER.error("Looping dependencies found in " + this + " (referenced in " + ex.object + ")!");
            }
            return false;
        }
    }

    @Override
    protected void verifyDependenciesInternal(long original, int depth) {
        if (depth >= 1000) {
            throw new DependencyDepthException(this);
        }
        for (QuestObject dependency : this.dependencies) {
            if (dependency.id == original) {
                throw new DependencyLoopException(this);
            }
            dependency.verifyDependenciesInternal(original, depth + 1);
        }
    }

    @Override
    public int refreshJEI() {
        return FTBQuestsJEIHelper.QUESTS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void editedFromGUI() {
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null) {
            gui.questPanel.refreshWidgets();
            gui.viewQuestPanel.refreshWidgets();
        }
    }

    public void moved(double nx, double ny, long nc) {
        QuestFile f;
        Chapter c;
        this.x = nx;
        this.y = ny;
        if (nc != this.chapter.id && (c = (f = this.getQuestFile()).getChapter(nc)) != null) {
            this.chapter.quests.remove(this);
            c.quests.add(this);
            this.chapter = c;
        }
    }

    public boolean isProgressionIgnored() {
        return this.canRepeat || this.optional;
    }

    public List<QuestObject> getDependants() {
        ArrayList<QuestObject> list = new ArrayList<QuestObject>();
        for (ChapterGroup group : this.chapter.file.chapterGroups) {
            for (Chapter c : group.chapters) {
                for (Quest q : c.quests) {
                    if (!q.dependencies.contains(this)) continue;
                    list.add(q);
                }
            }
        }
        return list;
    }

    public void checkRepeatable(TeamData data, UUID player) {
        if (this.canRepeat && this.rewards.stream().allMatch(r -> data.isRewardClaimed(player, (Reward)r))) {
            ProgressChange change = new ProgressChange(data.file);
            change.reset = true;
            change.origin = this;
            change.player = player;
            this.forceProgress(data, change);
        }
    }

    @Override
    public Collection<? extends QuestObject> getChildren() {
        return this.tasks;
    }

    @Override
    public boolean isCompletedRaw(TeamData data) {
        return data.canStartTasks(this) && super.isCompletedRaw(data);
    }

    @Override
    public boolean hasUnclaimedRewardsRaw(TeamData teamData, UUID player) {
        if (teamData.isCompleted(this)) {
            for (Reward reward : this.rewards) {
                if (teamData.isRewardBlocked(reward) || teamData.getClaimType(player, reward) != RewardClaimType.CAN_CLAIM) continue;
                return true;
            }
        }
        return false;
    }

    public boolean ignoreRewardBlocking() {
        return this.ignoreRewardBlocking;
    }
}

