/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;

public enum QuestObjectType implements Predicate<QuestObjectBase>
{
    NULL("null", ChatFormatting.BLACK),
    FILE("file", ChatFormatting.RED),
    CHAPTER("chapter", ChatFormatting.GOLD),
    QUEST("quest", ChatFormatting.GREEN),
    TASK("task", ChatFormatting.BLUE),
    REWARD("reward", ChatFormatting.LIGHT_PURPLE),
    REWARD_TABLE("reward_table", ChatFormatting.YELLOW),
    CHAPTER_GROUP("chapter_group", ChatFormatting.YELLOW);

    public static final NameMap<QuestObjectType> NAME_MAP;
    public static final Predicate<QuestObjectBase> ALL_PROGRESSING;
    public static final Predicate<QuestObjectBase> ALL_PROGRESSING_OR_NULL;
    public final String id;
    public final String translationKey;
    private final ChatFormatting color;

    private QuestObjectType(String i, ChatFormatting c) {
        this.id = i;
        this.translationKey = "ftbquests." + this.id;
        this.color = c;
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    @Override
    public boolean test(QuestObjectBase object) {
        return (object == null ? NULL : object.getObjectType()) == this;
    }

    static {
        NAME_MAP = NameMap.of((Object)NULL, (Object[])QuestObjectType.values()).id(v -> v.id).nameKey(v -> v.translationKey).create();
        ALL_PROGRESSING = object -> object instanceof QuestObject;
        ALL_PROGRESSING_OR_NULL = object -> object == null || object instanceof QuestObject;
    }
}

