/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.KnownServerRegistries;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AdvancementReward
extends Reward {
    public ResourceLocation advancement = new ResourceLocation("minecraft:story/root");
    public String criterion = "";

    public AdvancementReward(Quest quest) {
        super(quest);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.ADVANCEMENT;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("advancement", this.advancement.toString());
        nbt.m_128359_("criterion", this.criterion);
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.advancement = new ResourceLocation(nbt.m_128461_("advancement"));
        this.criterion = nbt.m_128461_("criterion");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130085_(this.advancement);
        buffer.m_130072_(this.criterion, Short.MAX_VALUE);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.advancement = buffer.m_130281_();
        this.criterion = buffer.m_130136_(Short.MAX_VALUE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        if (KnownServerRegistries.client != null && !KnownServerRegistries.client.advancements.isEmpty()) {
            config.addEnum("advancement", (Object)this.advancement, v -> {
                this.advancement = v;
            }, NameMap.of((Object)((ResourceLocation)KnownServerRegistries.client.advancements.keySet().iterator().next()), (Object[])KnownServerRegistries.client.advancements.keySet().toArray(new ResourceLocation[0])).icon(resourceLocation -> ItemIcon.getItemIcon((ItemStack)((KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements.get((Object)resourceLocation)).icon)).name(resourceLocation -> ((KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements.get((Object)resourceLocation)).name).create()).setNameKey("ftbquests.reward.ftbquests.advancement");
        } else {
            config.addString("advancement", this.advancement.toString(), v -> {
                this.advancement = new ResourceLocation(v);
            }, "minecraft:story/root").setNameKey("ftbquests.reward.ftbquests.advancement");
        }
        config.addString("criterion", this.criterion, v -> {
            this.criterion = v;
        }, "");
    }

    @Override
    public void claim(ServerPlayer player, boolean notify) {
        Advancement a = player.f_8924_.m_129889_().m_136041_(this.advancement);
        if (a != null) {
            if (this.criterion.isEmpty()) {
                for (String s : a.m_138325_().keySet()) {
                    player.m_8960_().m_135988_(a, s);
                }
            } else {
                player.m_8960_().m_135988_(a, this.criterion);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        KnownServerRegistries.AdvancementInfo info;
        KnownServerRegistries.AdvancementInfo advancementInfo = info = KnownServerRegistries.client == null ? null : (KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements.get(this.advancement);
        if (info != null && info.name != TextComponent.f_131282_) {
            return new TranslatableComponent("ftbquests.reward.ftbquests.advancement").m_130946_(": ").m_7220_((Component)info.name.m_6881_().m_130940_(ChatFormatting.YELLOW));
        }
        return super.getAltTitle();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        KnownServerRegistries.AdvancementInfo info;
        KnownServerRegistries.AdvancementInfo advancementInfo = info = KnownServerRegistries.client == null ? null : (KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements.get(this.advancement);
        if (info != null && !info.icon.m_41619_()) {
            return ItemIcon.getItemIcon((ItemStack)info.icon);
        }
        return super.getAltIcon();
    }
}

