/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigListScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class ListConfig<E, CV extends ConfigValue<E>>
extends ConfigValue<List<E>> {
    public static final TextComponent EMPTY_LIST = new TextComponent("[]");
    public static final TextComponent NON_EMPTY_LIST = new TextComponent("[...]");
    public static final Color4I COLOR = Color4I.rgb(16755273);
    public final CV type;

    public ListConfig(CV t) {
        this.type = t;
    }

    @Override
    public List<E> copy(List<E> v) {
        ArrayList<E> list = new ArrayList<E>(v.size());
        for (E value : v) {
            list.add(((ConfigValue)this.type).copy(value));
        }
        return list;
    }

    @Override
    public Color4I getColor(List<E> v) {
        return COLOR;
    }

    @Override
    public void addInfo(TooltipList l) {
        if (!((List)this.value).isEmpty()) {
            l.add(ListConfig.info("List"));
            for (Object value : (List)this.value) {
                l.add(((ConfigValue)this.type).getStringForGUI(value));
            }
            if (!((List)this.defaultValue).isEmpty()) {
                l.blankLine();
            }
        }
        if (!((List)this.defaultValue).isEmpty()) {
            l.add(ListConfig.info("Default"));
            for (Object value : (List)this.defaultValue) {
                l.add(((ConfigValue)this.type).getStringForGUI(value));
            }
        }
    }

    @Override
    public void onClicked(MouseButton button, ConfigCallback callback) {
        new EditConfigListScreen(this, callback).openGui();
    }

    @Override
    public Component getStringForGUI(List<E> v) {
        return v == null ? NULL_TEXT : (v.isEmpty() ? EMPTY_LIST : NON_EMPTY_LIST);
    }
}

