/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.MutableColor4I;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.PixelBuffer;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class Color4I
extends Icon {
    private static final Color4I[] BLACK_A;
    private static final Color4I[] WHITE_A;
    public static final Color4I BLACK;
    public static final Color4I DARK_GRAY;
    public static final Color4I GRAY;
    public static final Color4I WHITE;
    public static final Color4I RED;
    public static final Color4I GREEN;
    public static final Color4I BLUE;
    public static final Color4I LIGHT_RED;
    public static final Color4I LIGHT_GREEN;
    public static final Color4I LIGHT_BLUE;
    private static final Color4I[] CHAT_FORMATTING_COLORS;
    private static final Color4I[] COLORS_256;
    int red;
    int green;
    int blue;
    int alpha;

    public static Color4I getChatFormattingColor(int id) {
        return CHAT_FORMATTING_COLORS[id & 0xF];
    }

    public static Color4I getChatFormattingColor(@Nullable ChatFormatting formatting) {
        return formatting == null ? WHITE : Color4I.getChatFormattingColor(formatting.ordinal());
    }

    public static Color4I get256(int id) {
        return COLORS_256[id & 0xFF];
    }

    public static Color4I fromString(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return EMPTY;
        }
        if ((s.length() == 7 || s.length() == 9) && s.charAt(0) == '#') {
            String hex = s.substring(1);
            return hex.length() == 8 ? Color4I.rgba((int)Long.parseLong(hex, 16)) : Color4I.rgb((int)Long.parseLong(hex, 16));
        }
        if (s.equalsIgnoreCase("transparent")) {
            return WHITE.withAlpha(0);
        }
        if (s.equalsIgnoreCase("black")) {
            return BLACK;
        }
        if (s.equalsIgnoreCase("dark_gray")) {
            return DARK_GRAY;
        }
        if (s.equalsIgnoreCase("gray")) {
            return GRAY;
        }
        if (s.equalsIgnoreCase("white")) {
            return WHITE;
        }
        if (s.equalsIgnoreCase("red")) {
            return RED;
        }
        if (s.equalsIgnoreCase("green")) {
            return GREEN;
        }
        if (s.equalsIgnoreCase("blue")) {
            return BLUE;
        }
        if (s.equalsIgnoreCase("light_red")) {
            return LIGHT_RED;
        }
        if (s.equalsIgnoreCase("light_green")) {
            return LIGHT_GREEN;
        }
        if (s.equalsIgnoreCase("light_blue")) {
            return LIGHT_BLUE;
        }
        return EMPTY;
    }

    public static Color4I fromJson(@Nullable JsonElement element) {
        JsonArray array;
        if (element == null || element.isJsonNull()) {
            return EMPTY;
        }
        if (element.isJsonPrimitive()) {
            return Color4I.fromString(element.getAsString());
        }
        if (element.isJsonArray() && (array = element.getAsJsonArray()).size() >= 3) {
            int r = array.get(0).getAsInt();
            int g = array.get(1).getAsInt();
            int b = array.get(2).getAsInt();
            int a = 255;
            if (array.size() >= 3) {
                a = array.get(3).getAsInt();
            }
            return Color4I.rgba(r, g, b, a);
        }
        JsonObject object = element.getAsJsonObject();
        if (object.has("red") && object.has("green") && object.has("blue")) {
            int r = object.get("red").getAsInt();
            int g = object.get("green").getAsInt();
            int b = object.get("blue").getAsInt();
            int a = 255;
            if (object.has("alpha")) {
                a = object.get("alpha").getAsInt();
            }
            return Color4I.rgba(r, g, b, a);
        }
        return EMPTY;
    }

    public static Color4I rgba(int r, int g, int b, int a) {
        r &= 0xFF;
        g &= 0xFF;
        b &= 0xFF;
        if ((a &= 0xFF) == 0) {
            return EMPTY;
        }
        if (r == 0 && g == 0 && b == 0) {
            return BLACK_A[a];
        }
        if (r == 255 && g == 255 && b == 255) {
            return WHITE_A[a];
        }
        return new Color4I(r, g, b, a);
    }

    public static Color4I rgb(int r, int g, int b) {
        return Color4I.rgba(r, g, b, 255);
    }

    public static Color4I hsb(float h, float s, float b) {
        return Color4I.rgb(Color4I.HSBtoRGB(h, s, b));
    }

    public static Color4I rgba(int col) {
        return Color4I.rgba(col >> 16, col >> 8, col, col >> 24);
    }

    public static Color4I rgb(int col) {
        return Color4I.rgb(col >> 16, col >> 8, col);
    }

    public static Color4I rgb(Vec3 color) {
        return Color4I.rgb((int)(color.f_82479_ * 255.0), (int)(color.f_82480_ * 255.0), (int)(color.f_82481_ * 255.0));
    }

    Color4I(int r, int g, int b, int a) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.alpha = a;
    }

    @Override
    public Color4I copy() {
        return this;
    }

    public boolean isMutable() {
        return false;
    }

    public MutableColor4I mutable() {
        return new MutableColor4I(this.redi(), this.greeni(), this.bluei(), this.alphai());
    }

    public Color4I whiteIfEmpty() {
        return this.isEmpty() ? WHITE : this;
    }

    public int redi() {
        return this.red;
    }

    public int greeni() {
        return this.green;
    }

    public int bluei() {
        return this.blue;
    }

    public int alphai() {
        return this.alpha;
    }

    public float redf() {
        return (float)this.redi() / 255.0f;
    }

    public float greenf() {
        return (float)this.greeni() / 255.0f;
    }

    public float bluef() {
        return (float)this.bluei() / 255.0f;
    }

    public float alphaf() {
        return (float)this.alphai() / 255.0f;
    }

    public int rgba() {
        return this.alphai() << 24 | this.redi() << 16 | this.greeni() << 8 | this.bluei();
    }

    public int rgb() {
        return this.redi() << 16 | this.greeni() << 8 | this.bluei();
    }

    @Override
    public int hashCode() {
        return this.rgba();
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof Color4I && o.hashCode() == this.rgba();
    }

    public String toString() {
        char[] chars;
        int a = this.alphai();
        if (a < 255) {
            chars = new char[9];
            chars[1] = StringUtils.HEX[(a & 0xF0) >> 4];
            chars[2] = StringUtils.HEX[a & 0xF];
            int r = this.redi();
            chars[3] = StringUtils.HEX[(r & 0xF0) >> 4];
            chars[4] = StringUtils.HEX[r & 0xF];
            int g = this.greeni();
            chars[5] = StringUtils.HEX[(g & 0xF0) >> 4];
            chars[6] = StringUtils.HEX[g & 0xF];
            int b = this.bluei();
            chars[7] = StringUtils.HEX[(b & 0xF0) >> 4];
            chars[8] = StringUtils.HEX[b & 0xF];
        } else {
            chars = new char[7];
            int r = this.redi();
            chars[1] = StringUtils.HEX[(r & 0xF0) >> 4];
            chars[2] = StringUtils.HEX[r & 0xF];
            int g = this.greeni();
            chars[3] = StringUtils.HEX[(g & 0xF0) >> 4];
            chars[4] = StringUtils.HEX[g & 0xF];
            int b = this.bluei();
            chars[5] = StringUtils.HEX[(b & 0xF0) >> 4];
            chars[6] = StringUtils.HEX[b & 0xF];
        }
        chars[0] = 35;
        return new String(chars);
    }

    @Override
    public JsonElement getJson() {
        return this.isEmpty() ? JsonNull.INSTANCE : new JsonPrimitive(this.toString());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(PoseStack matrixStack, int x, int y, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x, y, w, h, this);
        tesselator.m_85914_();
        RenderSystem.m_69493_();
    }

    @Override
    public Icon withColor(Color4I color) {
        return color;
    }

    @Override
    public Color4I withTint(Color4I col) {
        if (this.isEmpty()) {
            return this;
        }
        if (col.isEmpty()) {
            return EMPTY;
        }
        if (col.redi() == 255 && col.greeni() == 255 && col.bluei() == 255) {
            return this;
        }
        double a = col.alphaf();
        double r = MathUtils.lerp((double)this.redi(), (double)col.redi(), a);
        double g = MathUtils.lerp((double)this.greeni(), (double)col.greeni(), a);
        double b = MathUtils.lerp((double)this.bluei(), (double)col.bluei(), a);
        return Color4I.rgba((int)r, (int)g, (int)b, this.alpha);
    }

    public Color4I withAlpha(int a) {
        return this.alpha == a ? this : Color4I.rgba(this.redi(), this.greeni(), this.bluei(), a);
    }

    public final Color4I withAlphaf(float alpha) {
        return this.withAlpha((int)(alpha * 255.0f));
    }

    public Color4I lerp(Color4I col, float m) {
        m = Mth.m_14036_((float)m, (float)0.0f, (float)1.0f);
        float r = MathUtils.lerp(this.redf(), col.redf(), m);
        float g = MathUtils.lerp(this.greenf(), col.greenf(), m);
        float b = MathUtils.lerp(this.bluef(), col.bluef(), m);
        float a = MathUtils.lerp(this.alphaf(), col.alphaf(), m);
        return Color4I.rgba((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public Color4I addBrightness(float percent) {
        float[] hsb = new float[3];
        Color4I.RGBtoHSB(this.redi(), this.greeni(), this.bluei(), hsb);
        return Color4I.rgb(Color4I.HSBtoRGB(hsb[0], hsb[1], Mth.m_14036_((float)(hsb[2] + percent), (float)0.0f, (float)1.0f))).withAlpha(this.alphai());
    }

    private static float[] RGBtoHSB(int r, int g, int b, float[] hsbvals) {
        float hue;
        int cmin;
        int cmax;
        if (hsbvals == null) {
            hsbvals = new float[3];
        }
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }

    @Override
    public boolean hasPixelBuffer() {
        return true;
    }

    @Override
    @Nullable
    public PixelBuffer createPixelBuffer() {
        PixelBuffer buffer = new PixelBuffer(1, 1);
        buffer.setRGB(0, 0, this.rgba());
        return buffer;
    }

    public Style toStyle() {
        return Style.f_131099_.m_131148_(TextColor.m_131266_((int)this.rgb()));
    }

    static {
        int i;
        BLACK_A = new Color4I[256];
        WHITE_A = new Color4I[256];
        for (i = 0; i < 256; ++i) {
            Color4I.BLACK_A[i] = new Color4I(0, 0, 0, i){

                @Override
                public Color4I withAlpha(int a) {
                    return this.alpha == a ? this : BLACK_A[a & 0xFF];
                }
            };
            Color4I.WHITE_A[i] = new Color4I(255, 255, 255, i){

                @Override
                public Color4I withAlpha(int a) {
                    return this.alpha == a ? this : WHITE_A[a & 0xFF];
                }
            };
        }
        BLACK = Color4I.rgb(0);
        DARK_GRAY = Color4I.rgb(0x212121);
        GRAY = Color4I.rgb(0x999999);
        WHITE = Color4I.rgb(0xFFFFFF);
        RED = Color4I.rgb(0xFF0000);
        GREEN = Color4I.rgb(65280);
        BLUE = Color4I.rgb(255);
        LIGHT_RED = Color4I.rgb(0xFF5656);
        LIGHT_GREEN = Color4I.rgb(0x56FF56);
        LIGHT_BLUE = Color4I.rgb(0x5656FF);
        CHAT_FORMATTING_COLORS = new Color4I[16];
        COLORS_256 = new Color4I[256];
        for (i = 0; i < 16; ++i) {
            int j = (i >> 3 & 1) * 85;
            int r = (i >> 2 & 1) * 170 + j;
            int g = (i >> 1 & 1) * 170 + j;
            int b = (i & 1) * 170 + j;
            Color4I.CHAT_FORMATTING_COLORS[i] = Color4I.rgb(i == 6 ? r + 85 : r, g, b);
        }
        int[] colors256 = new int[]{0, 0x252525, 0x343434, 0x4E4E4E, 0x686868, 0x757575, 0x8E8E8E, 0xA4A4A4, 0xB8B8B8, 0xC5C5C5, 0xD0D0D0, 0xD7D7D7, 0xE1E1E1, 0xEAEAEA, 0xF4F4F4, 0xFFFFFF, 4268032, 5515264, 7747328, 10113024, 12806150, 14973703, 16748826, 16755485, 16762143, 16764987, 16767052, 16770641, 16774230, 16775536, 0xFFFF90, 0xFFFFAA, 4528388, 7478801, 10429470, 11745824, 13127968, 14903584, 16548128, 16616485, 16685100, 16756280, 16759110, 16760657, 16762477, 16766343, 16770200, 16770731, 6102796, 8004621, 9972750, 11546383, 12531236, 13848106, 15163966, 15953482, 16611412, 16747114, 16750716, 16753803, 16757662, 16761522, 16765123, 16767696, 4855552, 7479040, 11014912, 13115658, 14624018, 15481636, 16405046, 16539976, 16740447, 0xFF7E7E, 0xFF8F8F, 16752030, 16755629, 16759229, 16762830, 16763614, 4784182, 6684747, 8389471, 9768820, 0xAA2288, 12205465, 13258153, 14113462, 14968771, 15692494, 16482010, 16748001, 16752101, 16754151, 0xFFAFEA, 16759020, 4719468, 6030472, 6622608, 8070055, 9649087, 10307017, 10964947, 11688670, 12412393, 12938737, 13530874, 13992959, 14323967, 14589183, 14854655, 15120127, 335489, 403109, 536522, 2506196, 4476126, 5200620, 5925119, 6649343, 7439359, 8425983, 9478399, 9939455, 10466047, 11517695, 12635135, 13489151, 722809, 2104462, 3486115, 4604596, 5723077, 6381007, 7170523, 8091625, 9012727, 9539071, 10262783, 10986751, 11710463, 0xBBB8FF, 12829183, 13881855, 1911130, 1914998, 1919122, 1924268, 1929670, 3311311, 4758489, 5155052, 5617407, 6933247, 7654399, 8573951, 9296639, 10474751, 11854591, 12643327, 19289, 23918, 28548, 33948, 39359, 43978, 48350, 53493, 1105151, 4121087, 6612991, 7793407, 9170431, 10153983, 11662335, 13104895, 18432, 21504, 224003, 947726, 0x188018, 0x279227, 3580982, 5159246, 5360977, 7527026, 8184956, 8777093, 0x99F299, 11794355, 12843459, 0xCDFCCD, 1458176, 1856256, 2319872, 2652160, 3050496, 3840012, 4695321, 5353251, 6076974, 7458627, 8774487, 9300831, 9958761, 10550898, 11665290, 12386202, 2897152, 3687424, 4477440, 4806144, 6320384, 7110400, 7965962, 9150236, 10400303, 11255612, 12110921, 12768851, 13492563, 14413676, 15268985, 15925163, 4602377, 5062409, 5522697, 7100425, 9467401, 11242250, 12689696, 13676591, 14597693, 15124037, 15584588, 16111714, 16507510, 16576152, 16642985, 16643006, 4200962, 5775109, 7349256, 9255443, 11227423, 11887655, 12547888, 13665594, 14783300, 15573070, 16362840, 16562012, 16761184, 16763497, 16764798, 16767638};
        for (int i2 = 0; i2 < 256; ++i2) {
            Color4I.COLORS_256[i2] = Color4I.rgb(colors256[i2]);
        }
    }
}

