/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.SNBTEOFException;
import dev.ftb.mods.ftblibrary.snbt.SNBTSyntaxException;
import dev.ftb.mods.ftblibrary.snbt.SNBTUtils;
import dev.ftb.mods.ftblibrary.snbt.SpecialTag;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

class SNBTParser {
    private final char[] buffer;
    private int position;

    static SNBTCompoundTag read(List<String> lines) {
        SNBTParser parser = new SNBTParser(lines);
        return (SNBTCompoundTag)SpecialTag.unwrap(parser.readTag(parser.nextNS()));
    }

    private SNBTParser(List<String> lines) {
        StringBuilder bufferBuilder = new StringBuilder();
        for (String line : lines) {
            String tline = line.trim();
            if (!tline.startsWith("//") && !tline.startsWith("#")) {
                bufferBuilder.append(line);
            }
            bufferBuilder.append('\n');
        }
        this.buffer = bufferBuilder.toString().toCharArray();
        if (this.buffer.length < 2) {
            throw new SNBTSyntaxException("File has to have at least two characters!");
        }
        this.position = 0;
    }

    private String posString() {
        return this.posString(this.position);
    }

    private String posString(int p) {
        if (p >= this.buffer.length) {
            return "EOF";
        }
        int row = 0;
        int col = 0;
        for (int i = 0; i < p; ++i) {
            if (this.buffer[i] == '\n') {
                ++row;
                col = 0;
                continue;
            }
            ++col;
        }
        return row + 1 + ":" + (col + 1);
    }

    private char next() {
        if (this.position >= this.buffer.length) {
            throw new SNBTEOFException();
        }
        char c = this.buffer[this.position];
        ++this.position;
        return c;
    }

    private char nextNS() {
        char c;
        while ((c = this.next()) <= ' ') {
        }
        return c;
    }

    private Tag readTag(char first) {
        String s;
        switch (first) {
            case '{': {
                return this.readCompound();
            }
            case '[': {
                return this.readCollection();
            }
            case '\"': {
                return StringTag.m_129297_((String)this.readQuotedString('\"'));
            }
            case '\'': {
                return StringTag.m_129297_((String)this.readQuotedString('\''));
            }
        }
        return switch (s = this.readWordString(first)) {
            case "true" -> SpecialTag.TRUE;
            case "false" -> SpecialTag.FALSE;
            case "null", "end", "END" -> EndTag.f_128534_;
            case "Infinity", "Infinityd", "+Infinity", "+Infinityd", "\u221e", "\u221ed", "+\u221e", "+\u221ed" -> SpecialTag.POS_INFINITY_D;
            case "-Infinity", "-Infinityd", "-\u221e", "-\u221ed" -> SpecialTag.NEG_INFINITY_D;
            case "NaN", "NaNd" -> SpecialTag.NAN_D;
            case "Infinityf", "+Infinityf", "\u221ef", "+\u221ef" -> SpecialTag.POS_INFINITY_F;
            case "-Infinityf", "-\u221ef" -> SpecialTag.NEG_INFINITY_F;
            case "NaNf" -> SpecialTag.NAN_F;
            default -> {
                switch (SNBTUtils.getNumberType(s)) {
                    case 1: {
                        yield ByteTag.m_128266_((byte)Byte.parseByte(s.substring(0, s.length() - 1)));
                    }
                    case 2: {
                        yield ShortTag.m_129258_((short)Short.parseShort(s.substring(0, s.length() - 1)));
                    }
                    case 3: {
                        yield IntTag.m_128679_((int)Integer.parseInt(s));
                    }
                    case 4: {
                        yield LongTag.m_128882_((long)Long.parseLong(s.substring(0, s.length() - 1)));
                    }
                    case 5: {
                        yield FloatTag.m_128566_((float)Float.parseFloat(s.substring(0, s.length() - 1)));
                    }
                    case 6: {
                        yield DoubleTag.m_128500_((double)Double.parseDouble(s.substring(0, s.length() - 1)));
                    }
                    case -6: {
                        yield DoubleTag.m_128500_((double)Double.parseDouble(s));
                    }
                }
                yield StringTag.m_129297_((String)s);
            }
        };
    }

    private SNBTCompoundTag readCompound() {
        char n;
        SNBTCompoundTag tag = new SNBTCompoundTag();
        while (true) {
            char c;
            if ((c = this.nextNS()) == '}') {
                return tag;
            }
            if (c == ',' || c == '\n') continue;
            String key = c == '\"' ? this.readQuotedString('\"') : (c == '\'' ? this.readQuotedString('\'') : this.readWordString(c));
            n = this.nextNS();
            if (n != ':' && n != '=') break;
            Tag t = this.readTag(this.nextNS());
            if (t == SpecialTag.TRUE) {
                tag.getOrCreateProperties((String)key).valueType = 2;
            } else if (t == SpecialTag.FALSE) {
                tag.getOrCreateProperties((String)key).valueType = 1;
            }
            tag.m_128365_(key, SpecialTag.unwrap(t));
        }
        throw new SNBTSyntaxException("Expected ':', got '" + n + "' @ " + this.posString());
    }

    private CollectionTag<?> readCollection() {
        int prevPos = this.position;
        char next1 = this.nextNS();
        char next2 = this.nextNS();
        if (next2 == ';' && (next1 == 'I' || next1 == 'i' || next1 == 'L' || next1 == 'l' || next1 == 'B' || next1 == 'b')) {
            return this.readArray(prevPos, next1);
        }
        this.position = prevPos;
        return this.readList();
    }

    private ListTag readList() {
        ListTag tag = new ListTag();
        while (true) {
            int prevPos = this.position;
            char c = this.nextNS();
            if (c == ']') {
                return tag;
            }
            if (c == ',') continue;
            Tag t = SpecialTag.unwrap(this.readTag(c));
            try {
                tag.add((Object)t);
            }
            catch (UnsupportedOperationException ex) {
                throw new SNBTSyntaxException("Unexpected tag '" + t + "' in list @ " + this.posString(prevPos) + " - can't mix two different tag types in a list!");
            }
        }
    }

    private CollectionTag<?> readArray(int pos, char type) {
        Tag t;
        ArrayList<Number> listOfNumbers = new ArrayList<Number>();
        while (true) {
            char c;
            if ((c = this.nextNS()) == ']') {
                return switch (type) {
                    case 'I', 'i' -> new IntArrayTag(listOfNumbers);
                    case 'L', 'l' -> new LongArrayTag(listOfNumbers);
                    case 'B', 'b' -> new ByteArrayTag(listOfNumbers);
                    default -> throw new SNBTSyntaxException("Unknown array type: " + type + " @ " + this.posString(pos));
                };
            }
            if (c == ',') continue;
            t = SpecialTag.unwrap(this.readTag(c));
            if (!(t instanceof NumericTag)) break;
            switch (type) {
                case 'I': 
                case 'i': {
                    listOfNumbers.add(((NumericTag)t).m_7047_());
                    break;
                }
                case 'L': 
                case 'l': {
                    listOfNumbers.add(((NumericTag)t).m_7046_());
                    break;
                }
                case 'B': 
                case 'b': {
                    listOfNumbers.add(((NumericTag)t).m_7063_());
                }
            }
        }
        throw new SNBTSyntaxException("Unexpected tag '" + t + "' in list @ " + this.posString() + " - expected a numeric tag!");
    }

    private String readWordString(char first) {
        char c;
        StringBuilder sb = new StringBuilder();
        sb.append(first);
        while (SNBTUtils.isSimpleCharacter(c = this.next())) {
            sb.append(c);
        }
        --this.position;
        return sb.toString();
    }

    private String readQuotedString(char stop) {
        StringBuilder sb = new StringBuilder();
        boolean escape = false;
        while (true) {
            char c;
            if ((c = this.next()) == '\n') {
                throw new SNBTSyntaxException("New line without closing string with " + stop + " @ " + this.posString(this.position - 1) + "!");
            }
            if (escape) {
                escape = false;
                if (SNBTUtils.REVERSE_ESCAPE_CHARS[c] == '\u0000') continue;
                sb.append(SNBTUtils.REVERSE_ESCAPE_CHARS[c]);
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c == stop) {
                return sb.toString();
            }
            sb.append(c);
        }
    }
}

