/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.CursorType;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;

public class TextBox
extends Widget {
    private boolean isFocused = false;
    public int charLimit = 2000;
    public Color4I textColor = Icon.EMPTY;
    public String ghostText = "";
    private String text = "";
    private int lineScrollOffset;
    private int cursorPosition;
    private int selectionEnd;
    private boolean validText;

    public TextBox(Panel panel) {
        super(panel);
        this.setText("", false);
    }

    public final boolean isFocused() {
        return this.isFocused;
    }

    public final void setFocused(boolean v) {
        this.isFocused = v;
        this.validText = this.isValid(this.text);
        Minecraft.m_91087_().f_91068_.m_90926_(this.isFocused);
    }

    @Override
    public void onClosed() {
        Minecraft.m_91087_().f_91068_.m_90926_(false);
    }

    public final String getText() {
        return this.text;
    }

    public String getSelectedText() {
        return this.text.substring(Math.min(this.cursorPosition, this.selectionEnd), Math.max(this.cursorPosition, this.selectionEnd));
    }

    public final void setText(String s, boolean triggerChange) {
        this.text = s;
        if (this.text.isEmpty()) {
            this.lineScrollOffset = 0;
            this.cursorPosition = 0;
            this.selectionEnd = 0;
        }
        this.validText = this.isValid(s);
        if (this.validText && triggerChange) {
            this.onTextChanged();
        }
    }

    public final void setText(String s) {
        this.setText(s, true);
    }

    public void setCursorPosition(int pos) {
        this.cursorPosition = pos;
        int i = this.text.length();
        this.cursorPosition = Mth.m_14045_((int)this.cursorPosition, (int)0, (int)i);
        this.setSelectionPos(this.cursorPosition);
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.selectionEnd + num);
    }

    public void writeText(String textToWrite) {
        int l;
        if (!textToWrite.isEmpty() && !this.allowInput()) {
            return;
        }
        Object s = "";
        String s1 = SharedConstants.m_136190_((String)textToWrite);
        int i = Math.min(this.cursorPosition, this.selectionEnd);
        int j = Math.max(this.cursorPosition, this.selectionEnd);
        int k = this.charLimit - this.text.length() - (i - j);
        if (!this.text.isEmpty()) {
            s = (String)s + this.text.substring(0, i);
        }
        if (k < s1.length()) {
            s = (String)s + s1.substring(0, k);
            l = k;
        } else {
            s = (String)s + s1;
            l = s1.length();
        }
        if (!this.text.isEmpty() && j < this.text.length()) {
            s = (String)s + this.text.substring(j);
        }
        this.setText((String)s);
        this.moveCursorBy(i - this.selectionEnd + l);
    }

    public void setSelectionPos(int position) {
        int i = this.text.length();
        if (position > i) {
            position = i;
        }
        if (position < 0) {
            position = 0;
        }
        this.selectionEnd = position;
        if (this.lineScrollOffset > i) {
            this.lineScrollOffset = i;
        }
        int j = this.width - 10;
        Theme theme = this.getGui().getTheme();
        String s = theme.trimStringToWidth(this.text.substring(this.lineScrollOffset), j);
        int k = s.length() + this.lineScrollOffset;
        if (position == this.lineScrollOffset) {
            this.lineScrollOffset -= theme.trimStringToWidthReverse(this.text, j).length();
        }
        if (position > k) {
            this.lineScrollOffset += position - k;
        } else if (position <= this.lineScrollOffset) {
            this.lineScrollOffset -= this.lineScrollOffset - position;
        }
        this.lineScrollOffset = Mth.m_14045_((int)this.lineScrollOffset, (int)0, (int)i);
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.cursorPosition);
    }

    public int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    public int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public boolean allowInput() {
        return true;
    }

    public void deleteWords(int num) {
        if (!this.text.isEmpty() && this.allowInput()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (this.text.isEmpty() || !this.allowInput()) {
            return;
        }
        if (this.selectionEnd != this.cursorPosition) {
            this.writeText("");
        } else {
            boolean flag = num < 0;
            int i = flag ? this.cursorPosition + num : this.cursorPosition;
            int j = flag ? this.cursorPosition : this.cursorPosition + num;
            Object s = "";
            if (i >= 0) {
                s = this.text.substring(0, i);
            }
            if (j < this.text.length()) {
                s = (String)s + this.text.substring(j);
            }
            this.setText((String)s);
            if (flag) {
                this.moveCursorBy(num);
            }
        }
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            this.setFocused(true);
            Minecraft.m_91087_().f_91068_.m_90926_(true);
            if (button.isLeft()) {
                if (this.isFocused) {
                    int i = this.getMouseX() - this.getX();
                    Theme theme = this.getGui().getTheme();
                    String s = theme.trimStringToWidth(this.text.substring(this.lineScrollOffset), this.width);
                    if (TextBox.isShiftKeyDown()) {
                        this.setSelectionPos(theme.trimStringToWidth(s, i).length() + this.lineScrollOffset);
                    } else {
                        this.setCursorPosition(theme.trimStringToWidth(s, i).length() + this.lineScrollOffset);
                    }
                }
            } else if (button.isRight() && this.getText().length() > 0 && this.allowInput()) {
                this.setText("");
            }
            return true;
        }
        Minecraft.m_91087_().f_91068_.m_90926_(false);
        this.setFocused(false);
        return false;
    }

    @Override
    public boolean keyPressed(Key key) {
        if (!this.isFocused()) {
            return false;
        }
        if (key.selectAll()) {
            this.setCursorPosition(this.text.length());
            this.setSelectionPos(0);
            return true;
        }
        if (key.copy()) {
            TextBox.setClipboardString(this.getSelectedText());
            return true;
        }
        if (key.paste()) {
            this.writeText(TextBox.getClipboardString());
            return true;
        }
        if (key.cut()) {
            TextBox.setClipboardString(this.getSelectedText());
            this.writeText("");
            return true;
        }
        switch (key.keyCode) {
            case 256: {
                this.setFocused(false);
                return true;
            }
            case 259: {
                if (key.modifiers.control()) {
                    this.deleteWords(-1);
                } else {
                    this.deleteFromCursor(-1);
                }
                return true;
            }
            case 268: {
                if (key.modifiers.shift()) {
                    this.setSelectionPos(0);
                } else {
                    this.setCursorPosition(0);
                }
                return true;
            }
            case 263: {
                if (key.modifiers.shift()) {
                    if (key.modifiers.control()) {
                        this.setSelectionPos(this.getNthWordFromPos(-1, this.selectionEnd));
                    } else {
                        this.setSelectionPos(this.selectionEnd - 1);
                    }
                } else if (key.modifiers.control()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 262: {
                if (key.modifiers.shift()) {
                    if (key.modifiers.control()) {
                        this.setSelectionPos(this.getNthWordFromPos(1, this.selectionEnd));
                    } else {
                        this.setSelectionPos(this.selectionEnd + 1);
                    }
                } else if (key.modifiers.control()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 269: {
                if (key.modifiers.shift()) {
                    this.setSelectionPos(this.text.length());
                } else {
                    this.setCursorPosition(this.text.length());
                }
                return true;
            }
            case 261: {
                if (key.modifiers.control()) {
                    this.deleteWords(1);
                } else {
                    this.deleteFromCursor(1);
                }
                return true;
            }
            case 257: {
                if (this.validText) {
                    this.setFocused(false);
                    this.onEnterPressed();
                }
                return true;
            }
            case 258: {
                if (this.validText) {
                    this.setFocused(false);
                    this.onTabPressed();
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean charTyped(char c, KeyModifiers modifiers) {
        if (this.isFocused()) {
            if (SharedConstants.m_136188_((char)c)) {
                this.writeText(Character.toString(c));
            }
            return true;
        }
        return false;
    }

    public void onTextChanged() {
    }

    public void onTabPressed() {
    }

    public void onEnterPressed() {
    }

    public String getFormattedText() {
        return !this.isFocused() && this.text.isEmpty() && !this.ghostText.isEmpty() ? ChatFormatting.ITALIC + this.ghostText : this.text;
    }

    @Override
    public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        this.drawTextBox(matrixStack, theme, x, y, w, h);
        boolean drawGhostText = !this.isFocused() && this.text.isEmpty() && !this.ghostText.isEmpty();
        String textToDraw = this.getFormattedText();
        GuiHelper.pushScissor(this.getScreen(), x, y, w, h);
        Color4I col = this.validText ? (this.textColor.isEmpty() ? theme.getContentColor(WidgetType.NORMAL) : this.textColor).withAlpha(drawGhostText ? 120 : 255) : Color4I.RED;
        int j = this.cursorPosition - this.lineScrollOffset;
        int k = this.selectionEnd - this.lineScrollOffset;
        String s = theme.trimStringToWidth(textToDraw.substring(this.lineScrollOffset), w);
        int textX = x + 4;
        int textY = y + (h - 8) / 2;
        int textX1 = textX;
        if (k > s.length()) {
            k = s.length();
        }
        if (!s.isEmpty()) {
            String s1 = j > 0 && j <= s.length() ? s.substring(0, j) : s;
            textX1 = theme.drawString(matrixStack, new TextComponent(s1), textX, textY, col, 0);
        }
        boolean drawCursor = this.cursorPosition < textToDraw.length() || textToDraw.length() >= this.charLimit;
        int cursorX = textX1;
        if (j <= 0 || j > s.length()) {
            cursorX = j > 0 ? textX + w : textX;
        } else if (drawCursor) {
            cursorX = textX1 - 1;
        }
        if (j > 0 && j < s.length()) {
            theme.drawString(matrixStack, new TextComponent(s.substring(j)), textX1, textY, col, 0);
        }
        if (j >= 0 && j <= s.length() && this.isFocused() && System.currentTimeMillis() % 1000L > 500L) {
            if (drawCursor) {
                col.draw(matrixStack, cursorX, textY - 1, 1, theme.getFontHeight() + 2);
            } else {
                col.draw(matrixStack, cursorX, textY + theme.getFontHeight() - 2, 5, 1);
            }
        }
        if (k != j) {
            int l1 = textX + theme.getStringWidth((FormattedText)new TextComponent(s.substring(0, k)));
            int startX = cursorX;
            int startY = textY - 1;
            int endX = l1 - 1;
            int endY = textY + 1 + theme.getFontHeight();
            if (startX < endX) {
                int i = startX;
                startX = endX;
                endX = i;
            }
            if (startY < endY) {
                int j12 = startY;
                startY = endY;
                endY = j12;
            }
            if (endX > x + w) {
                endX = x + w;
            }
            if (startX > x + w) {
                startX = x + w;
            }
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferBuilder = tesselator.m_85915_();
            RenderSystem.m_157427_(GameRenderer::m_172808_);
            RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69472_();
            RenderSystem.m_69479_();
            RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
            bufferBuilder.m_5483_((double)startX, (double)endY, 0.0).m_5752_();
            bufferBuilder.m_5483_((double)endX, (double)endY, 0.0).m_5752_();
            bufferBuilder.m_5483_((double)endX, (double)startY, 0.0).m_5752_();
            bufferBuilder.m_5483_((double)startX, (double)startY, 0.0).m_5752_();
            tesselator.m_85914_();
            RenderSystem.m_69462_();
            RenderSystem.m_69493_();
        }
        GuiHelper.popScissor(this.getScreen());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawTextBox(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        theme.drawTextBox(matrixStack, x, y, w, h);
    }

    public boolean isValid(String txt) {
        return true;
    }

    public final boolean isTextValid() {
        return this.validText;
    }

    @Override
    public CursorType getCursor() {
        return CursorType.IBEAM;
    }
}

