/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.property;

import dev.ftb.mods.ftbteams.event.TeamCollectPropertiesEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import dev.ftb.mods.ftbteams.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.property.TeamPropertyValue;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class TeamProperties {
    public final Map<TeamProperty, TeamPropertyValue> map = new HashMap<TeamProperty, TeamPropertyValue>();

    public TeamProperties collect() {
        this.map.clear();
        ((Consumer)TeamEvent.COLLECT_PROPERTIES.invoker()).accept(new TeamCollectPropertiesEvent(prop -> this.map.put((TeamProperty)prop, new TeamPropertyValue(prop, prop.defaultValue))));
        return this;
    }

    public TeamProperties copy() {
        TeamProperties p = new TeamProperties();
        for (Map.Entry<TeamProperty, TeamPropertyValue> entry : this.map.entrySet()) {
            p.map.put(entry.getKey(), entry.getValue().copy());
        }
        return p;
    }

    public TeamProperties updateFrom(TeamProperties properties) {
        for (Map.Entry<TeamProperty, TeamPropertyValue> entry : properties.map.entrySet()) {
            this.set(entry.getKey(), entry.getValue().value);
        }
        return this;
    }

    public <T> T get(TeamProperty<T> key) {
        TeamPropertyValue v = this.map.get(key);
        return v == null ? key.defaultValue : v.value;
    }

    public <T> void set(TeamProperty<T> key, T value) {
        this.map.computeIfAbsent(key, (Function<TeamProperty, TeamPropertyValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(dev.ftb.mods.ftbteams.property.TeamProperty<T> ), (Ldev/ftb/mods/ftbteams/property/TeamProperty;)Ldev/ftb/mods/ftbteams/property/TeamPropertyValue;)()).value = value;
    }

    public void read(FriendlyByteBuf buffer) {
        int p = buffer.m_130242_();
        this.map.clear();
        for (int i = 0; i < p; ++i) {
            TeamProperty tp = TeamPropertyType.MAP.get((Object)buffer.m_130136_((int)Short.MAX_VALUE)).deserializer.apply(buffer.m_130281_(), buffer);
            this.map.put(tp, new TeamPropertyValue(tp, tp.readValue(buffer)));
        }
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.map.size());
        for (Map.Entry<TeamProperty, TeamPropertyValue> entry : this.map.entrySet()) {
            TeamPropertyType.write(buffer, entry.getKey());
            entry.getKey().writeValue(buffer, entry.getValue().value);
        }
    }

    public void read(CompoundTag tag) {
        for (String key : tag.m_128431_()) {
            TeamPropertyValue property = this.findValue(key);
            if (property == null) continue;
            Optional optional = property.key.fromNBT(tag.m_128423_(key));
            if (optional.isPresent()) {
                property.value = optional.get();
                continue;
            }
            property.value = property.key.defaultValue;
        }
    }

    @Nullable
    private TeamPropertyValue findValue(String key) {
        ResourceLocation id = new ResourceLocation(key);
        for (Map.Entry<TeamProperty, TeamPropertyValue> entry : this.map.entrySet()) {
            if (!entry.getKey().id.equals((Object)id)) continue;
            return entry.getValue();
        }
        return null;
    }

    public CompoundTag write(CompoundTag tag) {
        for (Map.Entry<TeamProperty, TeamPropertyValue> entry : this.map.entrySet()) {
            tag.m_128365_(entry.getKey().id.toString(), entry.getKey().toNBT(entry.getValue().value));
        }
        return tag;
    }
}

